/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.connection.internal.ui.wizards;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.rdb.connection.internal.ui.factories.RSCCoreUIWidgetFactory;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;

/**
 * Provides a connection URL details panel for a specific connection information page
 * of the New Connection Wizard.
 * The New Connection Wizard (or subclass) is expected to set one of these for each driver type.
 * <p>
 * Implementations of this interface should wrap rather than extend Composite
 * because they must support lazy instantiation of a Composite that contains
 * their UI components; the Composite may not be instantiated until a getComposite call
 * occurs.
 * <p>
 * @version 1.0
 */
public interface INewCWURLDetails
{
	/** Type for any other driver. */
	public static int DRIVER_TYPE_OTHER = 0;
	/** Type for local database (not alias) driver. */
	public static int DRIVER_TYPE_1 = 1;
	/** Type for app or jcc type 2. */
	public static int DRIVER_TYPE_2 = 2;
	/** Type for net or jcc type 4. */
	public static int DRIVER_TYPE_4 = 4;
   /** Type for Informix, requiring a server name. */
   public static int DRIVER_TYPE_5 = 5;
   /** Type for Informix, requiring a create checkbox. */
   public static int DRIVER_TYPE_5C = 6;
	
	/** The panel needs to call its page for validation, etc. */
	public abstract void setParentPage(RDBWizardPage parentPage);
	public abstract void addListeners();
	public abstract void removeListeners();
	//public abstract void setDriver(JDBCDriver driver);
	public abstract void setOtherArgs(String[] args);
	/**
	 * @param parent The parent for the Composite returned.
	 * @return A composite containing the components to be displayed.
	 */
	public abstract Composite getComposite(Composite parent, RSCCoreUIWidgetFactory factory);
	/**
	 * @return The code for the driver type. This code must be unique.
	 * Predefined driver types specified as constants in this interface.
	 */
	public abstract int getDriverType();
   /**
    * Fills all the entry fields with information from the passed connection.
    */
   public abstract void fillFromConnection(ConnectionInfo connection);
   /**
	 * Sets the connection details.
	 * @param connection An RDBConnection object to reflect
	 * the choices in this panel.
	 */
	public abstract void setConnectionDetails(ConnectionInfo connection);
   /**
    * Sets summary key-value pairs.
    */
   public abstract void setSummaryDetails();
	/**
    * Populates the GUI.
    */
   public void populateGUI();
   /**
    * @return True if the all components visible in the composite are complete.
    */
   public abstract boolean determinePageCompletion();

   /**
	 * Loads widget values from values saved by the previous instance
	 * of this class.
	public abstract void internalLoadWidgetValues();
	 */
   /**
	 * Saves widget values for the next instance of this class.
    */
	public abstract void internalSaveWidgetValues();
   
}
