/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.refactor.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class ProjectRefactorMetadata {
    public static int NON_CACHING = 0;
    public static int REF_CACHING = 1;
    public static int REFERER_CACHING = 2;
    private int _virtualCompCaching = NON_CACHING;
    private final IProject _project;
    private IServer[] servers;
    private IVirtualComponent virtualComp = null;
    private final List dependentMetadata = new ArrayList();
    private boolean javaNature;
    private boolean moduleCoreNature;
    private IModule module;
    private Set facets = new HashSet();
    private final Map earToModuleURI = new HashMap();

    public ProjectRefactorMetadata(IProject project) {
        this._project = project;
    }

    public ProjectRefactorMetadata(IProject project, int virtualCompCaching) {
        this(project);
        this._virtualCompCaching = virtualCompCaching;
    }

    public void computeMetadata() {
        try {
            this.javaNature = this._project.hasNature("org.eclipse.jdt.core.javanature");
            boolean bl = this.moduleCoreNature = ModuleCoreNature.getModuleCoreNature((IProject)this._project) != null;
            if (this.moduleCoreNature) {
                this.virtualComp = this._virtualCompCaching == REF_CACHING ? new RefCachingVirtualComponent(ComponentCore.createComponent((IProject)this._project)) : (this._virtualCompCaching == REFERER_CACHING ? new RefererCachingVirtualComponent(ComponentCore.createComponent((IProject)this._project)) : ComponentCore.createComponent((IProject)this._project));
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this._project);
                this.module = ServerUtil.getModule((IProject)this._project);
                this.facets = facetedProject.getProjectFacets();
            }
        }
        catch (CoreException ce) {
            Logger.getLogger().logError((Throwable)ce);
        }
    }

    public void computeServers() {
        this.servers = ServerUtil.getServersByModule((IModule)this.module, null);
    }

    public IServer[] getServers() {
        return this.servers;
    }

    public void computeDependentMetadata(int virtualComponentCaching, IProject[] dependentProjects) {
        int i = 0;
        while (i < dependentProjects.length) {
            IProject dependentProject = dependentProjects[i];
            if (dependentProject.exists() && dependentProject.isOpen()) {
                String uri;
                ProjectRefactorMetadata metadata = new ProjectRefactorMetadata(dependentProjects[i], virtualComponentCaching);
                metadata.computeMetadata();
                this.dependentMetadata.add(metadata);
                if (metadata.isEAR() && (uri = this.getModuleURI(dependentProject, this.virtualComp)) != null) {
                    this.earToModuleURI.put(dependentProject.getName(), uri);
                }
            }
            ++i;
        }
    }

    public String getModuleURI(String earName) {
        return (String)this.earToModuleURI.get(earName);
    }

    /*
     * Exception decompiling
     */
    private String getModuleURI(IProject earProject, IVirtualComponent comp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 61->64)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IProject getProject() {
        return this._project;
    }

    public IModule getModule() {
        return this.module;
    }

    public String getProjectName() {
        return this._project.getName();
    }

    public ProjectRefactorMetadata[] getDependentMetadata() {
        return this.dependentMetadata.toArray(new ProjectRefactorMetadata[this.dependentMetadata.size()]);
    }

    public IVirtualComponent getVirtualComponent() {
        return this.virtualComp;
    }

    public boolean hasJavaNature() {
        return this.javaNature;
    }

    public boolean hasModuleCoreNature() {
        return this.moduleCoreNature;
    }

    public Set getProjectFacets() {
        return this.facets;
    }

    public boolean hasFacet(IProjectFacet facet) {
        Iterator itr = this.facets.iterator();
        while (itr.hasNext()) {
            IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
            if (fv.getProjectFacet() != facet) continue;
            return true;
        }
        return false;
    }

    public boolean isEAR() {
        return this.hasFacet(ProjectFacetsManager.getProjectFacet((String)"jst.ear"));
    }

    public boolean isEJB() {
        return this.hasFacet(ProjectFacetsManager.getProjectFacet((String)"jst.ejb"));
    }

    public boolean isWeb() {
        return this.hasFacet(ProjectFacetsManager.getProjectFacet((String)"jst.web"));
    }

    public boolean isAppClient() {
        return this.hasFacet(ProjectFacetsManager.getProjectFacet((String)"jst.appclient"));
    }

    public boolean isConnector() {
        return this.hasFacet(ProjectFacetsManager.getProjectFacet((String)"jst.connector"));
    }

    public boolean isUtility() {
        return this.hasFacet(ProjectFacetsManager.getProjectFacet((String)"jst.utility"));
    }

    public class CachingVirtualComponent
    implements IVirtualComponent {
        protected final IVirtualComponent _comp;
        protected boolean _caching = true;

        public CachingVirtualComponent(IVirtualComponent comp) {
            this._comp = comp;
        }

        public void addReferences(IVirtualReference[] references) {
            this._comp.addReferences(references);
        }

        public void create(int updateFlags, IProgressMonitor aMonitor) throws CoreException {
            this._comp.create(updateFlags, aMonitor);
        }

        public boolean exists() {
            return this._comp.exists();
        }

        public IVirtualComponent getComponent() {
            return this._comp.getComponent();
        }

        public Properties getMetaProperties() {
            return this._comp.getMetaProperties();
        }

        public IPath[] getMetaResources() {
            return this._comp.getMetaResources();
        }

        public String getName() {
            return this._comp.getName();
        }

        public String getDeployedName() {
            return this._comp.getDeployedName();
        }

        public IProject getProject() {
            return this._comp.getProject();
        }

        public IVirtualReference getReference(String aComponentName) {
            return this._comp.getReference(aComponentName);
        }

        public IVirtualReference[] getReferences() {
            return this._comp.getReferences();
        }

        public void setCaching(boolean caching) {
            this._caching = caching;
        }

        public IVirtualComponent[] getReferencingComponents() {
            return this._comp.getReferencingComponents();
        }

        public IVirtualFolder getRootFolder() {
            return this._comp.getRootFolder();
        }

        public boolean isBinary() {
            return this._comp.isBinary();
        }

        public void setMetaProperties(Properties properties) {
            this._comp.setMetaProperties(properties);
        }

        public void setMetaProperty(String name, String value) {
            this._comp.setMetaProperty(name, value);
        }

        public void setMetaResources(IPath[] theMetaResourcePaths) {
            this._comp.setMetaResources(theMetaResourcePaths);
        }

        public void setReferences(IVirtualReference[] theReferences) {
            this._comp.setReferences(theReferences);
        }

        public Object getAdapter(Class adapter) {
            return this._comp.getAdapter(adapter);
        }

        public boolean equals(Object o) {
            return this._comp.equals(o);
        }

        public int hashCode() {
            return this._comp.hashCode();
        }

        public String toString() {
            return this._comp.toString();
        }

        public void removeReference(IVirtualReference aReference) {
            ((VirtualComponent)this._comp).removeReference(aReference);
        }
    }

    public class RefCachingVirtualComponent
    extends CachingVirtualComponent {
        private IVirtualReference[] cachedRefs;

        public RefCachingVirtualComponent(IVirtualComponent comp) {
            super(comp);
            this.cachedRefs = ((VirtualComponent)comp).getAllReferences();
        }

        public IVirtualReference getReference(String aComponentName) {
            IVirtualReference[] refs = this.getReferences();
            int i = 0;
            while (i < refs.length) {
                IVirtualReference reference = refs[i];
                if (reference == null || reference.getReferencedComponent() == null) {
                    return null;
                }
                if (reference.getReferencedComponent().getName().equals(aComponentName)) {
                    return reference;
                }
                ++i;
            }
            return null;
        }

        public IVirtualReference[] getReferences() {
            if (this._caching) {
                return this.cachedRefs;
            }
            return super.getReferences();
        }
    }

    public class RefererCachingVirtualComponent
    extends CachingVirtualComponent {
        private IVirtualComponent[] cachedReferers;

        public RefererCachingVirtualComponent(IVirtualComponent comp) {
            super(comp);
            this.cachedReferers = comp.getReferencingComponents();
        }

        public IVirtualComponent[] getReferencingComponents() {
            if (this._caching) {
                return this.cachedReferers;
            }
            return this._comp.getReferencingComponents();
        }
    }
}

