/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidationSelectionHandlerRegistryReader;
import org.eclipse.wst.validation.internal.operations.ManualIncrementalValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.ManualValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.ui.ResourceHandler;
import org.eclipse.wst.validation.internal.ui.SaveFilesDialog;
import org.eclipse.wst.validation.internal.ui.SaveFilesHelper;
import org.eclipse.wst.validation.internal.ui.ValidateAction;
import org.eclipse.wst.validation.internal.ui.ValidationJob;
import org.eclipse.wst.validation.internal.ui.ValidationUIMessages;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;

public class ValidationMenuAction
implements IViewActionDelegate {
    private ISelection _currentSelection = null;
    protected static final String SEP = "/";
    private Display _currentDisplay = Display.getCurrent();
    private IResourceVisitor _folderVisitor = null;
    private IResourceVisitor _projectVisitor = null;
    private Map _selectedResources = new HashMap();

    private Display getDisplay() {
        return this._currentDisplay == null ? Display.getCurrent() : this._currentDisplay;
    }

    Shell getShell() {
        Shell[] shells;
        Shell shell;
        Display display = this.getDisplay();
        Shell shell2 = shell = display == null ? null : display.getActiveShell();
        if (shell == null && display != null && (shells = display.getShells()).length > 0) {
            shell = shells[0];
        }
        return shell;
    }

    private ISelection getCurrentSelection() {
        return this._currentSelection;
    }

    private Map loadSelected(ValidateAction action, boolean refresh) {
        ISelection selection;
        if (refresh) {
            this._selectedResources.clear();
        }
        if ((selection = this.getCurrentSelection()) == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object[] elements = ((IStructuredSelection)selection).toArray();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element != null) {
                this.addSelected(action, element);
            }
            ++i;
        }
        return this._selectedResources;
    }

    private void addSelected(ValidateAction action, Object selected) {
        if (selected instanceof IProject) {
            this.addVisitor((IProject)selected);
        } else if (selected instanceof IFile) {
            this.addSelected((IResource)((IFile)selected));
        } else if (selected instanceof IFolder) {
            this.addVisitor((IFolder)selected);
        } else if (this.isValidType(this.getExtendedType(selected))) {
            this.addSelected(action, this.getExtendedType(selected));
        } else {
            IResource[] resources;
            boolean valid = false;
            if (action != null && (resources = action.getResource(selected)) != null) {
                valid = true;
                int i = 0;
                while (i < resources.length) {
                    this.addSelected(action, resources[i]);
                    ++i;
                }
            }
            if (!valid) {
                this._selectedResources.clear();
            }
        }
    }

    private Object getExtendedType(Object selected) {
        Object result = ValidationSelectionHandlerRegistryReader.getInstance().getExtendedType(selected);
        return result == null ? selected : result;
    }

    private boolean isValidType(Object object) {
        return object instanceof IProject || object instanceof IFile || object instanceof IFolder;
    }

    void addSelected(IResource selected) {
        IProject project = selected.getProject();
        boolean added = this._selectedResources.containsKey(project);
        Set<Object> changedRes = null;
        if (added) {
            changedRes = (Set)this._selectedResources.get(project);
            if (changedRes == null) {
                return;
            }
        } else {
            changedRes = new HashSet<IResource>();
        }
        if (changedRes.add(selected)) {
            this._selectedResources.put(project, changedRes);
        }
    }

    private void addVisitor(IFolder selected) {
        try {
            selected.accept(this.getFolderVisitor());
        }
        catch (CoreException exc) {
            Logger logger = WTPUIPlugin.getLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationUIPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidationMenuAction.addSelected(IFolder)");
                entry.setMessageTypeIdentifier("VBF_EXC_INTERNAL");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return;
        }
    }

    private IResourceVisitor getFolderVisitor() {
        if (this._folderVisitor == null) {
            this._folderVisitor = new IResourceVisitor(){

                public boolean visit(IResource res) {
                    if (res instanceof IFile) {
                        ValidationMenuAction.this.addSelected(res);
                    } else if (res instanceof IFolder) {
                        ValidationMenuAction.this.addSelected(res);
                    }
                    return true;
                }
            };
        }
        return this._folderVisitor;
    }

    private void addVisitor(IProject selected) {
        if (!selected.isAccessible()) {
            return;
        }
        try {
            selected.accept(this.getProjectVisitor());
        }
        catch (CoreException exc) {
            Logger logger = WTPUIPlugin.getLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationUIPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidationMenuAction.addSelected(IFolder)");
                entry.setMessageTypeIdentifier("VBF_EXC_INTERNAL");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return;
        }
    }

    private IResourceVisitor getProjectVisitor() {
        if (this._projectVisitor == null) {
            this._projectVisitor = new IResourceVisitor(){

                public boolean visit(IResource res) {
                    if (res instanceof IFile) {
                        ValidationMenuAction.this.addSelected(res);
                    } else if (res instanceof IFolder) {
                        ValidationMenuAction.this.addSelected(res);
                    }
                    return true;
                }
            };
        }
        return this._projectVisitor;
    }

    public void run(IAction action) {
        Map projects;
        ValidateAction vaction = null;
        if (action instanceof ValidateAction) {
            vaction = (ValidateAction)action;
        }
        if ((projects = this.loadSelected(vaction, false)) == null || projects.size() == 0) {
            return;
        }
        if (!this.handleFilesToSave(projects)) {
            return;
        }
        ValidationJob validationop = new ValidationJob(ValidationUIMessages.RunValidationDialogTitle){

            protected IStatus run(IProgressMonitor monitor) {
                Map projectsMap = projects;
                IStatus stat = ValidationMenuAction.this.validate(monitor, projectsMap);
                ValidationMenuAction.this._selectedResources.clear();
                return stat;
            }
        };
        validationop.setProjectsMap(projects);
        validationop.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        validationop.setUser(true);
        validationop.schedule();
    }

    private IStatus validate(IProgressMonitor monitor, Map projects) {
        boolean cancelled = false;
        Iterator iterator = projects.keySet().iterator();
        while (iterator.hasNext()) {
            String message;
            if (monitor.isCanceled()) {
                return new Status(8, "org.eclipse.wst.validation", 0, "OK", null);
            }
            IProject project = (IProject)iterator.next();
            if (project == null) continue;
            try {
                if (cancelled) {
                    message = ResourceHandler.getExternalizedMessage("VBF_UI_RESCANCELLED", new String[]{project.getName()});
                    monitor.setTaskName(message);
                    continue;
                }
                if (!project.isOpen()) {
                    message = ResourceHandler.getExternalizedMessage("VBF_UI_CLOSED_PROJECT", new String[]{project.getName()});
                    monitor.setTaskName(message);
                    continue;
                }
                this.performValidation(monitor, projects, project);
            }
            catch (OperationCanceledException operationCanceledException) {
                cancelled = true;
                message = ResourceHandler.getExternalizedMessage("VBF_UI_RESCANCELLED", new String[]{project.getName()});
                monitor.setTaskName(message);
            }
            catch (Throwable exc) {
                this.logException(monitor, project, exc);
            }
        }
        return new Status(0, "org.eclipse.wst.validation", 0, "OK", null);
    }

    private void logException(IProgressMonitor monitor, IProject project, Throwable exc) {
        Logger logger = WTPUIPlugin.getLogger();
        if (logger.isLoggingLevel(Level.SEVERE)) {
            LogEntry entry = ValidationUIPlugin.getLogEntry();
            entry.setSourceID("ValidationMenuAction.validate");
            entry.setMessageTypeIdentifier("VBF_EXC_INTERNAL");
            entry.setTargetException(exc);
            logger.write(Level.SEVERE, (Object)entry);
        }
        String internalErrorMessage = ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PROJECT", new String[]{project.getName()});
        monitor.setTaskName(internalErrorMessage);
    }

    private IStatus performValidation(IProgressMonitor monitor, Map projects, IProject project) throws CoreException {
        block6: {
            if (monitor.isCanceled()) {
                return new Status(8, "org.eclipse.wst.validation", 0, "OK", null);
            }
            Set changedResources = (Set)projects.get(project);
            IResource[] resources = null;
            if (changedResources != null) {
                resources = new IResource[changedResources.size()];
                changedResources.toArray(resources);
            }
            try {
                ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                if (prjp.numberOfManualEnabledValidators() > 0) {
                    this.checkProjectConfiguration(monitor, project, resources, prjp);
                } else {
                    String message = ResourceHandler.getExternalizedMessage("VBF_UI_NO_VALIDATORS_ENABLED", new String[]{project.getName()});
                    monitor.setTaskName(message);
                }
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block6;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidationMenuAction::run");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() == null) break block6;
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
        return new Status(0, "org.eclipse.wst.validation", 0, "OK", null);
    }

    private IStatus checkProjectConfiguration(IProgressMonitor monitor, IProject project, IResource[] resources, ProjectConfiguration prjp) throws InvocationTargetException, CoreException {
        boolean successful = true;
        if (monitor.isCanceled()) {
            new Status(8, "org.eclipse.wst.validation", 0, "OK", null);
        }
        Object validOp = null;
        validOp = resources == null ? new ManualValidatorsOperation(project) : new ManualIncrementalValidatorsOperation(project, (Object[])resources);
        if (validOp.isNecessary(monitor)) {
            validOp.run(monitor);
        } else if (resources == null) {
            String message = ResourceHandler.getExternalizedMessage("VBF_UI_PRJNEEDINPUT", new String[]{project.getName()});
            monitor.setTaskName(message);
        } else {
            int i = 0;
            while (i < resources.length) {
                String message = ResourceHandler.getExternalizedMessage("VBF_UI_RESNEEDINPUT", new String[]{resources[i].getFullPath().toString()});
                monitor.setTaskName(message);
                ++i;
            }
        }
        if (successful) {
            this.performSucessful(monitor, project, resources);
        } else {
            String internalErrorMessage = ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PROJECT", new String[]{project.getName()});
            monitor.setTaskName(internalErrorMessage);
        }
        return new Status(0, "org.eclipse.wst.validation", 0, "OK", null);
    }

    private void performSucessful(IProgressMonitor monitor, IProject project, IResource[] resources) {
        boolean limitExceeded = ValidatorManager.getManager().wasValidationTerminated(project);
        if (limitExceeded) {
            String message = ResourceHandler.getExternalizedMessage("VBF_UI_MAX_REPORTED", new String[]{project.getName()});
            monitor.setTaskName(message);
        } else if (resources == null) {
            String message = ResourceHandler.getExternalizedMessage("VBF_UI_PRJVALIDATED", new String[]{project.getName()});
            monitor.setTaskName(message);
        } else {
            int i = 0;
            while (i < resources.length) {
                String message = ResourceHandler.getExternalizedMessage("VBF_UI_RESVALIDATED", new String[]{resources[i].getFullPath().toString()});
                monitor.setTaskName(message);
                ++i;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean fwkActivated;
        this._currentSelection = selection;
        int count = 0;
        boolean bl = fwkActivated = ValidationPlugin.isActivated() && ValidationRegistryReader.isActivated();
        if (fwkActivated) {
            Map projects;
            ValidateAction vaction = null;
            if (action instanceof ValidateAction) {
                vaction = (ValidateAction)action;
            }
            if ((projects = this.loadSelected(vaction, true)) != null && projects.size() > 0) {
                Iterator iterator = projects.keySet().iterator();
                while (iterator.hasNext()) {
                    block7: {
                        IProject project = (IProject)iterator.next();
                        if (project == null || !project.isOpen()) continue;
                        try {
                            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfigurationWithoutMigrate(project);
                            if (!prjp.isDisableAllValidation()) {
                                count += prjp.numberOfManualValidators();
                            }
                        }
                        catch (InvocationTargetException exc) {
                            Logger logger = ValidationPlugin.getPlugin().getLogger();
                            if (!logger.isLoggingLevel(Level.SEVERE)) break block7;
                            LogEntry entry = ValidationPlugin.getLogEntry();
                            entry.setSourceIdentifier("ValidationMenuAction::selectionChanged");
                            entry.setTargetException((Throwable)exc);
                            logger.write(Level.SEVERE, (Object)entry);
                            if (exc.getTargetException() == null) break block7;
                            entry.setTargetException((Throwable)exc);
                            logger.write(Level.SEVERE, (Object)entry);
                        }
                    }
                    if (count > 0) break;
                }
            }
        }
        action.setEnabled(count > 0 || !fwkActivated);
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void init(IAction action) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
    }

    protected boolean handleFilesToSave(Map projects) {
        List fileList = this.getIFiles(projects);
        IEditorPart[] dirtyEditors = SaveFilesHelper.getDirtyEditors(fileList);
        if (dirtyEditors == null || dirtyEditors.length == 0) {
            return true;
        }
        boolean saveAutomatically = false;
        try {
            saveAutomatically = new GlobalConfiguration(ConfigurationManager.getManager().getGlobalConfiguration()).getSaveAutomatically();
        }
        catch (InvocationTargetException invocationTargetException) {}
        SaveFilesDialog sfDialog = null;
        if (!saveAutomatically) {
            sfDialog = new SaveFilesDialog(ValidationUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell());
            sfDialog.setInput(Arrays.asList(dirtyEditors));
        }
        if (saveAutomatically || sfDialog.open() == 0) {
            int numDirtyEditors = dirtyEditors.length;
            int i = 0;
            while (i < numDirtyEditors) {
                dirtyEditors[i].doSave(null);
                ++i;
            }
            return true;
        }
        return false;
    }

    protected List getIFiles(Map projects) {
        ArrayList<IResource> fileList = new ArrayList<IResource>();
        Set projectKeys = projects.keySet();
        Iterator projectIter = projectKeys.iterator();
        while (projectIter.hasNext()) {
            IProject project = (IProject)projectIter.next();
            Set resourcesList = (Set)projects.get(project);
            Iterator resourcesIter = resourcesList.iterator();
            while (resourcesIter.hasNext()) {
                IResource resource = (IResource)resourcesIter.next();
                if (!(resource instanceof IFile)) continue;
                fileList.add(resource);
            }
        }
        return fileList;
    }
}

