/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.ws.internal.common.J2EEActionAdapterFactory;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.common.WSDLParserFactory;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.TimedWSDLSelectionConditionCommand;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.WSDLSelectionTreeWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.AbstractObjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.IObjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.Timer;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.ValidateWSDLJob;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.ValidationMessageViewerWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.WSDLSelectionWrapper;
import org.eclipse.jst.ws.internal.ui.common.DialogResourceBrowser;
import org.eclipse.jst.ws.internal.ui.common.FileExtensionFilter;
import org.eclipse.jst.ws.internal.ui.common.IFilter;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.ws.internal.parser.wsil.WebServiceEntity;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.preferences.PersistentWSDLValidationContext;
import org.eclipse.wst.wsdl.internal.impl.ServiceImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;

public class WSDLSelectionWidget
extends AbstractObjectSelectionWidget
implements IObjectSelectionWidget,
Runnable {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private FileExtensionFilter wsFilter_ = new FileExtensionFilter(new String[]{"wsdl", "wsil", "html"});
    private WebServicesParser webServicesParser = WSDLParserFactory.getWSDLParser();
    private String wsdlURI_;
    private Composite parent_;
    private Listener statusListener_;
    private WSDLSelectionTreeWidget tree;
    private final String INFOPOP_PCON_PAGE = "PCON0001";
    private final String INFOPOP_PCON_TEXT_WSDL = "PCON0002";
    private Text webServiceURI;
    private final String INFOPOP_PCON_BUTTON_BROWSE_WSDL = "PCON0003";
    private Button wsBrowseButton_;
    private ValidationMessageViewerWidget msgViewer_;
    private ValidateWSDLJob validateWSDLJob_;
    private JobChangeAdapter jobChangeAdapter_;
    private Text validationSummaryText_;
    private Text validationSummaryText2_;

    public WSDLSelectionWidget() {
        final Runnable handleValidationMessages = new Runnable(){

            public void run() {
                WSDLSelectionWidget.this.msgViewer_.setInput(WSDLSelectionWidget.this.validateWSDLJob_.getValidationMessages());
                WSDLSelectionWidget.this.updateValidationSummary(WSDLSelectionWidget.this.validateWSDLJob_.getValidationMessageSeverity());
            }
        };
        this.jobChangeAdapter_ = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (WSDLSelectionWidget.this.msgViewer_ != null && WSDLSelectionWidget.this.msgViewer_.getContentProvider() != null) {
                    Display.getDefault().asyncExec(handleValidationMessages);
                }
            }
        };
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = new UIUtils(this.pluginId_);
        this.parent_ = parent;
        this.statusListener_ = statusListener;
        parent.setToolTipText(ConsumptionUIMessages.TOOLTIP_PCON_PAGE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(this.pluginId_) + "." + "PCON0001");
        Composite wsdlGroup = uiUtils.createComposite(parent, 2, 5, 0);
        Label wsLabel = new Label(wsdlGroup, 64);
        wsLabel.setText(ConsumptionUIMessages.LABEL_WS_SELECTION);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        wsLabel.setLayoutData((Object)gd);
        wsLabel.setToolTipText(ConsumptionUIMessages.TOOLTIP_PCON_TEXT_WS);
        this.webServiceURI = uiUtils.createText(wsdlGroup, null, ConsumptionUIMessages.TOOLTIP_PCON_TEXT_WS, "PCON0002", 2052);
        this.webServiceURI.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                WSDLSelectionWidget.this.handleWebServiceURIModifyEvent();
            }
        });
        this.wsBrowseButton_ = uiUtils.createPushButton(wsdlGroup, ConsumptionUIMessages.BUTTON_BROWSE, ConsumptionUIMessages.TOOLTIP_PCON_BUTTON_BROWSE_WS, "PCON0003");
        this.wsBrowseButton_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                WSDLSelectionWidget.this.handleWSDLButton();
            }

            public void widgetSelected(SelectionEvent event) {
                WSDLSelectionWidget.this.handleWSDLButton();
            }
        });
        this.tree = new WSDLSelectionTreeWidget();
        this.tree.addControls(parent, statusListener);
        this.tree.setWebServicesParser(this.webServicesParser);
        this.msgViewer_ = new ValidationMessageViewerWidget();
        this.msgViewer_.addControls(parent, statusListener);
        this.validationSummaryText_ = new Text(parent, 64);
        this.validationSummaryText_.setEditable(false);
        GridData gd1 = new GridData(1808);
        this.validationSummaryText_.setLayoutData((Object)gd1);
        this.validationSummaryText_.setToolTipText(ConsumptionUIMessages.TOOLTIP_VALIDATE_TEXT_MESSAGE_SUMMARY);
        this.validationSummaryText2_ = new Text(parent, 64);
        this.validationSummaryText2_.setEditable(false);
        this.validationSummaryText2_.setLayoutData((Object)gd1);
        this.setMessageSummary();
        return this;
    }

    private void setMessageSummary() {
        String validationMessageSummary = ConsumptionUIMessages.MESSAGE_VALIDATE_NO_WSDL;
        PersistentWSDLValidationContext wsdlValidationContext = WSPlugin.getInstance().getWSDLValidationContext();
        String validationSelection = wsdlValidationContext.getPersistentWSDLValidation();
        if ("1".equals(validationSelection)) {
            validationMessageSummary = ConsumptionUIMessages.MESSAGE_VALIDATE_REMOTE_WSDL;
        } else if ("2".equals(validationSelection)) {
            validationMessageSummary = ConsumptionUIMessages.MESSAGE_VALIDATE_ALL_WSDL;
        }
        this.validationSummaryText_.setText(validationMessageSummary);
        this.validationSummaryText2_.setText(" ");
    }

    private void handleWebServiceURIModifyEvent() {
        if (this.webServiceURI.getText().indexOf(58) > 0) {
            Timer.newInstance(Display.getCurrent(), this).startTimer();
        } else {
            this.handleWebServiceURI();
        }
        this.statusListener_.handleEvent(null);
    }

    private void handleWebServiceURI() {
        WebServiceEntity entity;
        IFile file;
        String wsURI = this.webServiceURI.getText();
        if (wsURI.indexOf(58) < 0 && (file = this.uri2IFile(wsURI)) != null) {
            wsURI = this.iFile2URI(file);
        }
        if (wsURI != null && wsURI.indexOf(58) >= 0 && this.webServicesParser.getWebServiceEntityByURI(wsURI) == null) {
            TimedWSDLSelectionConditionCommand cmd = new TimedWSDLSelectionConditionCommand();
            cmd.setWebServicesParser(this.webServicesParser);
            cmd.setWebServiceURI(wsURI);
            cmd.execute(null, null);
        }
        if ((entity = this.webServicesParser.getWebServiceEntityByURI(wsURI)) != null && entity.getType() == 2) {
            this.tree.setEnabled(false);
        } else {
            this.tree.setEnabled(true);
        }
        this.tree.setWebServiceURI(wsURI);
        this.tree.refreshTreeViewer();
        this.wsdlURI_ = wsURI;
    }

    public void run() {
        this.handleWebServiceURI();
        this.statusListener_.handleEvent(null);
    }

    private void handleWSDLButton() {
        DialogResourceBrowser dialog = new DialogResourceBrowser(this.parent_.getShell(), null, (IFilter)this.wsFilter_);
        dialog.open();
        IResource res = dialog.getFirstSelection();
        if (res != null) {
            this.wsdlURI_ = res.getFullPath().toString();
            this.webServiceURI.setText(this.wsdlURI_);
        }
        this.statusListener_.handleEvent(null);
    }

    public IStatus getStatus() {
        String wsdlURI;
        String wsPath = this.webServiceURI.getText();
        if (wsPath == null || wsPath.length() <= 0) {
            return StatusUtils.errorStatus((String)ConsumptionUIMessages.PAGE_MSG_INVALID_WEB_SERVICE_URI);
        }
        if (wsPath.indexOf(58) < 0) {
            IResource res = ResourceUtils.findResource((String)wsPath);
            if (res == null) {
                this.msgViewer_.clearInput();
                return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.PAGE_MSG_NO_SUCH_FILE, (Object[])new Object[]{wsPath}));
            }
            if (res.getType() != 1) {
                this.msgViewer_.clearInput();
                return StatusUtils.errorStatus((String)ConsumptionUIMessages.PAGE_MSG_INVALID_WEB_SERVICE_URI);
            }
        }
        if (!Timer.isRunning() && this.tree.isEnabled()) {
            int severity;
            IStatus status = this.tree.getStatus();
            if (status != null && ((severity = status.getSeverity()) == 4 || severity == 2)) {
                this.msgViewer_.clearInput();
                return status;
            }
        } else if (wsPath.indexOf(58) < 0 && this.webServicesParser.getWSDLDefinition(wsdlURI = this.iFile2URI((IFile)ResourceUtils.findResource((String)wsPath))) == null) {
            this.msgViewer_.clearInput();
            return StatusUtils.errorStatus((String)ConsumptionUIMessages.PAGE_MSG_SELECTION_MUST_BE_WSDL);
        }
        if (!Timer.isRunning()) {
            String wsdlURI1 = wsPath;
            boolean isRemote = true;
            if (this.tree.isEnabled()) {
                wsdlURI1 = this.tree.getWsdlURI();
                if (wsdlURI1.startsWith("file:")) {
                    isRemote = false;
                }
            } else if (wsPath.indexOf(58) < 0) {
                isRemote = false;
                wsdlURI1 = this.iFile2URI((IFile)ResourceUtils.findResource((String)wsPath));
            }
            this.setMessageSummary();
            this.msgViewer_.clearInput();
            this.validateWSDL(wsdlURI1, isRemote);
        }
        return Status.OK_STATUS;
    }

    private void validateWSDL(String wsdlURI, boolean isRemote) {
        String validationSelection = WSPlugin.getInstance().getWSDLValidationContext().getPersistentWSDLValidation();
        if ("2".equals(validationSelection) || "1".equals(validationSelection) && isRemote) {
            IJobManager jobManager = Platform.getJobManager();
            Job[] jobs = jobManager.find((Object)"ValidateWSDLJobJamily");
            ValidateWSDLJob existingValidateWSDLJob = null;
            boolean startWSDLValidation = true;
            this.validationSummaryText_.setText(ConsumptionUIMessages.MESSAGE_VALIDATE_IN_PROGRESS);
            this.validationSummaryText2_.setText(" ");
            if (jobs.length > 0) {
                int i = 0;
                while (i < jobs.length) {
                    existingValidateWSDLJob = (ValidateWSDLJob)jobs[i];
                    if (existingValidateWSDLJob.getState() != 0) {
                        if (!wsdlURI.equals(existingValidateWSDLJob.getWsdlURI())) {
                            existingValidateWSDLJob.cancel();
                        } else {
                            startWSDLValidation = false;
                        }
                    }
                    ++i;
                }
            }
            if (startWSDLValidation) {
                this.startWSDLValidationJob(wsdlURI);
            }
        }
    }

    private void startWSDLValidationJob(String wsdlURI) {
        this.validateWSDLJob_ = new ValidateWSDLJob(wsdlURI);
        this.validateWSDLJob_.addJobChangeListener((IJobChangeListener)this.jobChangeAdapter_);
        this.validateWSDLJob_.schedule();
    }

    public void updateValidationSummary(int messageSeverity) {
        switch (messageSeverity) {
            case 0: {
                this.validationSummaryText_.setText(ConsumptionUIMessages.ERROR_MESSAGES_IN_VALIDATION);
                this.validationSummaryText2_.setText(ConsumptionUIMessages.WARNING_IF_CONTINUE);
                break;
            }
            case 1: {
                this.validationSummaryText_.setText(ConsumptionUIMessages.WARNING_MESSAGES_IN_VALIDATION);
                this.validationSummaryText2_.setText(ConsumptionUIMessages.WARNING_IF_CONTINUE);
                break;
            }
            default: {
                this.validationSummaryText_.setText(ConsumptionUIMessages.VALIDATION_COMPLETED);
                this.validationSummaryText2_.setText(" ");
            }
        }
    }

    private IFile uri2IFile(String uri) {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(uri);
        if (res instanceof IFile) {
            return (IFile)res;
        }
        return null;
    }

    private String iFile2URI(IFile file) {
        File f = file.getLocation().toFile();
        try {
            return f.toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            return f.toString();
        }
    }

    public void setInitialSelection(IStructuredSelection initialSelection) {
        if (initialSelection != null && !initialSelection.isEmpty()) {
            String wsdlURI;
            Object object = initialSelection.getFirstElement();
            this.wsdlURI_ = wsdlURI = this.toWsdlURI(object);
            if (wsdlURI != null && this.webServiceURI != null) {
                this.webServiceURI.setText(wsdlURI);
                this.handleWebServiceURI();
            }
        }
    }

    private String toWsdlURI(Object object) {
        if (object instanceof ServiceImpl) {
            return J2EEActionAdapterFactory.getWSDLURI((ServiceImpl)((ServiceImpl)object));
        }
        if (object instanceof WSDLResourceImpl) {
            return J2EEActionAdapterFactory.getWSDLURI((WSDLResourceImpl)((WSDLResourceImpl)object));
        }
        if (object instanceof ServiceRef) {
            return J2EEActionAdapterFactory.getWSDLURI((ServiceRef)((ServiceRef)object));
        }
        if (object instanceof IFile) {
            return ((IFile)object).getFullPath().toString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public IStructuredSelection getObjectSelection() {
        StructuredSelection ss = this.tree != null ? new StructuredSelection((Object)this.tree.getWsdlURI()) : new StructuredSelection((Object)this.wsdlURI_);
        return new StructuredSelection((Object)new WSDLSelectionWrapper(this.webServicesParser, (IStructuredSelection)ss));
    }

    public WebServicesParser getWebServicesParser() {
        return this.webServicesParser;
    }

    public IStatus validateSelection(IStructuredSelection objectSelection) {
        return Status.OK_STATUS;
    }

    public IProject getProject() {
        String wsdlURI = this.tree != null ? this.tree.getWsdlURI() : this.wsdlURI_;
        if (wsdlURI != null) {
            IProject p = this.getProjectFromURI(wsdlURI);
            if (p != null && p.exists()) {
                return p;
            }
            String wsRelPath = this.wsdlURI_;
            IResource wsRes = ResourceUtils.findResource((String)wsRelPath);
            if (wsRes != null && wsRes instanceof IFile) {
                IProject p2 = ((IFile)wsRes).getProject();
                return p2;
            }
        }
        return null;
    }

    public String getComponentName() {
        String wsdlURI = this.tree != null ? this.tree.getWsdlURI() : this.wsdlURI_;
        if (wsdlURI != null) {
            IVirtualComponent comp;
            String cname = this.getComponentNameFromURI(wsdlURI);
            if (cname != null && cname.length() > 0) {
                return cname;
            }
            String wsRelPath = this.wsdlURI_;
            IResource wsRes = ResourceUtils.findResource((String)wsRelPath);
            if (wsRes != null && wsRes instanceof IFile && (comp = ResourceUtils.getComponentOf((IResource)wsRes)) != null) {
                return comp.getName();
            }
        }
        return null;
    }

    private IProject getProjectFromURI(String uri) {
        String relPath;
        IResource res;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String wkspcRootLoc = root.getLocation().toString();
        int idx = uri.indexOf(wkspcRootLoc);
        if (idx != -1 && (res = root.findMember((IPath)new Path(relPath = uri.substring(wkspcRootLoc.length() + idx)))) instanceof IFile) {
            IProject p = ((IFile)res).getProject();
            return p;
        }
        return null;
    }

    private String getComponentNameFromURI(String uri) {
        IVirtualComponent comp;
        String relPath;
        IResource res;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String wkspcRootLoc = root.getLocation().toString();
        int idx = uri.indexOf(wkspcRootLoc);
        if (idx != -1 && (res = root.findMember((IPath)new Path(relPath = uri.substring(wkspcRootLoc.length() + idx)))) instanceof IFile && (comp = ResourceUtils.getComponentOf((IResource)res)) != null) {
            return comp.getName();
        }
        return null;
    }

    public String getObjectSelectionDisplayableString() {
        if (this.tree != null) {
            return this.tree.getWsdlURI();
        }
        return this.wsdlURI_;
    }

    public Point getWidgetSize() {
        return new Point(580, 580);
    }

    public boolean validate(String s) {
        WebServiceEntity entity;
        IFile file;
        String wsURI = s;
        if (wsURI.indexOf(58) < 0 && (file = this.uri2IFile(wsURI)) != null) {
            wsURI = this.iFile2URI(file);
        }
        if (wsURI != null && wsURI.indexOf(58) >= 0 && this.webServicesParser.getWebServiceEntityByURI(wsURI) == null) {
            TimedWSDLSelectionConditionCommand cmd = new TimedWSDLSelectionConditionCommand();
            cmd.setWebServicesParser(this.webServicesParser);
            cmd.setWebServiceURI(wsURI);
            cmd.execute(null, null);
        }
        this.wsdlURI_ = wsURI;
        if (this.tree != null) {
            this.tree.setWebServiceURI(wsURI);
        }
        return (entity = this.webServicesParser.getWebServiceEntityByURI(wsURI)) != null && entity.getType() == 2;
    }
}

