/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.internal.ActionDefinition;
import org.eclipse.wst.common.project.facet.core.internal.Category;
import org.eclipse.wst.common.project.facet.core.internal.Constraint;
import org.eclipse.wst.common.project.facet.core.internal.EventHandler;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProject;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.internal.Group;
import org.eclipse.wst.common.project.facet.core.internal.IndexedSet;
import org.eclipse.wst.common.project.facet.core.internal.Preset;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacet;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.internal.ValidationProblem;
import org.eclipse.wst.common.project.facet.core.internal.VersionExpr;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class ProjectFacetsManagerImpl {
    private static final String EXTENSION_ID = "facets";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_FACET = "facet";
    private static final String ATTR_GROUP = "group";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SOFT = "soft";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_VERSION = "version";
    private static final String EL_ACTION = "action";
    private static final String EL_CATEGORY = "category";
    private static final String EL_CONFIG_FACTORY = "config-factory";
    private static final String EL_CONSTRAINT = "constraint";
    private static final String EL_DELEGATE = "delegate";
    private static final String EL_DESCRIPTION = "description";
    private static final String EL_EVENT_HANDLER = "event-handler";
    private static final String EL_FIXED = "fixed";
    private static final String EL_GROUP_MEMBER = "group-member";
    private static final String EL_LABEL = "label";
    private static final String EL_PRESET = "preset";
    private static final String EL_PROJECT_FACET = "project-facet";
    private static final String EL_PROJECT_FACET_VERSION = "project-facet-version";
    private static final String EL_PROPERTY = "property";
    private static final String EL_TEMPLATE = "template";
    private static final String EL_VERSION_COMPARATOR = "version-comparator";
    private static final Set facetsReportedMissing = new HashSet();
    private final IndexedSet facets = new IndexedSet();
    private final IndexedSet actions = new IndexedSet();
    private final IndexedSet categories = new IndexedSet();
    private final IndexedSet presets = new IndexedSet();
    private final IndexedSet templates = new IndexedSet();
    private final IndexedSet groups = new IndexedSet();
    private final Map projects = new HashMap();

    public ProjectFacetsManagerImpl() {
        this.readMetadata();
        this.readUserPresets();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ResourceChangeListener ls = new ResourceChangeListener();
        ws.addResourceChangeListener((IResourceChangeListener)ls, 1);
    }

    public Set getProjectFacets() {
        return this.facets.getUnmodifiable();
    }

    public boolean isProjectFacetDefined(String id) {
        return this.facets.containsKey(id);
    }

    public IProjectFacet getProjectFacet(String id) {
        IProjectFacet f = (IProjectFacet)this.facets.get(id);
        if (f == null) {
            String msg = NLS.bind((String)Resources.facetNotDefined, (Object)id);
            throw new IllegalArgumentException(msg);
        }
        return f;
    }

    public Set getActionDefinitions() {
        return this.actions.getUnmodifiable();
    }

    public boolean isActionDefined(String id) {
        return this.actions.containsKey(id);
    }

    public IActionDefinition getActionDefinition(String id) {
        IActionDefinition adef = (IActionDefinition)this.actions.get(id);
        if (adef == null) {
            String msg = NLS.bind((String)Resources.actionNotDefined, (Object)id);
            throw new IllegalArgumentException(msg);
        }
        return adef;
    }

    public Set getCategories() {
        return this.categories.getUnmodifiable();
    }

    public boolean isCategoryDefined(String id) {
        return this.categories.containsKey(id);
    }

    public ICategory getCategory(String id) {
        ICategory category = (ICategory)this.categories.get(id);
        if (category == null) {
            String msg = NLS.bind((String)Resources.categoryNotDefined, (Object)id);
            throw new IllegalArgumentException(msg);
        }
        return category;
    }

    public Set getPresets() {
        return this.presets.getUnmodifiable();
    }

    public boolean isPresetDefined(String id) {
        return this.presets.containsKey(id);
    }

    public IPreset getPreset(String id) {
        IPreset preset = (IPreset)this.presets.get(id);
        if (preset == null) {
            String msg = NLS.bind((String)Resources.presetNotDefined, (Object)id);
            throw new IllegalArgumentException(msg);
        }
        return preset;
    }

    public IPreset definePreset(String name, Set facets) {
        return this.definePreset(name, "", facets, true);
    }

    public IPreset definePreset(String name, String description, Set facets) {
        return this.definePreset(name, description, facets, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPreset definePreset(String name, String description, Set facets, boolean save) {
        IndexedSet indexedSet = this.presets;
        synchronized (indexedSet) {
            String id;
            int i = 0;
            do {
                id = ".usr." + i;
                ++i;
            } while (this.presets.containsKey(id));
            Preset preset = new Preset();
            preset.setId(id);
            preset.setLabel(name);
            preset.setDescription(description == null ? "" : description);
            preset.addProjectFacet(facets);
            preset.setUserDefined(true);
            this.presets.add(id, preset);
            if (save) {
                this.saveUserPresets();
            }
            return preset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deletePreset(IPreset preset) {
        IndexedSet indexedSet = this.presets;
        synchronized (indexedSet) {
            block5: {
                if (preset.isUserDefined()) break block5;
                return false;
            }
            boolean res = this.presets.delete(preset.getId());
            if (res) {
                this.saveUserPresets();
            }
            return res;
        }
    }

    public Set getTemplates() {
        return this.templates.getUnmodifiable();
    }

    public boolean isTemplateDefined(String id) {
        return this.templates.containsKey(id);
    }

    public IFacetedProjectTemplate getTemplate(String id) {
        IFacetedProjectTemplate template = (IFacetedProjectTemplate)this.templates.get(id);
        if (template == null) {
            String msg = NLS.bind((String)Resources.templateNotDefined, (Object)id);
            throw new IllegalArgumentException(msg);
        }
        return template;
    }

    public Set getGroups() {
        return this.groups.getUnmodifiable();
    }

    public boolean isGroupDefined(String id) {
        return this.groups.containsKey(id);
    }

    public IGroup getGroup(String id) {
        IGroup group = (IGroup)this.groups.get(id);
        if (group == null) {
            String msg = NLS.bind((String)Resources.groupNotDefined, (Object)id);
            throw new IllegalArgumentException(msg);
        }
        return group;
    }

    public Set getFacetedProjects() throws CoreException {
        return this.getFacetedProjects(null, null);
    }

    public Set getFacetedProjects(IProjectFacet f) throws CoreException {
        return this.getFacetedProjects(f, null);
    }

    public Set getFacetedProjects(IProjectFacetVersion fv) throws CoreException {
        return this.getFacetedProjects(null, fv);
    }

    private Set getFacetedProjects(IProjectFacet f, IProjectFacetVersion fv) throws CoreException {
        IProject[] all = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashSet<IFacetedProject> result = new HashSet<IFacetedProject>();
        int i = 0;
        while (i < all.length) {
            IProject proj = all[i];
            IFacetedProject fproj = this.create(proj);
            if (fproj != null && (f == null || fproj.hasProjectFacet(f)) && (fv == null || fproj.hasProjectFacet(fv))) {
                result.add(fproj);
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFacetedProject create(IProject project) throws CoreException {
        if (project.isAccessible() && project.isNatureEnabled("org.eclipse.wst.common.project.facet.core.nature")) {
            Map map = this.projects;
            synchronized (map) {
                FacetedProject fproj = (FacetedProject)this.projects.get(project.getName());
                if (fproj == null) {
                    fproj = new FacetedProject(project);
                    this.projects.put(project.getName(), fproj);
                } else {
                    fproj.refresh();
                }
                return fproj;
            }
        }
        return null;
    }

    public IFacetedProject create(IProject project, boolean convertIfNecessary, IProgressMonitor monitor) throws CoreException {
        IFacetedProject iFacetedProject;
        block4: {
            if (monitor != null) {
                monitor.beginTask("", 2);
            }
            try {
                if (project.exists() && convertIfNecessary) {
                    IProjectDescription description = project.getDescription();
                    String[] prevNatures = description.getNatureIds();
                    String[] newNatures = new String[prevNatures.length + 1];
                    System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                    newNatures[prevNatures.length] = "org.eclipse.wst.common.project.facet.core.nature";
                    description.setNatureIds(newNatures);
                    project.setDescription(description, ProjectFacetsManagerImpl.submon(monitor, 1));
                }
                project.open(128, ProjectFacetsManagerImpl.submon(monitor, 1));
                iFacetedProject = this.create(project);
                Object var7_8 = null;
                if (monitor == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_9 = null;
                    if (monitor == null) break block5;
                    monitor.done();
                }
                throw throwable;
            }
            monitor.done();
        }
        return iFacetedProject;
    }

    public IFacetedProject create(String name, IPath location, IProgressMonitor monitor) throws CoreException {
        IFacetedProject iFacetedProject;
        block3: {
            if (monitor != null) {
                monitor.beginTask("", 2);
            }
            try {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                IProject project = ws.getRoot().getProject(name);
                IProjectDescription desc = ws.newProjectDescription(name);
                desc.setLocation(location);
                project.create(desc, ProjectFacetsManagerImpl.submon(monitor, 1));
                project.open(128, ProjectFacetsManagerImpl.submon(monitor, 1));
                desc.setNatureIds(new String[]{"org.eclipse.wst.common.project.facet.core.nature"});
                project.setDescription(desc, null);
                iFacetedProject = this.create(project);
                Object var7_8 = null;
                if (monitor == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var7_9 = null;
                    if (monitor == null) break block4;
                    monitor.done();
                }
                throw throwable;
            }
            monitor.done();
        }
        return iFacetedProject;
    }

    public IStatus check(Set base, Set actions) {
        IFacetedProject.Action action;
        ValidationProblem.Type ptype;
        Iterator itr2;
        IFacetedProject.Action action2;
        IProjectFacetVersion fv;
        MultiStatus result = Constraint.createMultiStatus();
        Iterator itr = actions.iterator();
        while (itr.hasNext()) {
            ValidationProblem.Type ptype2;
            IFacetedProject.Action action3 = (IFacetedProject.Action)itr.next();
            if (action3.getProjectFacetVersion().supports(base, action3.getType())) continue;
            if (action3.getType() == IFacetedProject.Action.Type.INSTALL) {
                ptype2 = ValidationProblem.Type.INSTALL_NOT_SUPPORTED;
            } else if (action3.getType() == IFacetedProject.Action.Type.UNINSTALL) {
                ptype2 = ValidationProblem.Type.UNINSTALL_NOT_SUPPORTED;
            } else if (action3.getType() == IFacetedProject.Action.Type.VERSION_CHANGE) {
                ptype2 = ValidationProblem.Type.VERSION_CHANGE_NOT_SUPPORTED;
            } else {
                throw new IllegalStateException();
            }
            fv = action3.getProjectFacetVersion();
            ValidationProblem vp = new ValidationProblem(ptype2, fv.getProjectFacet().getLabel(), fv.getVersionString());
            result.add((IStatus)vp);
        }
        HashMap<IProjectFacet, HashSet<IFacetedProject.Action>> facetToActionsMap = new HashMap<IProjectFacet, HashSet<IFacetedProject.Action>>();
        Iterator itr3 = actions.iterator();
        while (itr3.hasNext()) {
            action2 = (IFacetedProject.Action)itr3.next();
            IProjectFacet f = action2.getProjectFacetVersion().getProjectFacet();
            HashSet<IFacetedProject.Action> group = (HashSet<IFacetedProject.Action>)facetToActionsMap.get(f);
            if (group == null) {
                group = new HashSet<IFacetedProject.Action>();
                facetToActionsMap.put(f, group);
            }
            group.add(action2);
        }
        Iterator itr1 = facetToActionsMap.entrySet().iterator();
        while (itr1.hasNext()) {
            Map.Entry entry = itr1.next();
            Set group = (Set)entry.getValue();
            if (group.size() <= 1) continue;
            boolean bad = true;
            if (group.size() == 2) {
                IFacetedProject.Action install = null;
                IFacetedProject.Action uninstall = null;
                itr2 = group.iterator();
                while (itr2.hasNext()) {
                    IFacetedProject.Action action4 = (IFacetedProject.Action)itr2.next();
                    if (action4.getType() == IFacetedProject.Action.Type.INSTALL) {
                        install = action4;
                        continue;
                    }
                    if (action4.getType() != IFacetedProject.Action.Type.UNINSTALL) break;
                    uninstall = action4;
                }
                if (install != null && uninstall != null && base.contains(uninstall.getProjectFacetVersion())) {
                    bad = false;
                }
            }
            if (!bad) continue;
            ptype = ValidationProblem.Type.MULTIPLE_ACTIONS_NOT_SUPPORTED;
            result.add((IStatus)new ValidationProblem(ptype));
            break;
        }
        itr1 = actions.iterator();
        while (itr1.hasNext()) {
            action2 = (IFacetedProject.Action)((Object)itr1.next());
            fv = action2.getProjectFacetVersion();
            IProjectFacet f = fv.getProjectFacet();
            ptype = null;
            if (action2.getType() == IFacetedProject.Action.Type.UNINSTALL) {
                if (!base.contains(fv)) {
                    ptype = ValidationProblem.Type.CANNOT_UNINSTALL;
                }
            } else {
                IProjectFacetVersion existing = null;
                itr2 = base.iterator();
                while (itr2.hasNext()) {
                    IProjectFacetVersion temp = (IProjectFacetVersion)itr2.next();
                    if (temp.getProjectFacet() != f) continue;
                    existing = temp;
                    break;
                }
                if (action2.getType() == IFacetedProject.Action.Type.VERSION_CHANGE && existing == null) {
                    ptype = ValidationProblem.Type.CANNOT_CHANGE_VERSION;
                } else if (action2.getType() == IFacetedProject.Action.Type.INSTALL && existing != null) {
                    ptype = ValidationProblem.Type.FACET_ALREADY_INSTALLED;
                }
            }
            if (ptype == null) continue;
            result.add((IStatus)new ValidationProblem(ptype, f.getLabel(), fv.getVersionString()));
        }
        if (!result.isOK()) {
            return result;
        }
        HashSet all = new HashSet(base);
        Iterator itr4 = actions.iterator();
        while (itr4.hasNext()) {
            action = (IFacetedProject.Action)itr4.next();
            if (action.getType() != IFacetedProject.Action.Type.UNINSTALL) continue;
            ProjectFacetsManagerImpl.apply(all, action);
        }
        itr4 = actions.iterator();
        while (itr4.hasNext()) {
            action = (IFacetedProject.Action)itr4.next();
            if (action.getType() == IFacetedProject.Action.Type.UNINSTALL) continue;
            ProjectFacetsManagerImpl.apply(all, action);
        }
        itr4 = all.iterator();
        while (itr4.hasNext()) {
            IStatus st;
            fv = (IProjectFacetVersion)itr4.next();
            IConstraint constraint = fv.getConstraint();
            if (constraint == null || (st = constraint.check(all)).isOK()) continue;
            result.addAll(st);
        }
        HashSet<IStatus> problems = new HashSet<IStatus>();
        IStatus[] children = result.getChildren();
        int i = 0;
        while (i < children.length) {
            problems.add(children[i]);
            ++i;
        }
        HashSet<ValidationProblem> toremove = new HashSet<ValidationProblem>();
        Iterator itr5 = problems.iterator();
        while (itr5.hasNext()) {
            ValidationProblem problem = (ValidationProblem)((Object)itr5.next());
            if (toremove.contains((Object)problem)) {
                itr5.remove();
                continue;
            }
            if (problem.getType() != ValidationProblem.Type.CONFLICTS) continue;
            Object[] p = problem.getParameters();
            ValidationProblem reverse = new ValidationProblem(ValidationProblem.Type.CONFLICTS, new Object[]{p[1], p[0]});
            toremove.add(reverse);
        }
        if (children.length != problems.size()) {
            children = problems.toArray(new IStatus[problems.size()]);
            result = Constraint.createMultiStatus(children);
        }
        return result;
    }

    public void sort(Set base, List actions) {
        int count = actions.size();
        if (count == 0) {
            return;
        }
        IStatus st = this.check(base, new HashSet(actions));
        if (!st.isOK()) {
            FacetCorePlugin.log(st);
            return;
        }
        ArrayList unsorted = null;
        int steps = 0;
        if (FacetCorePlugin.isTracingActionSorting()) {
            unsorted = new ArrayList(actions);
        }
        int i = 0;
        int j = 0;
        while (j < count) {
            IFacetedProject.Action action = (IFacetedProject.Action)actions.get(j);
            if (action.getType() == IFacetedProject.Action.Type.UNINSTALL && i != j) {
                actions.set(j, actions.get(i));
                actions.set(i, action);
                ++i;
                ++steps;
            }
            ++j;
        }
        HashSet fnl = new HashSet(base);
        Iterator itr = actions.iterator();
        while (itr.hasNext()) {
            ProjectFacetsManagerImpl.apply(fnl, (IFacetedProject.Action)itr.next());
        }
        boolean makeAnotherPass = true;
        block2: while (makeAnotherPass) {
            makeAnotherPass = false;
            HashSet state = new HashSet(base);
            int i2 = 0;
            while (i2 < count) {
                IFacetedProject.Action action = (IFacetedProject.Action)actions.get(i2);
                IFacetedProject.Action.Type type = action.getType();
                IProjectFacetVersion fv = action.getProjectFacetVersion();
                IConstraint constraint = fv.getConstraint();
                if (type == IFacetedProject.Action.Type.UNINSTALL) {
                    if (!constraint.check(state, true).isOK() && constraint.check(base, true).isOK()) {
                        ProjectFacetsManagerImpl.moveToFront(actions, i2);
                        makeAnotherPass = true;
                        ++steps;
                        continue block2;
                    }
                    ProjectFacetsManagerImpl.apply(state, action);
                    ++i2;
                    continue;
                }
                if (constraint.check(state).isOK() && (constraint.check(state, true).isOK() || !constraint.check(fnl, true).isOK())) {
                    ProjectFacetsManagerImpl.apply(state, action);
                    ++i2;
                    continue;
                }
                ProjectFacetsManagerImpl.moveToEnd(actions, i2);
                ++steps;
            }
        }
        if (FacetCorePlugin.isTracingActionSorting()) {
            String text = Resources.bind(Resources.tracingActionSorting, ProjectFacetsManagerImpl.toString(base), ProjectFacetsManagerImpl.toString(unsorted), ProjectFacetsManagerImpl.toString(actions), String.valueOf(steps));
            System.out.println(text);
        }
    }

    static void apply(Set facets, IFacetedProject.Action action) {
        IFacetedProject.Action.Type type = action.getType();
        IProjectFacetVersion fv = action.getProjectFacetVersion();
        if (type == IFacetedProject.Action.Type.INSTALL) {
            facets.add(fv);
        } else if (type == IFacetedProject.Action.Type.UNINSTALL) {
            facets.remove(fv);
        } else if (type == IFacetedProject.Action.Type.VERSION_CHANGE) {
            Iterator itr = facets.iterator();
            while (itr.hasNext()) {
                IProjectFacetVersion x = (IProjectFacetVersion)itr.next();
                if (x.getProjectFacet() != fv.getProjectFacet()) continue;
                itr.remove();
                break;
            }
            facets.add(fv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportMissingFacet(String fid, String plugin) {
        Set set = facetsReportedMissing;
        synchronized (set) {
            if (!facetsReportedMissing.contains(fid)) {
                String msg = String.valueOf(NLS.bind((String)Resources.facetNotDefined, (Object)fid)) + NLS.bind((String)Resources.usedInPlugin, (Object)plugin);
                FacetCorePlugin.log(msg);
                facetsReportedMissing.add(fid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportMissingFacet(String fid, IProjectFacetVersion fv) {
        Set set = facetsReportedMissing;
        synchronized (set) {
            if (!facetsReportedMissing.contains(fid)) {
                String msg = String.valueOf(NLS.bind((String)Resources.facetNotDefined, (Object)fid)) + NLS.bind((String)Resources.usedInConstraint, (Object)fv.getProjectFacet().getId(), (Object)fv.getVersionString());
                FacetCorePlugin.log(msg);
                facetsReportedMissing.add(fid);
            }
        }
    }

    private static IProgressMonitor submon(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return null;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    private static void moveToFront(List actions, int index) {
        IFacetedProject.Action action = (IFacetedProject.Action)actions.get(index);
        int i = index;
        while (i > 0) {
            actions.set(i, actions.get(i - 1));
            --i;
        }
        actions.set(0, action);
    }

    private static void moveToEnd(List actions, int index) {
        IFacetedProject.Action action = (IFacetedProject.Action)actions.get(index);
        int i = index + 1;
        int n = actions.size();
        while (i < n) {
            actions.set(i - 1, actions.get(i));
            ++i;
        }
        actions.set(actions.size() - 1, action);
    }

    private void readMetadata() {
        ProjectFacetVersion fv;
        IConfigurationElement config;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.common.project.facet.core", EXTENSION_ID);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        ArrayList<IConfigurationElement> cfgels = new ArrayList<IConfigurationElement>();
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                cfgels.add(elements[j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        int n = cfgels.size();
        while (i < n) {
            IConfigurationElement config2 = (IConfigurationElement)cfgels.get(i);
            if (config2.getName().equals(EL_CATEGORY)) {
                this.readCategory(config2);
            }
            ++i;
        }
        i = 0;
        n = cfgels.size();
        while (i < n) {
            IConfigurationElement config3 = (IConfigurationElement)cfgels.get(i);
            if (config3.getName().equals(EL_PROJECT_FACET)) {
                this.readProjectFacet(config3);
            }
            ++i;
        }
        HashMap fvToConstraint = new HashMap();
        HashMap fvToActions = new HashMap();
        int i2 = 0;
        int n2 = cfgels.size();
        while (i2 < n2) {
            config = (IConfigurationElement)cfgels.get(i2);
            if (config.getName().equals(EL_PROJECT_FACET_VERSION)) {
                this.readProjectFacetVersion(config, fvToConstraint, fvToActions);
            }
            ++i2;
        }
        Iterator itr = fvToConstraint.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            fv = (ProjectFacetVersion)entry.getKey();
            IConfigurationElement config4 = (IConfigurationElement)entry.getValue();
            this.readConstraint(config4, fv);
        }
        Iterator itr1 = fvToActions.entrySet().iterator();
        while (itr1.hasNext()) {
            Map.Entry entry = itr1.next();
            fv = (ProjectFacetVersion)entry.getKey();
            List actions = (List)entry.getValue();
            Iterator itr2 = actions.iterator();
            while (itr2.hasNext()) {
                IConfigurationElement config5 = (IConfigurationElement)itr2.next();
                this.readAction(config5, (ProjectFacet)fv.getProjectFacet(), fv.getVersionString());
            }
        }
        i = 0;
        n2 = cfgels.size();
        while (i < n2) {
            config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals(EL_ACTION)) {
                this.readAction(config);
            } else if (config.getName().equals(EL_EVENT_HANDLER)) {
                this.readEventHandler(config);
            }
            ++i;
        }
        i = 0;
        n2 = cfgels.size();
        while (i < n2) {
            config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals(EL_PRESET)) {
                this.readPreset(config);
            }
            ++i;
        }
        i = 0;
        n2 = cfgels.size();
        while (i < n2) {
            config = (IConfigurationElement)cfgels.get(i);
            if (config.getName().equals(EL_TEMPLATE)) {
                this.readTemplate(config);
            }
            ++i;
        }
    }

    private void readCategory(IConfigurationElement config) {
        Category category = new Category();
        category.setPluginId(config.getContributor().getName());
        String id = config.getAttribute(ATTR_ID);
        if (id == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_ID);
            return;
        }
        category.setId(id);
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_LABEL)) {
                category.setLabel(child.getValue().trim());
            } else if (childName.equals(EL_DESCRIPTION)) {
                category.setDescription(child.getValue().trim());
            }
            ++i;
        }
        this.categories.add(id, category);
    }

    private void readProjectFacet(IConfigurationElement config) {
        String id = config.getAttribute(ATTR_ID);
        if (id == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_ID);
            return;
        }
        ProjectFacet descriptor = new ProjectFacet();
        descriptor.setId(id);
        descriptor.setPluginId(config.getContributor().getName());
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_LABEL)) {
                descriptor.setLabel(child.getValue().trim());
            } else if (childName.equals(EL_DESCRIPTION)) {
                descriptor.setDescription(child.getValue().trim());
            } else if (childName.equals(EL_VERSION_COMPARATOR)) {
                String clname = child.getAttribute(ATTR_CLASS);
                if (clname == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(child, ATTR_CLASS);
                    return;
                }
                descriptor.setVersionComparator(clname);
            } else if (childName.equals(EL_CATEGORY)) {
                String catname = child.getValue().trim();
                Category category = (Category)this.categories.get(catname);
                if (category == null) {
                    String msg = String.valueOf(NLS.bind((String)Resources.categoryNotDefined, (Object)catname)) + NLS.bind((String)Resources.usedInPlugin, (Object)child.getContributor().getName());
                    FacetCorePlugin.log(msg);
                    return;
                }
                descriptor.setCategory(category);
                category.addProjectFacet(descriptor);
            }
            ++i;
        }
        if (descriptor.getLabel() == null) {
            descriptor.setLabel(id);
        }
        this.facets.add(id, descriptor);
    }

    private void readProjectFacetVersion(IConfigurationElement config, Map fvToConstraint, Map fvToActions) {
        String childName;
        IConfigurationElement child;
        String fid = config.getAttribute(ATTR_FACET);
        if (fid == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_FACET);
            return;
        }
        String ver = config.getAttribute(ATTR_VERSION);
        if (ver == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_VERSION);
            return;
        }
        ProjectFacet f = (ProjectFacet)this.facets.get(fid);
        if (f == null) {
            ProjectFacetsManagerImpl.reportMissingFacet(fid, config.getContributor().getName());
            return;
        }
        ProjectFacetVersion fv = new ProjectFacetVersion();
        fv.setProjectFacet(f);
        fv.setVersionString(ver);
        fv.setPluginId(config.getContributor().getName());
        ArrayList<IConfigurationElement> actions = new ArrayList<IConfigurationElement>();
        fvToActions.put(fv, actions);
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            childName = child.getName();
            if (childName.equals(EL_CONSTRAINT)) {
                fvToConstraint.put(fv, child);
            } else if (childName.equals(EL_GROUP_MEMBER)) {
                String id = child.getAttribute(ATTR_ID);
                if (id == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(child, ATTR_ID);
                    return;
                }
                Group group = (Group)this.groups.get(id);
                if (group == null) {
                    group = new Group();
                    group.setId(id);
                    this.groups.add(id, group);
                }
                group.addMember(fv);
            } else if (childName.equals(EL_ACTION)) {
                actions.add(child);
            }
            ++i;
        }
        f.addVersion(fv);
        i = 0;
        while (i < children.length) {
            child = children[i];
            childName = child.getName();
            if (childName.equals(EL_EVENT_HANDLER)) {
                this.readEventHandler(child, f, ver);
            }
            ++i;
        }
    }

    private void readAction(IConfigurationElement config) {
        String fid = config.getAttribute(ATTR_FACET);
        if (fid == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_FACET);
            return;
        }
        ProjectFacet f = (ProjectFacet)this.facets.get(fid);
        if (f == null) {
            ProjectFacetsManagerImpl.reportMissingFacet(fid, config.getContributor().getName());
            return;
        }
        String ver = config.getAttribute(ATTR_VERSION);
        if (ver == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_VERSION);
            return;
        }
        this.readAction(config, f, ver);
    }

    private void readAction(IConfigurationElement config, ProjectFacet f, String version) {
        String pluginId = config.getContributor().getName();
        ActionDefinition def = new ActionDefinition();
        def.setPluginId(pluginId);
        String type = config.getAttribute(ATTR_TYPE);
        if (type == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_TYPE);
            return;
        }
        if (type.equals("runtime-changed")) {
            String msg = NLS.bind((String)Resources.deprecatedRuntimeChangedAction, (Object)pluginId);
            FacetCorePlugin.logWarning(msg, true);
            this.readEventHandler(config, f, version);
            return;
        }
        def.setActionType(IFacetedProject.Action.Type.valueOf(type));
        if (def.getActionType() == null) {
            String msg = String.valueOf(NLS.bind((String)Resources.invalidActionType, (Object)type)) + NLS.bind((String)Resources.usedInPlugin, (Object)pluginId);
            FacetCorePlugin.log(msg);
            return;
        }
        try {
            def.setVersionExpr(new VersionExpr(f, version, pluginId));
        }
        catch (CoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
            return;
        }
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            String clname;
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_CONFIG_FACTORY)) {
                clname = child.getAttribute(ATTR_CLASS);
                if (clname == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(child, ATTR_CLASS);
                    return;
                }
                def.setConfigFactoryClassName(clname);
            } else if (childName.equals(EL_DELEGATE)) {
                clname = child.getAttribute(ATTR_CLASS);
                if (clname == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_CLASS);
                    return;
                }
                def.setDelegateClassName(clname);
            } else if (childName.equals(EL_PROPERTY)) {
                String msg;
                String name = child.getAttribute(ATTR_NAME);
                if (name == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_NAME);
                    return;
                }
                String value = child.getAttribute(ATTR_VALUE);
                if (value == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_VALUE);
                    return;
                }
                if (name.equals("from.versions")) {
                    if (def.getActionType() != IFacetedProject.Action.Type.VERSION_CHANGE) {
                        msg = NLS.bind((String)Resources.propertyNotApplicable, (Object)name, (Object)def.getActionType().name());
                        FacetCorePlugin.logWarning(msg);
                    }
                    try {
                        VersionExpr vexpr = new VersionExpr(f, value, pluginId);
                        def.setProperty(name, vexpr);
                    }
                    catch (CoreException e) {
                        FacetCorePlugin.log((Exception)((Object)e));
                        return;
                    }
                } else {
                    msg = String.valueOf(NLS.bind((String)Resources.unknownProperty, (Object)name)) + NLS.bind((String)Resources.usedInPlugin, (Object)pluginId);
                    FacetCorePlugin.logWarning(msg);
                }
            }
            ++i;
        }
        String id = config.getAttribute(ATTR_ID);
        if (id == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(f.getId());
            buf.append('#');
            buf.append(version);
            buf.append('#');
            buf.append(def.getActionType().name());
            Iterator itr = def.getProperties().entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                buf.append('#');
                buf.append((String)entry.getKey());
                buf.append('=');
                buf.append(entry.getValue().toString());
            }
            id = buf.toString();
        }
        def.setId(id);
        if (this.isActionDefined(id)) {
            String msg = NLS.bind((String)Resources.actionAlreadyDefined, (Object)id, (Object)pluginId);
            FacetCorePlugin.logError(msg);
        } else {
            this.actions.add(def.getId(), def);
            f.addActionDefinition(def);
        }
    }

    private void readEventHandler(IConfigurationElement config) {
        String fid = config.getAttribute(ATTR_FACET);
        if (fid == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_FACET);
            return;
        }
        ProjectFacet f = (ProjectFacet)this.facets.get(fid);
        if (f == null) {
            ProjectFacetsManagerImpl.reportMissingFacet(fid, config.getContributor().getName());
            return;
        }
        String ver = config.getAttribute(ATTR_VERSION);
        if (ver == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_VERSION);
            return;
        }
        this.readEventHandler(config, f, ver);
    }

    private void readEventHandler(IConfigurationElement config, ProjectFacet f, String version) {
        EventHandler h = new EventHandler();
        String pluginId = config.getContributor().getName();
        h.setPluginId(pluginId);
        String type = config.getAttribute(ATTR_TYPE);
        if (type == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_TYPE);
            return;
        }
        if (type.equals("runtime-changed")) {
            h.setType(EventHandler.Type.RUNTIME_CHANGED);
        } else {
            h.setType(EventHandler.Type.valueOf(type));
        }
        if (h.getType() == null) {
            String msg = String.valueOf(NLS.bind((String)Resources.invalidEventHandlerType, (Object)type)) + NLS.bind((String)Resources.usedInPlugin, (Object)pluginId);
            FacetCorePlugin.log(msg);
            return;
        }
        try {
            h.setVersionExpr(new VersionExpr(f, version, pluginId));
        }
        catch (CoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
            return;
        }
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_DELEGATE)) {
                String clname = child.getAttribute(ATTR_CLASS);
                if (clname == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_CLASS);
                    return;
                }
                h.setDelegate(clname);
            }
            ++i;
        }
        if (!h.hasDelegate()) {
            ProjectFacetsManagerImpl.reportMissingElement(config, EL_DELEGATE);
            return;
        }
        f.addEventHandler(h);
    }

    private void readConstraint(IConfigurationElement config, ProjectFacetVersion fv) {
        IConfigurationElement[] ops = config.getChildren();
        ArrayList<IConstraint> parsed = new ArrayList<IConstraint>();
        int j = 0;
        while (j < ops.length) {
            IConstraint op = this.readConstraintHelper(ops[j], fv);
            if (op != null) {
                parsed.add(op);
            }
            ++j;
        }
        if (parsed.size() == 1) {
            fv.setConstraint((IConstraint)parsed.get(0));
        } else if (parsed.size() > 1) {
            Constraint and = new Constraint(fv, IConstraint.Type.AND, parsed.toArray());
            fv.setConstraint(and);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IConstraint readConstraintHelper(IConfigurationElement root, ProjectFacetVersion fv) {
        Object[] operands;
        String pluginId = root.getContributor().getName();
        IConstraint.Type type = IConstraint.Type.valueOf(root.getName());
        if (type == IConstraint.Type.AND || type == IConstraint.Type.OR) {
            IConfigurationElement[] children = root.getChildren();
            operands = new IConstraint[children.length];
            int i = 0;
            while (i < children.length) {
                IConstraint operand = this.readConstraintHelper(children[i], fv);
                if (operand == null) {
                    return null;
                }
                operands[i] = operand;
                ++i;
            }
            return new Constraint(fv, type, operands);
        }
        if (type == IConstraint.Type.REQUIRES) {
            VersionExpr vexpr;
            IProjectFacet f;
            String fid = root.getAttribute(ATTR_FACET);
            if (fid == null) {
                ProjectFacetsManagerImpl.reportMissingAttribute(root, ATTR_FACET);
                return null;
            }
            String vexprstr = root.getAttribute(ATTR_VERSION);
            if (vexprstr == null) {
                ProjectFacetsManagerImpl.reportMissingAttribute(root, ATTR_VERSION);
                return null;
            }
            try {
                f = this.getProjectFacet(fid);
                vexpr = new VersionExpr(f, vexprstr, pluginId);
            }
            catch (CoreException e) {
                FacetCorePlugin.log((Exception)((Object)e));
                return null;
            }
            String softStr = root.getAttribute(ATTR_SOFT);
            Boolean soft = Boolean.FALSE;
            if (softStr != null && softStr.equals(Boolean.TRUE.toString())) {
                soft = Boolean.TRUE;
            }
            operands = new Object[]{f, vexpr, soft};
            return new Constraint(fv, type, operands);
        }
        if (type != IConstraint.Type.CONFLICTS) throw new IllegalStateException();
        String gid = root.getAttribute(ATTR_GROUP);
        String fid = root.getAttribute(ATTR_FACET);
        String vexprstr = root.getAttribute(ATTR_VERSION);
        if (gid != null && (fid != null || vexprstr != null)) {
            String msg = NLS.bind((String)Resources.invalidConflictsConstraint, (Object)pluginId);
            FacetCorePlugin.logError(msg, true);
            return null;
        }
        if (gid != null) {
            if (!this.isGroupDefined(gid)) {
                String msg = String.valueOf(NLS.bind((String)Resources.groupNotDefined, (Object)gid)) + NLS.bind((String)Resources.usedInPlugin, (Object)pluginId);
                FacetCorePlugin.logError(msg, true);
                return null;
            }
            operands = new Object[]{this.getGroup(gid)};
            return new Constraint(fv, type, operands);
        }
        if (fid != null) {
            IProjectFacet f;
            VersionExpr vexpr = null;
            try {
                f = this.getProjectFacet(fid);
                if (vexprstr != null) {
                    vexpr = new VersionExpr(f, vexprstr, pluginId);
                }
            }
            catch (CoreException e) {
                FacetCorePlugin.log((Exception)((Object)e));
                return null;
            }
            operands = vexpr == null ? new Object[]{f} : new Object[]{f, vexpr};
            return new Constraint(fv, type, operands);
        }
        String msg = Resources.bind(Resources.missingOneOfTwoAttributes, pluginId, root.getName(), ATTR_GROUP, ATTR_FACET);
        FacetCorePlugin.logError(msg, true);
        return null;
    }

    private void readTemplate(IConfigurationElement config) {
        FacetedProjectTemplate template = new FacetedProjectTemplate();
        String id = config.getAttribute(ATTR_ID);
        if (id == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_ID);
            return;
        }
        template.setId(id);
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_LABEL)) {
                template.setLabel(child.getValue().trim());
            } else if (childName.equals(EL_FIXED)) {
                String fid = child.getAttribute(ATTR_FACET);
                if (fid == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(child, ATTR_FACET);
                    return;
                }
                if (!this.isProjectFacetDefined(fid)) {
                    ProjectFacetsManagerImpl.reportMissingFacet(fid, child.getContributor().getName());
                    return;
                }
                template.addFixedProjectFacet(this.getProjectFacet(fid));
            } else if (childName.equals(EL_PRESET)) {
                String pid = child.getAttribute(ATTR_ID);
                if (pid == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(child, ATTR_ID);
                    return;
                }
                if (!this.isPresetDefined(pid)) {
                    String msg = String.valueOf(NLS.bind((String)Resources.presetNotDefined, (Object)pid)) + NLS.bind((String)Resources.usedInPlugin, (Object)child.getContributor().getName());
                    FacetCorePlugin.log(msg);
                    return;
                }
                template.setInitialPreset(this.getPreset(pid));
            }
            ++i;
        }
        this.templates.add(id, template);
    }

    private void readPreset(IConfigurationElement config) {
        Preset preset = new Preset();
        String id = config.getAttribute(ATTR_ID);
        if (id == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_ID);
            return;
        }
        preset.setId(id);
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_LABEL)) {
                preset.setLabel(child.getValue().trim());
            } else if (childName.equals(EL_DESCRIPTION)) {
                preset.setDescription(child.getValue().trim());
            } else if (childName.equals(ATTR_FACET)) {
                String fid = child.getAttribute(ATTR_ID);
                if (fid == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(child, ATTR_ID);
                    return;
                }
                String fver = child.getAttribute(ATTR_VERSION);
                if (fver == null) {
                    ProjectFacetsManagerImpl.reportMissingAttribute(child, ATTR_VERSION);
                    return;
                }
                IProjectFacetVersion fv = this.getProjectFacet(fid).getVersion(fver);
                preset.addProjectFacet(fv);
            }
            ++i;
        }
        if (preset.getDescription() == null) {
            preset.setDescription("");
        }
        this.presets.add(id, preset);
    }

    static void reportMissingAttribute(IConfigurationElement el, String attribute) {
        Object[] params = new String[]{el.getContributor().getName(), el.getName(), attribute};
        String msg = NLS.bind((String)Resources.missingAttribute, (Object[])params);
        FacetCorePlugin.log(msg);
    }

    static void reportMissingElement(IConfigurationElement el, String element) {
        Object[] params = new String[]{el.getContributor().getName(), el.getName(), element};
        String msg = NLS.bind((String)Resources.missingElement, (Object[])params);
        FacetCorePlugin.log(msg);
    }

    private void saveUserPresets() {
        try {
            Preferences root = ProjectFacetsManagerImpl.getUserPresetsPreferences();
            String[] children = root.childrenNames();
            int i = 0;
            while (i < children.length) {
                root.node(children[i]).removeNode();
                ++i;
            }
            Iterator itr = this.presets.iterator();
            while (itr.hasNext()) {
                IPreset preset = (IPreset)itr.next();
                if (!preset.isUserDefined()) continue;
                Preferences pnode = root.node(preset.getId());
                pnode.put(EL_LABEL, preset.getLabel());
                pnode.put(EL_DESCRIPTION, preset.getDescription());
                int counter = 1;
                Iterator itr2 = preset.getProjectFacets().iterator();
                while (itr2.hasNext()) {
                    IProjectFacetVersion f = (IProjectFacetVersion)itr2.next();
                    Preferences fnode = pnode.node(String.valueOf(counter));
                    fnode.put(ATTR_ID, f.getProjectFacet().getId());
                    fnode.put(ATTR_VERSION, f.getVersionString());
                    ++counter;
                }
            }
            root.flush();
        }
        catch (BackingStoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
        }
    }

    private void readUserPresets() {
        try {
            Preferences root = ProjectFacetsManagerImpl.getUserPresetsPreferences();
            String[] pkeys = root.childrenNames();
            int i = 0;
            while (i < pkeys.length) {
                Preferences pnode = root.node(pkeys[i]);
                String label = pnode.get(EL_LABEL, null);
                if (label != null) {
                    String description = pnode.get(EL_DESCRIPTION, null);
                    if (description == null) {
                        description = "";
                    }
                    String[] fkeys = pnode.childrenNames();
                    HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();
                    int j = 0;
                    while (j < fkeys.length) {
                        IProjectFacet f;
                        Preferences fnode = pnode.node(fkeys[j]);
                        String id = fnode.get(ATTR_ID, null);
                        String version = fnode.get(ATTR_VERSION, null);
                        if (id == null || version == null) {
                            facets = null;
                            break;
                        }
                        if (this.isProjectFacetDefined(id)) {
                            f = this.getProjectFacet(id);
                            if (!f.hasVersion(version)) {
                                facets = null;
                                break;
                            }
                        } else {
                            facets = null;
                            break;
                        }
                        facets.add(f.getVersion(version));
                        ++j;
                    }
                    if (facets != null) {
                        this.definePreset(label, description, facets, false);
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (BackingStoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
        }
    }

    private static Preferences getUserPresetsPreferences() {
        InstanceScope scope = new InstanceScope();
        IEclipsePreferences pluginRoot = scope.getNode("org.eclipse.wst.common.project.facet.core");
        return pluginRoot.node("user.presets");
    }

    private static String toString(Collection collection) {
        StringBuffer buf = new StringBuffer();
        Iterator itr = collection.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (buf.length() > 0) {
                buf.append(", ");
            }
            if (obj instanceof IProjectFacetVersion) {
                IProjectFacetVersion fv = (IProjectFacetVersion)obj;
                buf.append(fv.getProjectFacet().getId());
                buf.append(' ');
                buf.append(fv.getVersionString());
                continue;
            }
            buf.append(obj.toString());
        }
        return buf.toString();
    }

    private final class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            Map map = ProjectFacetsManagerImpl.this.projects;
            synchronized (map) {
                Iterator itr = ProjectFacetsManagerImpl.this.projects.values().iterator();
                while (itr.hasNext()) {
                    FacetedProject fproj = (FacetedProject)itr.next();
                    IResourceDelta subdelta = delta.findMember(fproj.f.getFullPath());
                    if (subdelta == null) continue;
                    try {
                        fproj.refresh();
                    }
                    catch (CoreException e) {
                        FacetCorePlugin.log((Exception)((Object)e));
                    }
                }
            }
        }
    }

    public static final class Resources
    extends NLS {
        public static String missingAttribute;
        public static String missingOneOfTwoAttributes;
        public static String missingElement;
        public static String categoryNotDefined;
        public static String facetNotDefined;
        public static String facetVersionNotDefined;
        public static String actionNotDefined;
        public static String actionAlreadyDefined;
        public static String groupNotDefined;
        public static String presetNotDefined;
        public static String templateNotDefined;
        public static String usedInPlugin;
        public static String usedInConstraint;
        public static String invalidActionType;
        public static String invalidEventHandlerType;
        public static String invalidConflictsConstraint;
        public static String deprecatedRuntimeChangedAction;
        public static String tracingActionSorting;
        public static String unknownProperty;
        public static String propertyNotApplicable;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.ProjectFacetsManagerImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.ProjectFacetsManagerImpl$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        public static String bind(String template, Object arg1, Object arg2, Object arg3) {
            return NLS.bind((String)template, (Object[])new Object[]{arg1, arg2, arg3});
        }

        public static String bind(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
            return NLS.bind((String)template, (Object[])new Object[]{arg1, arg2, arg3, arg4});
        }
    }
}

