#include "wmParser.h"
#include <stdlib.h>
#include <string.h>

void fgetvalue(char *line,FILE *f)
{
	int count=0;
	int c;
	c=fgetc(f);
	while ((c!=EOF)&&(c!=';')&&(c!='{')&&(c!='}')) {
		if (c!='\n') line[count++]=c;
		c=fgetc(f);
	}
	line[count]='\0';
}

void getMiddleValue(char *value,char *middle)
{
	int length;
	int count;
	int mcount;
	
	length=strlen(value);
	count=mcount=0;
	strcpy(middle,"");
	while ((value[count]!=',')&&(count<length)) count++;
	if (count==length) return;
	count++;
	while (((value[count]==' ')||(value[count]=='\t'))&&(count<length)) count++;
	if (count==length) return;
	while ((value[count]!=',')&&(count<length)) {
		middle[mcount]=value[count];
		count++;
		mcount++;
	}
	middle[mcount]='\0';
}

void getNameValuePair(char *buffer,char *name,char *value)
{
	int count;
	int length;
	int nameCount,valueCount;
	
	length=strlen(buffer);
	count=0;
	nameCount=valueCount=0;
	strcpy(name,"");
	strcpy(value,"");
	while ((buffer[count]!='=')&&(count<length)) {
		name[nameCount]=buffer[count];
		count++;
		nameCount++;
	}
	name[nameCount]='\0';
	if (count>=length) return;
	count++;
	while ((buffer[count]!='\n')&&(buffer[count]!='\0')&&(count<length)) {
		value[valueCount]=buffer[count];
		valueCount++;
		count++;
	}
	value[valueCount]='\0';
}

struct stDirectoryll *getIconPath(void)
{
	char homeDir[80];
	char fileAdd[]="/GNUstep/Defaults/WindowMaker";
	char filename[512];
	FILE *f;
	char line[2048];
	char name[80];
	char value[2048];
	char pathValue[2048];
	char pathName[80];
	struct stDirectoryll *first,*current,*temp;
	int position=0;
	
	strcpy(homeDir,getenv("HOME"));
	strcpy(filename,homeDir);
	strcat(filename,fileAdd);
	
	first=current=NULL;
	
	f=fopen(filename,"r");
	if (f==NULL) return (NULL);
	strcpy(pathValue,"");
	while (!feof(f)) {
		fgetvalue(line,f);
		if (!feof(f)) {
			getNameValuePair(&line[strspn(line," \t")],name,value);
			if (strlen(name)>2) {
				name[strlen(name)-1]='\0';
			}
			if (!strcmp(name,"IconPath")) {
				strcpy(pathValue,value);
			}
		}
	}
	fclose(f);
	if (strlen(pathValue)<1) return(NULL);
	while ((position=getWMValue(position,pathValue,pathName))>0) {
		if (first==NULL) {
			first=(struct stDirectoryll *)malloc(sizeof(struct stDirectoryll));
			current=first;
		} else {
			temp=(struct stDirectoryll *)malloc(sizeof(struct stDirectoryll));
			current->next=temp;
			current=temp;
		}
		strcpy(current->name,pathName);
		current->next=NULL;
	}
	
	return (first);
}

int getWMValue(int position,char *valueStr,char *value)
{
	int count,vcount,length;
	
	length=strlen(valueStr);
	count=vcount=0;
	/* Get rid of the beginning white space or parenthesis */
	count=position+strspn(valueStr," \t(");
	if (count>=length) return -1;
	while ((valueStr[count]!=',')&&(valueStr[count]!=' ')&&
	       (valueStr[count]!='\t')&&(valueStr[count]!=')')&&
		   (count<length)) {
		value[vcount]=valueStr[count];
		count++;
		vcount++;
	}
	value[vcount]='\0';
	stripQuotes(value);
	expandTilde(value);
	
	return count;
}

void stripQuotes(char *value)
{
	if (value[0]=='"') {
		strcpy(value,&value[1]);
	}
	if (value[strlen(value)-1]=='"') {
		value[strlen(value)-1]='\0';
	}
}

void expandTilde(char *value)
{
	char temp[2048];

	if (value[0]!='~') return;
	snprintf(temp,sizeof(temp),"%s%s",getenv("HOME"),&value[1]);
	strcpy(value,temp);
}
