#include "wmOptions.h"
#include "uninstall.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <dirent.h>
#include <unistd.h>

void findGlobalInstallPath(char *);

int getOptions(struct stWMOptions *options)
{
	char homeDir[256];
	char optionsDir[256];
	char optionsFilename[512];
	char tempPath[256];
	int error=0;
	FILE *f;
	
	/* Get our home enviroment variable for the home directory */
	strcpy(homeDir,getenv("HOME"));
	/* Copy our home directory name to the options filename */
	strcpy(optionsFilename,homeDir);
	/* Fill in the rest of our options file's filename */
	strcat(optionsFilename,"/.themeinstaller/wmoptions");
	/* Open the options file */
	f=fopen(optionsFilename,"r");
	/* If the options file doesn't exist... */
	if (f==NULL) {
		/* Fill in some default values */
		strcpy(options->defaultDirectory,homeDir);
		findGlobalInstallPath(options->globalInstallPath);
		strcpy(options->userInstallPath,homeDir);
		strcat(options->userInstallPath,"/GNUstep/Library/WindowMaker/");
		options->installType=LOCAL_INSTALL;
		options->removeTheme=REMOVE_THEME;
		strcpy(optionsDir,getenv("HOME"));
		strcat(optionsDir,"/.themeinstaller/");
		mkdir(optionsDir,S_IRWXU);
		error=writeOptions(options);
	} else {
		fclose(f);
		findStrOption(optionsFilename,"Default Directory",options->defaultDirectory);
		if (!strcmp(options->defaultDirectory,"")) {
			strcpy(options->defaultDirectory,homeDir);
		}
		findStrOption(optionsFilename,"Global Install Path",options->globalInstallPath);
		strcpy(tempPath,options->globalInstallPath);
		findGlobalInstallPath(tempPath);
		if ((strcmp(options->globalInstallPath,tempPath))||
			(tempPath[0]==0)) {
			strcpy(options->globalInstallPath,tempPath);
		}
		findStrOption(optionsFilename,"User Install Path",options->userInstallPath);
		if (strcmp(options->userInstallPath,"")==0) {
			strncpy(options->userInstallPath,homeDir,sizeof(options->userInstallPath));
			strcat(options->userInstallPath,"/GNUstep/Library/WindowMaker/");
		}
		options->installType=findIntOption(optionsFilename,"Install Type");
		if (options->installType==0) {
			options->installType=LOCAL_INSTALL;
		}
		options->removeTheme=findIntOption(optionsFilename,"Remove Theme");
		if (options->removeTheme==0) {
			options->removeTheme=REMOVE_THEME;
		}
		error=writeOptions(options);
	}
	return (error);
}

int writeOptions(struct stWMOptions *options)
{
	char homeDir[256];
	char optionsFilename[512];
	FILE *f;

	/* Check our directory variables and make sure they have a 
	   trailing slash on them */
	checkSlash(options->defaultDirectory,PATH_MAX);
	if (options->globalInstallPath[0]!=0) 
		checkSlash(options->globalInstallPath,PATH_MAX);
	checkSlash(options->userInstallPath,PATH_MAX);
	/* Get our home enviroment variable for the home directory */
	strcpy(homeDir,getenv("HOME"));
	/* Copy our home directory name to the options filename */
	strcpy(optionsFilename,homeDir);
	/* Fill in the rest of our options file's filename */
	strcat(optionsFilename,"/.themeinstaller/wmoptions");
	/* Open the options file */
	f=fopen(optionsFilename,"w");
	if (f==NULL) return (WMOPTERR_UNABLETOWRITE);
	/* Write the options to the file */
	fprintf(f,"Default Directory=%s\n",options->defaultDirectory);
	fprintf(f,"Global Install Path=%s\n",options->globalInstallPath);
	fprintf(f,"User Install Path=%s\n",options->userInstallPath);
	fprintf(f,"Install Type=%d\n",options->installType);
	fprintf(f,"Remove Theme=%d\n",options->removeTheme);
	/* Close the file */
	fclose(f);
}

int findStrOption(char *filename,char *optionName,char *option)
{
	FILE *f;
	char buffer[512];
	char name[80];
	char value[256];

	f=fopen(filename,"r");
	if (f==NULL) return(WMOPTERR_UNABLETOREAD);
	while (!feof(f)) {
		fgets(buffer,sizeof(buffer),f);
		if (!feof(f)) {
			getNameValuePair(buffer,name,value);
			if (strcasecmp(optionName,name)==0) {
				strcpy(option,value);
			}
		}
	}
	fclose(f);
	return (0);
}

int findIntOption(char *filename,char *optionName)
{
	char optionStr[80];
	
	strcpy(optionStr,"");
	findStrOption(filename,optionName,optionStr);
	
	return (atoi(optionStr));
}

void findGlobalInstallPath(char *path)
{
	struct stat pathStat;
	char pathTemp[1024];
	
	if (stat("/usr/local/share/WindowMaker/",&pathStat)==0) {
		strcpy(path,"/usr/local/share/WindowMaker/");
	} else if (stat("/usr/share/WindowMaker/",&pathStat)==0) {
		strcpy(path,"/usr/share/WindowMaker/");
	} else if (stat(path,&pathStat)!=0) path[0]=0;
	if (path[0]==0) return;
	strcpy(pathTemp,path);
	checkSlash(pathTemp,1024);
	strcat(pathTemp,"Themes");
	if (stat(pathTemp,&pathStat)!=0) path[0]=0;
}

void checkSlash(char *path,int size)
{
	int length;
	
	length=strlen(path);
	if (path[length-1]!='/') {
		strncat(path,"/",size-length);
	}
}
