#include "mainWidget.h"
#include "uninstallWidget.h"
#include "installWidget.h"
#include "uninstall.h"
#include "optionDialog.h"

#ifndef HAVE_CONFIG
#	include "config.h"
#endif

void addSeparator(GtkWidget *menu)
{
	GtkWidget *separator;
	GtkWidget *menuItem;
	
	menuItem=gtk_menu_item_new();
	separator=gtk_hseparator_new();
	gtk_widget_show(separator);
	gtk_container_add(GTK_CONTAINER(menuItem),separator);
	gtk_menu_append(GTK_MENU(menu),menuItem);
	gtk_widget_show(menuItem);
}

void addSystemMenu(GtkWidget *menu)
{
	GtkWidget *menuItem;

	menuItem=gtk_menu_item_new_with_label("System");
	gtk_menu_append(GTK_MENU(menu),menuItem);	
	setSystemMenu(menuItem);
}

void addUserMenu(GtkWidget *menu)
{
	GtkWidget *menuItem;
	
	menuItem=gtk_menu_item_new_with_label("User");
	gtk_menu_append(GTK_MENU(menu),menuItem);
	setUserMenu(menuItem);
}

GtkWidget *createMenuBar()
{
	GtkWidget *menuBar;
	GtkWidget *rootMenu;
	GtkWidget *fileMenu,*themeMenu;
	GtkWidget *menuItem;
	
	menuBar=gtk_menu_bar_new();
	gtk_widget_show(menuBar);
	
	fileMenu=gtk_menu_new();
	
	menuItem=gtk_menu_item_new_with_label("Options...");
	gtk_menu_append(GTK_MENU(fileMenu),menuItem);
	gtk_signal_connect(GTK_OBJECT(menuItem),"activate",
		GTK_SIGNAL_FUNC(showOptionDialog),NULL);
	gtk_widget_show(menuItem);
	
	menuItem=gtk_menu_item_new_with_label("Install");
	gtk_menu_append(GTK_MENU(fileMenu),menuItem);
	gtk_signal_connect(GTK_OBJECT(menuItem),"activate",
		GTK_SIGNAL_FUNC(installButtonClicked),NULL);
	gtk_widget_show(menuItem);
	
	addSeparator(fileMenu);
	
	menuItem=gtk_menu_item_new_with_label("Quit");
	gtk_menu_append(GTK_MENU(fileMenu),menuItem);
	gtk_signal_connect(GTK_OBJECT(menuItem),"activate",
		GTK_SIGNAL_FUNC(gtk_main_quit),NULL);
	gtk_widget_show(menuItem);
	
	rootMenu=gtk_menu_item_new_with_label("File");
	gtk_widget_show(rootMenu);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(rootMenu),fileMenu);
	
	gtk_menu_bar_append(GTK_MENU_BAR(menuBar),rootMenu);
	
	themeMenu=gtk_menu_new();
	
	menuItem=gtk_menu_item_new_with_label("Uninstall");
	gtk_menu_append(GTK_MENU(themeMenu),menuItem);
	gtk_signal_connect(GTK_OBJECT(menuItem),"activate",
		GTK_SIGNAL_FUNC(uninstallThemeButtonClicked),NULL);
	gtk_widget_show(menuItem);
	
	menuItem=gtk_menu_item_new_with_label("Use Theme");
	gtk_menu_append(GTK_MENU(themeMenu),menuItem);
	gtk_signal_connect(GTK_OBJECT(menuItem),"activate",
		GTK_SIGNAL_FUNC(useThemeButtonClicked),NULL);
	gtk_widget_show(menuItem);
	
	addSeparator(themeMenu);

	addSystemMenu(themeMenu);
	addUserMenu(themeMenu);
	
	rootMenu=gtk_menu_item_new_with_label("Theme");
	gtk_widget_show(rootMenu);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(rootMenu),themeMenu);
	
	gtk_menu_bar_append(GTK_MENU_BAR(menuBar),rootMenu);
	
	return (menuBar);
}

GtkWidget *createMainWidget()
{
	GtkWidget *window,*installedWidget;
	GtkWidget *installWidget;
	GtkWidget *panedWidget;
	GtkWidget *menuBar;
	GtkWidget *vbox;
	char titleString[256];
	
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	snprintf(titleString,256,"WindowMaker Theme Installer v%s",VERSION);
	gtk_window_set_title(GTK_WINDOW(window),titleString);
	
	vbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(window),vbox);
	gtk_widget_show(vbox);
	
	menuBar=createMenuBar();
	gtk_widget_show(menuBar);
	gtk_box_pack_start(GTK_BOX(vbox),menuBar,FALSE,FALSE,0);

	panedWidget=gtk_hpaned_new();
	gtk_widget_show(panedWidget);
	gtk_box_pack_start(GTK_BOX(vbox),panedWidget,TRUE,TRUE,0);
	
	installWidget=createInstallWidget();
	gtk_widget_set_usize(installWidget,250,300);
	gtk_container_set_border_width(GTK_CONTAINER(installWidget),5);
	gtk_paned_add1(GTK_PANED(panedWidget),installWidget);

	installedWidget=createInstalledWidget();
	gtk_widget_set_usize(installedWidget,250,300);
	gtk_container_set_border_width(GTK_CONTAINER(installedWidget),5);
	gtk_paned_add2(GTK_PANED(panedWidget),installedWidget);
	
	gtk_widget_show(window);
	
	gtk_signal_connect(GTK_OBJECT(window),"destroy",
		GTK_SIGNAL_FUNC(gtk_main_quit),NULL);
}