#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "uninstallWidget.h"
#include "installWidget.h"
#include "mainWidget.h"
#include "wmOptions.h"
#include "defines.h"

struct stWMOptions wmOptions;

int main(int argc, char *argv[])
{
	GtkWidget *window,*installedWidget;
	char systemPath[PATH_MAX];
	char userPath[PATH_MAX];
	
	gtk_init(&argc,&argv);
	getOptions(&wmOptions);
	
	initializeOptionDialog(&wmOptions);
	if (wmOptions.globalInstallPath[0]==0) {
		showOptionDialog(1);
	} else {	
		strncpy(systemPath,wmOptions.globalInstallPath,PATH_MAX);
		strncat(systemPath,"Themes",PATH_MAX-strlen(wmOptions.globalInstallPath));
		strncpy(userPath,wmOptions.userInstallPath,PATH_MAX);
		strncat(userPath,"Themes",PATH_MAX-strlen(wmOptions.userInstallPath));

		createMainWidget();
		updateInstalledTree(systemPath,userPath);
		setInstallPath(wmOptions.defaultDirectory);
	}

	gtk_main();

	return (0);
}
