#include "uninstallWidget.h"
#include "wmOptions.h"
#include "installWidget.h"
#include "install.h"
#include "defines.h"
#include "dirBrowser.h"
#include <sys/types.h>
#include "tarutil.h"
#include <dirent.h>

#include "folder.xpm"
#include "theme.xpm"

struct stInstallWidget {
	char installPath[PATH_MAX];
	GtkWidget *installPathLabel;
	GtkWidget *directoryList;
	struct stDirll *firstEntry;
} installWidget;

void setInstallPath(char *newInstallPath)
{
	DIR *dir;

	dir=opendir(newInstallPath);
	if (dir==NULL) {
		showMessageDialog("Error","Unable to change into\nselected directory.");		
	} else {
		closedir(dir);
		strncpy(installWidget.installPath,newInstallPath,PATH_MAX);
		if (installWidget.installPathLabel) {
			gtk_entry_set_text(GTK_ENTRY(installWidget.installPathLabel),
				installWidget.installPath);
		}
		if (installWidget.directoryList) {
			fillDirectoryList();
		}
	}
}

void installButtonClicked(gpointer data)
{
	gchar *text;
	int row;
	GList *firstSelection,*currentSelection;
	GtkWidget *dirList;
	guint8 spacing;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	char themeSubdirectory[PATH_MAX];
	char filename[PATH_MAX];
	struct stWMOptions options;
	int error;
	
	firstSelection=GTK_CLIST(installWidget.directoryList)->selection;
	if (firstSelection==NULL) {
		showMessageDialog("Error","No themes are selected\nto be installed.");
	} else {
/*		This section will be used when we have area installation support
		
		getInstalledDirectory(themeSubdirectory);
		printf("%s\n",themeSubdirectory);
		if (strcmp(themeSubdirectory,"")==0) {
			showMessageDialog("Error","No install location has\nbeen selected.");
			return;
		}
		themeSubdirectory[strlen(themeSubdirectory)-7]='\0';*/
		
		getOptions(&options);
		
		if (options.installType==GLOBAL_INSTALL)
			strncpy(themeSubdirectory,options.globalInstallPath,PATH_MAX);
		else
			strncpy(themeSubdirectory,options.userInstallPath,PATH_MAX);
		row=(int)firstSelection->data;
		gtk_clist_get_pixtext(GTK_CLIST(installWidget.directoryList),
			row,0,&text,&spacing,&pixmap,&mask);
		snprintf(filename,PATH_MAX,"%s%s",installWidget.installPath,
			text);
		if (checkTheme(filename)==2) {
			strcat(themeSubdirectory,"Themes/");
		}
		error=untar(filename,themeSubdirectory);
		if (error) {
			showMessageDialog("Error",tarError);
			return;
		}
//		installTheme(filename,themeSubdirectory);
		refreshInstalledTree();
		if (options.removeTheme==REMOVE_THEME) {
			unlink(filename);
			fillDirectoryList();
		}
	}
/*	if (first==NULL) return;
	current=first;
	while (current!=NULL) {
		row=(int)current->data;
		gtk_clist_get_pixtext(GTK_CLIST(dirList),row,0,&text,&spacing,&pixmap,&mask);
		installTheme(text);
		current=current->next;
	}
	refreshLists();*/
}

void installSelectionMade(GtkWidget *clist,gint row,gint column,
	GdkEventButton *event,gpointer data)
{
	struct stDirll *current;
	int count=0;
	char newDirectory[PATH_MAX];
	char message[1024];
	gchar *text;
	guint8 spacing;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	
	current=installWidget.firstEntry;
	gtk_clist_get_pixtext(GTK_CLIST(clist),row,0,&text,&spacing,
		&pixmap,&mask);
	if (current) {
		while (strcmp(current->filename,text)!=0) {
			current=current->next;
			if (current==NULL) break;
		}
		if (current==NULL) {
			snprintf(message,1024,"Unable to locate the directory\n%s",text);
			showMessageDialog("Error",message);
			return;
		}
		if (current->type==DIRECTORY) {
			if (!strcmp(text,"..")) {
				strncpy(newDirectory,installWidget.installPath,PATH_MAX);
				stripDirectory(newDirectory);
				checkSlash(newDirectory,PATH_MAX);
				setInstallPath(newDirectory);
			} else {
				snprintf(newDirectory,PATH_MAX,"%s%s/",
					installWidget.installPath,text);
				checkSlash(newDirectory,PATH_MAX);
				setInstallPath(newDirectory);
			}
		}
	}
}

void fillDirectoryList()
{
	struct stDirll *currentDir,*firstDir;
	gchar *name[2];
	GdkPixmap *folderPixmap,*themePixmap;
	GdkBitmap *folderMask,*themeMask;
	char oldDirectory[PATH_MAX];
	int count=0;
	
	if (!installWidget.directoryList) return;
	
	gtk_clist_freeze(GTK_CLIST(installWidget.directoryList));
	gtk_clist_clear(GTK_CLIST(installWidget.directoryList));
	folderPixmap=gdk_pixmap_create_from_xpm_d(installWidget.directoryList->window,
		&folderMask,NULL,folder_xpm);
	themePixmap=gdk_pixmap_create_from_xpm_d(installWidget.directoryList->window,
		&themeMask,NULL,theme_xpm);
	firstDir=getDirectoryList(installWidget.installPath);
	if (firstDir==NULL) {
		gtk_clist_thaw(GTK_CLIST(installWidget.directoryList));
		showMessageDialog("Error","Unable to read directory");
		strncpy(oldDirectory,installWidget.installPath,PATH_MAX);
		stripDirectory(oldDirectory);
		checkSlash(oldDirectory,PATH_MAX);
		setInstallPath(oldDirectory);
		return;
	} else {
		installWidget.firstEntry=firstDir;
	}
	currentDir=installWidget.firstEntry;
	name[0]=(gchar *)malloc(NAME_MAX);
	while (currentDir!=NULL) {
		strncpy(name[0],currentDir->filename,NAME_MAX);
		gtk_clist_append(GTK_CLIST(installWidget.directoryList),
			name);
		if (currentDir->type==DIRECTORY) {
			gtk_clist_set_pixtext(GTK_CLIST(installWidget.directoryList),
				count,0,currentDir->filename,2,folderPixmap,folderMask);
		} else {
			gtk_clist_set_pixtext(GTK_CLIST(installWidget.directoryList),
				count,0,currentDir->filename,2,themePixmap,themeMask);
		}
		count++;
		currentDir=currentDir->next;
	}
	gtk_clist_thaw(GTK_CLIST(installWidget.directoryList));
}

void pathEntry(GtkWidget *widget,GtkWidget *entry)
{
	gchar *text;
	DIR *dir;
	char message[1024];
	
	text=gtk_entry_get_text(GTK_ENTRY(entry));
	dir=opendir(text);
	if (dir==NULL) {
		snprintf(message,1024,"Unable to open directory\n%s",text);
		showMessageDialog("Error",message);
		gtk_entry_set_text(GTK_ENTRY(entry),installWidget.installPath);
	} else {
		closedir(dir);
		strncpy(message,text,1024);
		checkSlash(message,sizeof(message));
		setInstallPath(message);
	}
}

GtkWidget *createInstallWidget()
{
	GtkWidget *vbox;
	GtkWidget *scrolledWidget;
	GtkWidget *installButton;
	
	vbox=gtk_vbox_new(FALSE,0);
	gtk_widget_show(vbox);
	
	installWidget.installPathLabel=gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(vbox),installWidget.installPathLabel,
		FALSE,FALSE,0);
	gtk_signal_connect(GTK_OBJECT(installWidget.installPathLabel),
		"activate",GTK_SIGNAL_FUNC(pathEntry),
		installWidget.installPathLabel);
	gtk_widget_show(installWidget.installPathLabel);
	
	scrolledWidget=gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledWidget),GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);
	gtk_box_pack_start(GTK_BOX(vbox),scrolledWidget,TRUE,TRUE,5);
	gtk_widget_show(scrolledWidget);
	
	installWidget.directoryList=gtk_clist_new(1);
	gtk_container_add(GTK_CONTAINER(scrolledWidget),
		installWidget.directoryList);
	gtk_clist_set_column_width(GTK_CLIST(installWidget.directoryList),
		0,200);
	gtk_signal_connect(GTK_OBJECT(installWidget.directoryList),
		"select_row",GTK_SIGNAL_FUNC(installSelectionMade),NULL);
	gtk_widget_show(installWidget.directoryList);
	
	installButton=gtk_button_new_with_label("Install");
	gtk_box_pack_start(GTK_BOX(vbox),installButton,FALSE,TRUE,0);
	gtk_signal_connect(GTK_OBJECT(installButton),"clicked",
		GTK_SIGNAL_FUNC(installButtonClicked),NULL);
	gtk_widget_show(installButton);
	
	return vbox;
}
