#include "inputDialog.h"

char prefixString[INPUT_MAX_LENGTH];
GtkWidget *inputField,*inputDialog;

void inputOkPressed(GtkWidget *widget,gpointer okFunction)
{
	void (*okFunc)();
	char returnString[INPUT_MAX_LENGTH];
	
	okFunc=okFunction;
	snprintf(returnString,INPUT_MAX_LENGTH,"%s%s",prefixString,
		gtk_entry_get_text(GTK_ENTRY(inputField)));
	okFunc(returnString);
	gtk_widget_destroy(inputDialog);
}

void showInputDialog(GtkSignalFunc okFunction,char *title,char *label,char *prefix)
{
	GtkWidget *okButton,*cancelButton;
	GtkWidget *labelWidget;
	GtkWidget *hbox;
	
	strncpy(prefixString,prefix,INPUT_MAX_LENGTH);
	
	inputDialog=gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(inputDialog),title);

	okButton=gtk_button_new_with_label("Okay");
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(inputDialog)->action_area),
		okButton,TRUE,TRUE,0);
	gtk_signal_connect(GTK_OBJECT(okButton),"clicked",
		GTK_SIGNAL_FUNC(inputOkPressed),(gpointer)okFunction);
	gtk_widget_show(okButton);
	
	cancelButton=gtk_button_new_with_label("Cancel");
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(inputDialog)->action_area),
		cancelButton,TRUE,TRUE,0);
	gtk_signal_connect_object(GTK_OBJECT(cancelButton),"clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(inputDialog));
	gtk_widget_show(cancelButton);
	
	hbox=gtk_hbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox),5);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(inputDialog)->vbox),
		hbox,TRUE,TRUE,0);
		
	labelWidget=gtk_label_new(label);
	gtk_widget_show(labelWidget);
	gtk_box_pack_start(GTK_BOX(hbox),labelWidget,FALSE,FALSE,0);
	
	inputField=gtk_entry_new();
	gtk_widget_show(inputField);
	gtk_signal_connect(GTK_OBJECT(inputField),"activate",
		GTK_SIGNAL_FUNC(inputOkPressed),(gpointer)okFunction);
	gtk_box_pack_start(GTK_BOX(hbox),inputField,TRUE,TRUE,0);
	gtk_widget_grab_focus(inputField);

	gtk_container_set_focus_child(GTK_CONTAINER(hbox),inputField);
	gtk_container_set_focus_child(GTK_CONTAINER(inputDialog),inputField);
	
	gtk_window_set_modal(GTK_WINDOW(inputDialog),TRUE);
	gtk_widget_show(inputDialog);
}
