#ifndef _DEFINES_H_
#define _DEFINES_H_

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif

#ifdef HAVE_DIRENT_H
#	include <dirent.h>
#endif

/* Configure our maximum path size */
#ifndef PATH_MAX
#	ifdef HAVE_SYS_PARAM_H
#		include <sys/param.h>
#	endif
#	ifndef PATH_MAX
#		ifndef MAXPATHLEN
#			define PATH_MAX 1024
#		else
#			define PATH_MAX MAXPATHLEN
#		endif
#	endif
#endif

/* Configure our name max */
#ifndef NAME_MAX
#	define NAME_MAX 255
#endif

#include <stdarg.h>

#ifndef HAVE_SNPRINTF
extern int __snprintf __P ((char *__s, size_t __maxlen,
                            __const char *__format, ...))
     __attribute__ ((__format__ (__printf__, 3, 4)));
extern int snprintf __P ((char *__s, size_t __maxlen,
                          __const char *__format, ...))
     __attribute__ ((__format__ (__printf__, 3, 4)));
#endif

#ifndef HAVE_VSNPRINTF
extern int __vsnprintf __P ((char *__s, size_t __maxlen,
                             __const char *__format, __gnuc_va_list __arg))
     __attribute__ ((__format__ (__printf__, 3, 0)));
extern int vsnprintf __P ((char *__s, size_t __maxlen,
                           __const char *__format, __gnuc_va_list __arg))
     __attribute__ ((__format__ (__printf__, 3, 0)));
#endif

#endif
