######################################################################
#
#  GOLEM.PL - WM-specific code for the Golem window manager
#
#  This code depends on the following assumtions:
#
#    -- any theme dirs in ~/.golem end in "themes" e.g. ~/.golem/foothemes
#    -- all themes exist as a subdirectory of a theme dir and use an
#       rcfile named rc
#
#  This is written for Golem 0.0.2.


#$tosite = 'golem.themes.org';
$wm_executable = 'golem';


  ###
  #
  #  WM_GETDEFAULTDIRS
  #
  ###

sub wm_getdefaultdirs {
  if ($>) {
    verify_themedirs(1,
      glob("$home/.golem/*themes"));
  } else {
    verify_themdirs(0,
    '/usr/share/golem/themes',
    '/usr/local/share/golem/themes',
    '/usr/X11R6/share/golem/themes');
  }
}

  ###
  #
  #  WM_SCANDIR
  #
  ###

sub wm_scandir {
  my $dir = shift;
  my ($entry, $owner, %scanned);

  $owner = (stat $dir)[4];
  $scanned{$dir} = (stat _)[9];

  opendir DH, $dir or choke("Can't opendir $dir: $!");
  while (defined($entry = readdir DH)) {
    next if $entry =~ /^\.\.?$/;
    if (-d "$dir/$entry" and -f "$dir/$entry/rc") {
      createthemerec($entry, "$dir/$entry", $owner);
    }
  }
  closedir DH;
  %scanned;
}

  ###
  #
  #  WM_INSTALLTHEME
  #
  ###

sub wm_installtheme {
  my ($location, $filename, $defname) = @_;
  my ($destdir, $entry, $indir, $name);

  unless (-d $location) {
    choke("can't do single-file theme installation");
  }

  if ($>) {
    if ($localthemedir) {
      $destdir = $localthemedir;
    } else {
      choke("no local theme directory was found");
    }
  } elsif ($globalthemedir) {
    $destdir = $globalthemedir;
  } else {
    choke("no global theme directory was found");
  }

  opendir D, $location or choke("Can't opendir $location: $!");
  while (defined($entry = readdir D)) {
    next if $entry =~ /^\.\.?$/;
    if (-d "$location/$entry" and -f "$location/$entry/rc") {
      $indir = "$location/$entry";
      $name = $entry;
      last;
    }
  }
  closedir D;

  unless ($indir) {
    choke("installation failed - no rc file found");
  }

  $name = $defname if $defname;
  $name = checkname($name);
  syscmd('mv', $indir, "$destdir/$name");

  createthemerec($name, "$destdir/$name", $>);
  $name;
}

  ###
  #
  #  WM_ACTIVATETHEME
  #
  ###

sub wm_activatetheme {
  my ($themename, $explicit) = @_;
  my $rcpath = "$themes{$themename}{path}/rc";

  $rcpath =~ s!^\Q$home/.golem\E/!!;

  golem_mungemainrc();
  stowfile("$home/.golem/gotheme.rc",
    ".include \"$rcpath\"\n");

  # fixme: Now we'd like to activate it.
}

  ###
  #
  #  WM_UNINSTALLTHEME
  #
  ###

sub wm_uninstalltheme {
  my $theme = shift;

  dirwipe($themes{$theme}{path}, 1);
}

  ###
  #
  #  WM_RENAME
  #
  ###

sub wm_rename {
  my ($old, $new) = @_;

  my $oldpath = $themes{$old}{path};
  my $newpath = $oldpath;

  if ($newpath =~ s!/\Q$old\E$!/$new!) {
    rename $oldpath, $newpath;
  } else {
    choke("can't figure out old path \"$oldpath\"");
  }

  $newpath;
}

  ###
  #
  #  WM_VERSIONOK
  #
  ###

sub wm_versionok {
  1;
}

  # mungemainrc -
  #
  # * Disables any theme .include in the main golemrc file
  # * Inserts .include "gotheme.rc"

sub golem_mungemainrc {
  my $golemrc = slurpfile("$home/.golem/golemrc");

  $golemrc =~ s!^(\s*\.include\s+.*themes/.*rc\b.*)!#$1!mg;

  if ($golemrc =~ /^\s*\.include\s+"gotheme\.rc"\s*$/m) {
  } elsif ($golemrc =~ s/^(#\s+include theme.*)/$1\n.include "gotheme.rc"/im) {
  } else {
    $golemrc .= "\n.include \"gotheme.rc\"\n";
  }

  stowfile("$home/.golem/golemrc", $golemrc);
}

1;

