#  Config file/user-specific data handleing for wmtheme

##############################################################
#
#  READ_USER_CONFIG
#
#  Sets global variables  %config_wm
#
#  Call whether or not the configfile exists, it will set
#  default config values
#

sub wmconf_read_userconfig {
  my $configfile = shift;
  my ($line, $setting, $invocation, $value, $wmsetting, $wmvalue);

  my %config_default = (
    'confirm_first_backout', 'yes',
    'set_favorite_on_backout', 'no',
    'set_queried_backout', 'no',
    'version_mismatch', 'ask',
    'allow_subdirs', 'ask'
    );
  my $spmatch = join('|', keys %config_default);

    #  Make sure default settings are in effect before quitting
    #  because of a missing configuration file

  $config_wm{normalize_wmaker_styles} = 'yes';
  $config_wm{disable_rootcommands} = 'yes';
  $config_wm{valid_rootcommands} =
    'bsetbg bsetroot xv wmsetbg Esetroot xsetroot xpmroot';
  $config_wm{install_gtk_engines} = 'ask';

  if (!open CONF, $configfile) {
    foreach (keys %config_default) {
      $config_wm{$_} = $config_default{$_} if not exists $config_wm{$_};
    }
    return;
  }

  while ($line = <CONF>) {
    next if $line =~ /^\s*(#|$)/;
    chomp $line;

    if ($line =~ /^\s*(\S+)\s+(\S.*?)\s*$/) {
      ($setting, $value) = (lc $1, $2);
      if (($invocation, $wmvalue) = $value =~ /^(\S+)\s+(\S+)$/ and
          $setting =~ /^(?:$spmatch)$/) {

        #===   Settings defined per window manager  ===#

        next if $invocation ne $programname and $invocation ne 'default';
        $wmvalue = lc $wmvalue;

        if ($setting =~ /^(?:version_mismatch|allow_subdirs)/) {
          if ($wmvalue =~ /^(?:yes|no|ask)$/) {
            if ($invocation eq 'default') {
              $config_default{$setting} = $wmvalue;
            } else {
              $config_wm{$setting} = $wmvalue;
            }
          } else {
            choke("value must be yes, no, or ask, on line $. of $configfile");
          }
        } else {
          if ($wmvalue =~ /^(?:yes|no)$/) {
            if ($invocation eq 'default') {
              $config_default{$setting} = $wmvalue;
            } elsif ($invocation) {
              $config_wm{$setting} = $wmvalue;
            }
          } else {
            choke("yes or no is required, on line $. of $configfile");
          }
        }
      } else {

        #===   Global or specific settings   ===#

        if ($setting =~ /^(?:normalize_wmaker_styles|disable_rootcommands)$/) {
          if ($value =~ /^(?:yes|no)$/) {
            $config_wm{$setting} = $value;
          } else {
            choke("yes or no is required, on line $. of $configfile");
          }
        } elsif ($setting eq 'valid_rootcommands') {
          $config_wm{$setting} = $value || 'bsetroot bsetbg';
        } elsif ($setting eq 'install_gtk_engines') {
          if ($value =~ /^(?:yes|no|ask)$/) {
            $config_wm{$setting} = $value;
          } else {
            choke("yes, no, or ask is required, on line $. of $configfile");
          }
        } elsif ($setting =~ /^(?:tempfontdir|installfontcmd)$/) {
          $config_wm{$setting} = $value;
        } else {
          choke("Unknown setting \"$setting\" on line $. of $configfile");
        }
      }
    } else {
      choke("malformed setting \"$line\" on line $. of $configfile");
    }
  }

  close CONF;
  foreach (keys %config_default) {
    $config_wm{$_} = $config_default{$_} unless exists $config_wm{$_};
  }
}

##############################################################
#
#  SETUP_WMTHEME
#
#  Default configuration file installation for wmtheme
#

sub _setup_wmtheme {
  my $answer;

  checkpidavail();

  if (-d $wmthemedir) {
    print "It seems wmtheme has already been installed for this user\n";
    print "($wmthemedir exists).  Do you want to overwrite your current\n";
    print "settings with the default settings? [y/N] ";
    $answer = <STDIN>;
    if ($answer !~ /^y/i) {
      print "$programname: setup aborted.\n";
      return;
    }
  }

  if (! -d $wmthemedir) {
    mkdir $wmthemedir, 0755 or
      choke("can't mkdir $wmthemedir: $!");
  }
  if (-f "$libdir/conf.default") {
    copyfile("$libdir/conf.default", "$wmthemedir/conf");
  } elsif (-f "$programdir/conf.default") {
    copyfile("$programdir/conf.default", "$wmthemedir/conf");
  } else {
    print "Your kit is incomplete.  The sample configuration file could not be found.\n";
    print "The following file is missing:\n";
    print "  $libdir/conf.default\n";
    print "This file can be found in the wmtheme distribution.  Please install it\n";
    print "manually or reinstall wmtheme.\n";
    return;
  }
  print "$programname: Ok, wmtheme has been set up for this user.\n";
  print "  You may want to edit $wmthemedir/conf now.\n";
}


1;

