/* Author : Yong-iL Joh ( tolkien@mizi.com )
 * 
 * LICQ checker.
 *
 * Last Updated : Mar 12, 2001
 *
 */

#include "Client.h"
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <utime.h>
#include <errno.h>
#include <fcntl.h>

#define PCM     (pc->u).mbox

int licqCheckHistory(Pop3 pc)
{
	struct stat st;
	struct utimbuf ut;
	FILE *F;
	int count_status = 0;

#ifdef DEBUG_MAIL_COUNT
	printf(">Mailbox: '%s'\n", pc->path);
#endif

	/* licq file */
	if (stat(pc->path, &st)) {
		fprintf(stderr, "wmbiff: Can't stat mailbox '%s': %s\n",
				pc->path, strerror(errno));
		return -1;				/* Error stating mailbox */
	}

	if (st.st_mtime != PCM.mtime || st.st_size != PCM.size
		|| pc->OldMsgs < 0) {
		/* file was changed OR initially read */
#ifdef DEBUG_MAIL_COUNT
		printf("  was changed,"
			   " TIME: old %lu, new %lu"
			   " SIZE: old %lu, new %lu\n",
			   PCM.mtime, st.st_mtime, (unsigned long) PCM.size,
			   st.st_size);
#endif
		ut.actime = st.st_atime;
		ut.modtime = st.st_mtime;
		F = pc->open(pc);

		/* count message */
		while (fgets(buf, BUF_SIZE, F)) {
			if ((buf[0] == '[') || (buf[0] == '-')) {	/* new, or old licq */
				count_status++;
			}
		}
		pc->TotalMsgs = count_status * 2;
		pc->UnreadMsgs = pc->TotalMsgs - count_status;
#ifdef DEBUG_MAIL_COUNT
		printf("from: %d status: %d\n", pc->TotalMsgs, pc->UnreadMsgs);
#endif

		fclose(F);

		utime(pc->path, &ut);
		/* Reset atime for MUTT and something others correctly work */
		PCM.mtime = st.st_mtime;	/* Store new mtime */
		PCM.size = st.st_size;	/* Store new size */
	}

	return 0;
}

int licqCreate(Pop3 pc, char *str)
{
	/* LICQ format: licq:fullpathname */

#ifdef DEBUG_LICQ
	printf("licq: str = '%s'\n", str);
#endif

	pc->TotalMsgs = 0;
	pc->UnreadMsgs = 0;

	strcpy(pc->path, str + 5);	/* cut off ``licq:'' */
	pc->open = openMailbox;
	pc->checkMail = licqCheckHistory;

#ifdef DEBUG_LICQ
	printf("licq: path= '%s'\n", pc->path);
#endif

	return 0;
}

/* vim:set ts=4: */
