/* Author : Scott Holden ( scotth@thezone.net )
   Modified : Yong-iL Joh ( tolkien@mizi.com )
 *
 * Pop3/Imap4 Email Checker
 *
 * Last Updated : Mar 12, 2001
 *
 */


#ifndef CLIENT
#define CLIENT

#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

typedef struct _mbox_t *Pop3;
typedef struct _mbox_t {
	char label[32];				/* Printed at left; max 5 chars */
	char path[256];				/* Path to mailbox */
	char notify[256];			/* Program to notify mail arrivation */
	char action[256];			/* Action to execute on mouse click */
	char fetchcmd[256];			/* Action for mail fetching for pop3/imap */
	int fetchinterval;
	int TotalMsgs;				/* Total messages in mailbox */
	int UnreadMsgs;				/* New (unread) messages in mailbox */
	int OldMsgs;
	int OldUnreadMsgs;
	int blink_stat;				/* blink digits flag-counter */

	union {
		struct {
			time_t ctime;
			time_t mtime;
			size_t size;
		} mbox;
		struct {
			time_t ctime_new;
			time_t mtime_new;
			size_t size_new;
			time_t ctime_cur;
			time_t mtime_cur;
			size_t size_cur;
		} maildir;
		struct {
			char password[32];
			char userName[32];
			char serverName[256];
			int serverPort;
			int localPort;
		} pop;
	} u;

	FILE *(*open) (Pop3);
	int (*checkMail) (Pop3);

	time_t prevtime;
	time_t prevfetch_time;
	int loopinterval;			/* loop interval for this mailbox */
} mbox_t;

#define BUF_SIZE	1024
char buf[BUF_SIZE];

int sock_connect(char *hostname, int port);
FILE *openMailbox(Pop3 pc);

#undef DEBUG_POP3
int pop3Create(Pop3 pc, char *str);
#undef DEBUG_IMAP4
int imap4Create(Pop3 pc, char *str);
#undef DEBUG_LICQ
int licqCreate(Pop3 pc, char *str);
#undef DEBUG_MBOX
int mboxCreate(Pop3 pc, char *str);
#undef DEBUG_MAILDIR
int maildirCreate(Pop3 pc, char *str);

#undef DEBUG
#undef DEBUG_MAIL_COUNT

#endif
/* vim:set ts=4: */
