/*
 *
 *  	wmMand-1.0 (C) 1999 Mike Henderson (mghenderson@lanl.gov)
 * 
 *  		- Mandelbrot explorer
 * 
 * 
 * 
 *
 * 	This program is free software; you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation; either version 2, or (at your option)
 * 	any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program (see the file COPYING); if not, write to the
 * 	Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *      Boston, MA  02111-1307, USA
 *
 *
 *	ToDo:
 *	      -	Activate Julia-set map button. Currently it does nothing.
 *	      -	Colors on 8-bit displays are not yet working properly.
 *
 *
 *
 *
 *	Version 1.0   - initial release Feb. 15, 1999.
 *
 *
 */





/*  
 *   Includes  
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <X11/X.h>
#include <X11/xpm.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "../wmgeneral/wmgeneral.h"
#include "Rainbow1.h"
#include "Rainbow2.h"
#include "PurpleWhite.h"
#include "BlueYellowRed.h"
#include "wmMand_master.xpm"
#include "wmMand_mask.xbm"


typedef struct {

    Display		*display;
    int			 screen;
    Visual		*visual;
    int			 depth;
    Colormap		 cmap;
    int			 format;
    int			 bitmap_pad;
    int			 Color[256];
    unsigned char	 RRR[256];
    unsigned char	 GGG[256];
    unsigned char	 BBB[256];

} DisplayInfo;



/* 
 *  Delay between refreshes (in microseconds) 
 */
#define DELAY 10000L
#define WMMAND_VERSION "1.0"





void ParseCMDLine(int argc, char *argv[]);
void ButtonPressEvent(XButtonEvent *xev, DisplayInfo *Info, unsigned char *Image, unsigned char *BigImage);
void KeyPressEvent(XKeyEvent *xev);
void ComputeImage();
void SetColorTable();

int		nIterList  = 5, iIter;
int		IterList[] = {64, 128, 256, 512, 1024};

int		ButtonsUp = 0;
int		ForceUpdate = 1;
int		ForceUpdate2 = 1;
int		GotFirstClick1, GotDoubleClick1;
int		GotFirstClick2, GotDoubleClick2;
int		GotFirstClick3, GotDoubleClick3;
int		DblClkDelay;
long int	UpdateDELAY = 600;
double		Range = 2.0;
double		ZOOM = 1.1, ZoomFactor;
double		Center_x = -0.5;
double		Center_y =  0.0;
int		ColorTable;
int		MaxIterations = 256;





/*  
 *   main  
 */
int main(int argc, char *argv[]) {

XImage		*xim;
XEvent		event;
int		i, j;
int		n, s, m, dt1, dt2, dt3;
int		Flag = 1;
unsigned char	*Image, *BigImage;
DisplayInfo	Info;











	  
    /*
     *  Parse any command line arguments.
     */
    ParseCMDLine(argc, argv);
	   

    /*
     *  Open window
     */
    openXwindow(argc, argv, wmMand_master, wmMand_mask_bits, wmMand_mask_width, wmMand_mask_height);




    /*
     *  Get Display parameters
     */
    Info.display = display;
    Info.screen  = DefaultScreen(display);
    Info.visual  = DefaultVisual(display, Info.screen);
    Info.depth   = DefaultDepth(display, Info.screen);
    Info.cmap    = DefaultColormap(display, 0);





    /*
     *   Initialize Color Table
     */
    ColorTable = 3;
    SetColorTable(&Info, ColorTable);






    xim = XCreateImage(Info.display, Info.visual, Info.depth, Info.format, 0, (char *)0, 54, 54, Info.bitmap_pad, 0);
    xim->data = (char *)malloc(xim->bytes_per_line * 54 );





    /*
     *   Allocate memory for image data
     */
    Image    = (unsigned char *)malloc(sizeof(unsigned char)*54*54);
    BigImage = (unsigned char *)malloc(sizeof(unsigned char)*540*540);






	   
    /*
     *  Loop until we die
     */
    n = 32000;
    s = 32000;
    m = 32000;
    dt1 = 32000;
    dt2 = 32000;
    dt3 = 32000;
    DblClkDelay = 32000;
    ZoomFactor = 1.0/ZOOM;
    MaxIterations = IterList[iIter];
    while(1) {




	/*
	 *  Keep track of # of seconds
	 */
	if (m > 100){
	
	    m = 0;
	    ++dt1;
	    ++dt2;
	    ++dt3;
	
	} else {
	
	    /*
	     *  Increment counter
	     */
	    ++m;
	
	}






	/*
	 *  Double Click Delays
	 *  Keep track of click events. If Delay too long, set GotFirstClick's to False.
	 */
	if (DblClkDelay > 15) { 

	    DblClkDelay = 0; 
	    GotFirstClick1 = 0; GotDoubleClick1 = 0; 
	    GotFirstClick2 = 0; GotDoubleClick2 = 0; 
	    GotFirstClick3 = 0; GotDoubleClick3 = 0; 

	} else {

	    ++DblClkDelay;

	}














	/* 
	 *   Process any pending X events.
	 */
        while(XPending(display)){
            XNextEvent(display, &event);
            switch(event.type){
                case Expose:
                        RedrawWindow();
                        break;
                case ButtonPress:
                        ButtonPressEvent(&event.xbutton, &Info, Image, BigImage);
                        break;
                case KeyPress:
                        KeyPressEvent(&event.xkey);
                        break;
                case ButtonRelease:
                        break;
                case EnterNotify:
			XSetInputFocus(display, iconwin, RevertToNone, CurrentTime);
			if (Info.depth == 8) XInstallColormap(display, Info.cmap);
                        break;
                case LeaveNotify:
			XSetInputFocus(display, None, RevertToNone, CurrentTime);
			if (Info.depth == 8) XUninstallColormap(display, Info.cmap);
                        break;
            }
        }





	/*
	 *  Cokmpute initial image
	 */
	if (Flag) {
	    ComputeImage(Center_x, Center_y, 54, 54, 2.0, Image);
	    Flag = 0;
	    ForceUpdate = 1;
	}
	




	


	/*
	 *  Draw window.
	 */
	if (ForceUpdate){
	    



	    /*
	     * Clear window.
	     */
	    copyXPMArea(70, 70, 54, 54, 5, 5);





	    /*
	     *   Paste up image.
	     */
	    for ( i=0; i<54; ++i ) {
		for ( j=0; j<54; ++j ) {
		    XPutPixel(xim, i, j,  Info.Color[*(Image + j*54 + i)]);
		    XFlush(display);
		}
	    }
	    XPutImage(display, wmgen.pixmap, NormalGC, xim, 0, 0, 5, 5, 54, 54);




	    /*
	     *   Paste up buttons if ButonsUp is toggled.
	     */
	    if (ButtonsUp) {

		copyXPMArea(5, 69, 54, 10, 5, 49);

		switch(MaxIterations){
			case 64:
				copyXPMArea(75, 69, 9, 6, 19, 51);
				break;
			case 128:
				copyXPMArea(71, 77, 13, 6, 17, 51);
				break;
			case 256:
				copyXPMArea(70, 85, 14, 6, 17, 51);
				break;
			case 512:
				copyXPMArea(71, 93, 13, 6, 17, 51);
				break;
			case 1024:
				copyXPMArea(67, 101, 17, 6, 15, 51);
				break;
		}


	    }
   





	    /*
	     * Make changes visible
	     */
	    RedrawWindow();



	}




	/*
	 *  Clear ForceUpdate Flag
	 */
	ForceUpdate = 0;




	/* 
	 *  Wait for next update 
	 */
	usleep(DELAY);


    }

    free(xim->data);
    XDestroyImage(xim);


}



/*
 *   ParseCMDLine()
 */
void ParseCMDLine(int argc, char *argv[]) {

    int  i;
 
    for (i = 1; i < argc; i++) {

        if (!strcmp(argv[i], "-display")){

            ++i;

        } else if (!strcmp(argv[i], "-zoom")){

            ZOOM = atof(argv[++i]);

        } else {
            printf("\nwmMand version: %s\n", WMMAND_VERSION);
            printf("\nusage: wmMand -display <Display> [-zoom <factor>] [-h]\n\n");
            printf("\t-display <Display>\t\tUse alternate X display.\n");
            printf("\t-zoom <factor>\t\tSet Zoom factor. Default is 1.1\n");
            printf("\t-h\t\t\t\tDisplay help screen.\n");
            exit(1);
        }
    }

}



/*
 *  This routine handles key presses. 
 *
 */
void KeyPressEvent(XKeyEvent *xev){

    ButtonsUp = !ButtonsUp;
    ForceUpdate = 1;

}





/*
 *  This routine handles button presses. 
 *
 *	- Left   Mouse single click: make cursor position the new image center an zooms in
 *	- Right  Mouse single click: make cursor position the new image center an zooms out
 *	- Middle Mouse single click: zooms in or out relative to center of image. (Zoom in if Left
 * 	                             mouse pressed prior, out if right mouse pressed prior).
 *
 *
 */
void ButtonPressEvent(XButtonEvent *xev, DisplayInfo *Info, unsigned char *Image, unsigned char *BigImage){

    int		x, y, WriteGIF();
    double	X, Y;
    FILE	*fp_gif;

    if (ButtonsUp && ((xev->x > 4)&&(xev->x < 59)&&(xev->y > 48)&&(xev->y < 59)) ){

	if ((xev->x >= 5)&&(xev->x <= 12)){

	    ++ColorTable; if (ColorTable > 3) ColorTable = 0;
	    SetColorTable(Info, ColorTable);

	} else if ((xev->x >= 13)&&(xev->x <= 33)){

	    ++iIter; if (iIter >= nIterList) iIter = 0;
	    MaxIterations = IterList[iIter];
            ComputeImage(Center_x, Center_y, 54, 54, Range, Image);
            ForceUpdate = 1;

	} else if ((xev->x >= 34)&&(xev->x <= 41)){
	} else if ((xev->x >= 42)&&(xev->x <= 49)){

	    Center_x = -0.5;
	    Center_y =  0.0;
	    Range = 2.0;
            ComputeImage(Center_x, Center_y, 54, 54, Range, Image);
            ForceUpdate = 1;

	} else if ((xev->x >= 50)&&(xev->x <= 58)){

            ComputeImage(Center_x, Center_y, 540, 540, Range, BigImage);
	    fp_gif = fopen("/tmp/wmMand.gif", "w");
	    WriteGIF(fp_gif, BigImage, 0, 540, 540, Info->RRR, Info->GGG, Info->BBB, 256, 0, "");
	    fclose(fp_gif);
	    system("xv /tmp/wmMand.gif &");


	}


        ForceUpdate = 1;
	return;

    } else if ((xev->x > 5)&&(xev->x < 60)&&(xev->y > 5)&&(xev->y < 59)){
        x = xev->x - 6;
	y = xev->y - 6;
    } else {
	return;
    }


    DblClkDelay = 0;
    if ((xev->button == Button1) && (xev->type == ButtonPress)){

	if (GotFirstClick1) GotDoubleClick1 = 1;
	else GotFirstClick1 = 1;


	/*
	 *   compute the physical (X, Y) values of the point defined by the image (x, y)
	 */
	ZoomFactor = 1.0/ZOOM;
	Range *= ZoomFactor;
	X = Range * ((double)x-27.0)/27.0 + Center_x;
	Y = Range * ((double)y-27.0)/27.0 + Center_y;
	Center_x = X;
	Center_y = Y;


	/*
	 *   Compute the Mandelbrot Image...
	 */
	ComputeImage(X, Y, 54, 54, Range, Image);
        ForceUpdate = 1;


    } else if ((xev->button == Button2) && (xev->type == ButtonPress)){ 

	if (GotFirstClick2) GotDoubleClick2 = 1;
	else GotFirstClick2 = 1;

	/*
	 *   compute the physical (X, Y) values of the point defined by the image (x, y)
	 */
	Range *= ZoomFactor;
	x = 27;
	y = 27;
	X = Range * ((double)x-27.0)/27.0 + Center_x;
	Y = Range * ((double)y-27.0)/27.0 + Center_y;
	Center_x = X;
	Center_y = Y;


	/*
	 *   Compute the Mandelbrot Image...
	 */
	ComputeImage(X, Y, 54, 54, Range, Image);
        ForceUpdate = 1;

    } else if ((xev->button == Button3) && (xev->type == ButtonPress)){

	if (GotFirstClick3) GotDoubleClick3 = 1;
	else GotFirstClick3 = 1;


	/*
	 *   compute the physical (X, Y) values of the point defined by the image (x, y)
	 */
	ZoomFactor = ZOOM;
	Range *= ZOOM;
	X = Range * ((double)x-27.0)/27.0 + Center_x;
	Y = Range * ((double)y-27.0)/27.0 + Center_y;
	Center_x = X;
	Center_y = Y;


	/*
	 *   Compute the Mandelbrot Image...
	 */
	ComputeImage(X, Y, 54, 54, Range, Image);
        ForceUpdate = 1;

    }


    /*
     *  We got a double click on Mouse Button1 (i.e. the left one)
     */
    if (GotDoubleClick1) {
	GotFirstClick1 = 0;
	GotDoubleClick1 = 0;


    }


    /*
     *  We got a double click on Mouse Button2 (i.e. the left one)
     */
    if (GotDoubleClick2) {
	GotFirstClick2 = 0;
	GotDoubleClick2 = 0;
    }


    /*
     *  We got a double click on Mouse Button3 (i.e. the left one)
     */
    if (GotDoubleClick3) {
	GotFirstClick3 = 0;
	GotDoubleClick3 = 0;
	ForceUpdate2 = 1;
    }



   return;

}










/*
 *   This routine computes the Mandelbrot fractal Image center on (Image_x, Image_y).
 *   of the current Image. 
 */

#define FALSE 0
#define TRUE  1

void ComputeImage(double X, double Y, int Width, int Height, double Range, unsigned char *Image){

int 		IntImage[540][540];
int		i, j, done, n, nmin, nmax;
int		ncount, count, hist[1024], cutoff;
double		f, re, im;
double		a, b, d, a2, b2;
double		nrange, uval, HalfWidth, HalfHeight;



    /*
     *  Initialize hist[]
     */
    for (i=0; i<MaxIterations; ++i) hist[i] = 0;

	
    /* 
     *  compute the (integer) map first 
     */
    nmin = 9999, nmax = -9999, ncount = 0;
    HalfWidth = Width/2.0;
    HalfHeight = Height/2.0;
    f = Range/HalfWidth;
    for (i=0; i<Width; ++i){

        re = f * ((double)i-HalfWidth) + X;
        for (j=0; j<Height; ++j){

            im = f * ((double)j-HalfHeight) + Y;
            n = 0; a = b = 0.0;
            a2 = 0.0; b2 = 0.0;

            while ((n < MaxIterations)&&((a2 + b2) < 4.0)){
                d = a;
                a = a2 - b2 + re;
                b = 2.0*d*b + im;
    
                a2 = a*a; b2 = b*b;
                ++n;
            }

            if (n > nmax) nmax = n;
            if (n < nmin) nmin = n;
            if (n >= MaxIterations){
                IntImage[j][i] = 0;
            } else{
                IntImage[j][i] = n;
                ++ncount;
            }
            ++hist[IntImage[j][i]];

        }

    }


    /*   Figure out what nmax should be. The problem is that you might only get
     *   one or two points in the upper half of the given range. A quick and dirty
     *   method is to find out at what n the f(n) starts to just become outliers.
     *   define outliers as mostly zeros. e.g. say more than 50% zero in a stretch
     *   that is 10 contiguous values long. Or you could count backwards until you
     *   get to the 99.5% level and call that the cutoff. 
     */
    i = nmax-1, done = FALSE, count = 0, cutoff = 0;
    while((i > 0)&&(done == FALSE)){

        count += hist[i];
        if ((double)count/(double)ncount >= 0.025){
            done = TRUE;
            cutoff = i;
        }
        --i;

    }
    /*
    printf("cutoff = %d\n", cutoff);
    */

	
    /* 
     *   Then map the integer map (IntImage) into a byte map (i.e. with 256 colours) 
     */
    uval = 0, nrange = (double)(cutoff-nmin)+1.0;
    for (i=0; i<Width; ++i){
        for (j=0; j<Height; ++j){
            n = IntImage[j][i];
            if (n == 0){

                uval = 0;

            } else if (n >= cutoff){

                uval = 255;

            } else if (n != 0){

                /* 
                 *  make sure roundoff doesnt put index to 0. Otherwise it'll
                 *  look like its in the set! 
                 */
                uval = (unsigned char)(((double)(n-nmin)+1.0)/nrange * 255.);

            }



            *(Image + Height*j + i) =  uval;


        }
    }





}


void SetColorTable(DisplayInfo *Info, int TableNumber){

XColor		xColor, xColors[256];
int		i;

    switch(TableNumber){
	case 0:
		for (i=0; i<256; ++i){
		    Info->RRR[i] = Rainbow2_Red[i];
		    Info->GGG[i] = Rainbow2_Grn[i];
		    Info->BBB[i] = Rainbow2_Blu[i];
		}
		break;
	case 1:
		for (i=0; i<256; ++i){
		    Info->RRR[i] = Rainbow1_Red[i];
		    Info->GGG[i] = Rainbow1_Grn[i];
		    Info->BBB[i] = Rainbow1_Blu[i];
		}
		break;
	case 2:
		for (i=0; i<256; ++i){
		    Info->RRR[i] = PurpleWhite_Red[i];
		    Info->GGG[i] = PurpleWhite_Grn[i];
		    Info->BBB[i] = PurpleWhite_Blu[i];
		}
		break;
	case 3:
		for (i=0; i<256; ++i){
		    Info->RRR[i] = BlueYellowRed_Red[i];
		    Info->GGG[i] = BlueYellowRed_Grn[i];
		    Info->BBB[i] = BlueYellowRed_Blu[i];
		}
		break;
		
    }



    /*
     *   Create an XImage with null data. Then allocate space for data. 
     */
    Info->format = ZPixmap;
    if (Info->depth == 8){

        Info->bitmap_pad = 8;
        /*
         *   Set a private colormap
         */
	Info->cmap = XCreateColormap(Info->display, RootWindow(Info->display, Info->screen), Info->visual, AllocAll);
        for (i=0; i<256; ++i){
	    Info->Color[i] = i;
	    xColors[i].pixel = i;
	    xColors[i].red   = (unsigned short)Info->RRR[i] << 8;
	    xColors[i].green = (unsigned short)Info->GGG[i] << 8;
	    xColors[i].blue  = (unsigned short)Info->BBB[i] << 8;
	    xColors[i].flags = DoRed | DoGreen | DoBlue;
        }
	XStoreColors(Info->display, Info->cmap, xColors, 256);
	XSetWindowColormap(Info->display, win, Info->cmap);

    } else if (Info->depth > 8) {

        /*
         *   Allocate Colors
         */
        for (i=0; i<256; ++i){
	    xColor.red   = (unsigned short)Info->RRR[i] << 8;
	    xColor.green = (unsigned short)Info->GGG[i] << 8;
	    xColor.blue  = (unsigned short)Info->BBB[i] << 8;
	    xColor.flags = DoRed | DoGreen | DoBlue;
	    XAllocColor(Info->display, Info->cmap, &xColor);
	    Info->Color[i] = xColor.pixel;
        }
        Info->bitmap_pad = 32;

    } else {

	fprintf(stderr, "wmMand: Need at least 8-bit display!\n");
	exit(-1);

    }



}

