#!/usr/local/bin/perl

require './webmin-lib.pl';

opendir(DIR, "..");
foreach $d (readdir(DIR)) {
	local %minfo;
	if (%minfo = &get_module_info($d)) {
		if (!&check_os_support(\%minfo)) {
			# This OS is not supported!
			next;
			}
		push(@modules, \%minfo);
		}
	}
closedir(DIR);
@modules = sort { $a->{'desc'} cmp $b->{'desc'} } @modules;

&header("Reassign Modules", undef);
print qq(
<hr><form action="save_assignment.cgi">
<table border><tr $tb>
<td>Module category assignments</td></tr>
<tr $cb><td><table>
);
foreach ( @modules ){
    $a++;
    print "<tr></tr>" if $a%2;
    print qq(<td>$_->{desc}</td><td>), &cats($_->{dir}, $_->{category}), "</td>\n";
}

print qq(
</td></tr></table>
</td></tr></table>
<p>
<input type=submit value="$text{save}">
</form><hr>
);
&footer("/", $text{'index'});

sub cats {
    my $cats;
    foreach ( sort { $text{$a} cmp $text{$b} } keys %text ){
	next unless /^category_/;
	my $desc = $text{$_};
	s/^category_//;
	$cats .= qq(\n<option value="$_") .
	    ($_[1] eq $_ ? ' SELECTED' : '' ) . ">$desc";
    }
    $cats = qq(<select name="$_[0]">$cats\n</select>\n);
}
