#!/usr/local/bin/perl
# edit_icp.cgi
# A form for editing options for communication with other caches

require './squid-lib.pl';
&header($text{'eicp_header'}, "", "edit_icp", 0, 0, 0, &restart_button());
$conf = &get_config();
$cache_host = $squid_version >= 2 ? "cache_peer" : "cache_host";

print "<hr><p>\n";
@ch = &find_config($cache_host, $conf);
if (@ch) {
	print "<h3>$text{'eicp_opcs'}</h3>\n";
	$mid = int((@ch+1)/2);
	print "<table width=100%><tr> <td width=50% valign=top>\n";
	&cache_table(0, $mid-1);
	print "</td><td width=50% valign=top>\n";
	if ($mid < @ch) { &cache_table($mid, $#ch); }
	print "</td> </tr></table>\n";
	}
else { print "<b>$text{'eicp_nocd'}</b>.<p>\n"; }
print "<a href=\"edit_cache_host.cgi?new=1\">$text{'eicp_aac'}</a><p>\n";

print "<hr>\n";
print "<form action=save_icp.cgi>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'eicp_cso'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

if ($squid_version < 2) {
	print "<tr>\n";
	print &list_input($text{'eicp_fdfd'}, "local_domain", $conf);
	print &address_input($text{'eicp_fdfi'}, "local_ip", $conf);
	print "</tr>\n";

	print "<tr>\n";
	print &list_input($text{'eicp_dif'}, "inside_firewall", $conf);
	print &address_input($text{'eicp_iif'}, "firewall_ip", $conf);
	print "</tr>\n";
	}

print "<tr>\n";
print &list_input($text{'eicp_dfuc'}, "hierarchy_stoplist",
		  $conf, 1, $text{'default'});
print "</tr>\n";

if ($squid_version < 2) {
	print "<tr>\n";
	print &choice_input($text{'eicp_bpfsp'},
			    "single_parent_bypass",
			    $conf, "off", $text{'yes'}, "on", $text{'no'}, "off");
	print &choice_input($text{'eicp_ssip'}, "source_ping", $conf, "off",
			    $text{'yes'}, "on", $text{'no'}, "off");
	print "</tr>\n";

	print "<tr>\n";
	print &opt_input($text{'eicp_crt'}, "neighbor_timeout", $conf,
			 $text{'default'}, 4, $text{'eicp_secs'});
	print "</tr>\n";
	}
else {
	print "<tr>\n";
	print &opt_input($text{'eicp_iqt'}, "icp_query_timeout", $conf,
			 $text{'default'}, 8, "ms");
	print &opt_input($text{'eicp_mit'}, "mcast_icp_query_timeout",
			 $conf, $text{'default'}, 8, "ms");
	print "</tr>\n";

	print "<tr>\n";
	print &opt_input($text{'eicp_dpt'}, "dead_peer_timeout", $conf,
			 $text{'default'}, 8, $text{'eicp_secs'});
	print "</tr>\n";
	}

print "</table></td></tr></table><br>\n";
print "<input type=submit value=$text{'buttsave'}></form>\n";

print "<hr>\n";
&footer("", $text{'eicp_return'});

# cache_table(start, end)
sub cache_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>Hostname</b></td> <td><b>Type</b></td>\n";
print "<td><b>Proxy port</b></td> <td><b>ICP port</b></td> </tr>\n";
for($i=$_[0]; $i<=$_[1]; $i++) {
	@chv = @{$ch[$i]->{'values'}};
	print "<tr $cb>\n";
	print "<td><a href=\"edit_cache_host.cgi?num=$i\">$chv[0]</a></td>\n";
	print "<td>$chv[1]</td>\n";
	print "<td>$chv[2]</td>\n";
	print "<td>$chv[3]</td>\n";
	print "</tr>\n";
	}
print "</table>\n";
}

