#!/usr/local/bin/perl
# save_masq.cgi
# Save domain masquerading

require './sendmail-lib.pl';
&ReadParse();
$access{'masq'} || &error($text{'masq_ecannot'});
&error_setup($text{'masq_err'});
&lock_file($config{'sendmail_cf'});
$conf = &get_sendmailcf();
$in{'masq'} =~ /^[A-z0-9\-\.]*$/ ||
	&error(&text('masq_edomain', $in{'masq'}));
@mlist = split(/\s+/, $in{'mlist'});
foreach $m (@mlist) {
	$m =~ /^[A-z0-9\-\.]+$/ ||
		&error(&text('masq_ehost', $m));
	&check_ipaddress($m) &&
		&error(&text('masq_eip', $m));
	}
@mlist = &unique(@mlist);

# Update the DM directive (if there is one)
foreach $d (&find_type("D", $conf)) {
	if ($d->{'value'} =~ /^M/) { push(@dmconf, $d); }
	}
&save_directives($conf, \@dmconf,
		 [ { 'type' => 'D', 'values' => [ "M$in{'masq'}" ] } ]);

# Get old CM directives
@old = grep { $_->{'value'} =~ /^M/ } &find_type("C", $conf);

if ($in{'cmfile'}) {
	# If there is a cm file, write all domains to it and take any
	# out of sendmail.cf
	&lock_file($in{'cmfile'});
	open(CM, "> $in{'cmfile'}");
	foreach $m (@mlist) { print CM $m,"\n"; }
	close(CM);
	&unlock_file($in{'cmfile'});
	}
else {
	# Put all domains in sendmail.cf
	foreach $m (@mlist) {
		push(@new, { 'type' => 'C',
			     'values' => [ "M$m" ] });
		}
	}
&save_directives($conf, \@old, \@new);
&flush_file_lines();
&unlock_file($config{'sendmail_cf'});
&restart_sendmail();
&webmin_log("masq");
&redirect("");

