#!/usr/local/bin/perl
# save_cws.cgi
# Save sendmail.cw list

require './sendmail-lib.pl';
&ReadParse();
$access{'cws'} || &error($text{'cws_ecannot'});
&error_setup($text{'cws_err'});
&lock_file($config{'sendmail_cf'});
$conf = &get_sendmailcf();
@dlist = split(/\s+/, $in{'dlist'});
foreach $d (@dlist) {
	$d =~ /^[A-z0-9\-\.]+$/ ||
		&error(&text('cws_ehost', $d));
	&check_ipaddress($d) &&
		&error(&text('cws_eip', $d));
	}
@dlist = &unique(@dlist);

# get old cw directives
@old = grep { $_->{'value'} =~ /^w/ } &find_type("C", $conf);

if ($in{'cwfile'}) {
	# If there is a .cw file, write all domains to it and take any
	# out of sendmail.cf
	&lock_file($in{'cwfile'});
	open(CW, "> $in{'cwfile'}");
	foreach $d (@dlist) { print CW $d,"\n"; }
	close(CW);
	&unlock_file($in{'cwfile'});
	}
else {
	# Stick all domains in sendmail.cf
	foreach $d (@dlist) {
		push(@new, { 'type' => 'C',
			     'values' => [ "w$d" ] });
		}
	}
&save_directives($conf, \@old, \@new);
&flush_file_lines();
&unlock_file($config{'sendmail_cf'});
&restart_sendmail();
&webmin_log("cws");
&redirect("");

