#!/usr/local/bin/perl
# save_cgs.cgi
# Save sendmail.cg list

require './sendmail-lib.pl';
&ReadParse();
$access{'cgs'} || &error($text{'cgs_ecannot'});
&error_setup($text{'cgs_err'});
&lock_file($config{'sendmail_cf'});
$conf = &get_sendmailcf();
@dlist = split(/\s+/, $in{'dlist'});
foreach $d (@dlist) {
	$d =~ /^[A-z0-9\-\.]+$/ ||
		&error(&text('cgs_ehost', $d));
	&check_ipaddress($d) &&
		&error(&text('cgs_eip', $d));
	}
@dlist = &unique(@dlist);

# get old cw directives
@old = grep { $_->{'value'} =~ /^G/ } &find_type("C", $conf);

if ($in{'cgfile'}) {
	# If there is a .cg file, write all domains to it and take any
	# out of sendmail.cf
	&lock_file($in{'cgfile'});
	open(CG, "> $in{'cgfile'}");
	foreach $d (@dlist) { print CG $d,"\n"; }
	close(CG);
	&unlock_file($in{'cgfile'});
	}
else {
	# Stick all domains in sendmail.cf
	foreach $d (@dlist) {
		push(@new, { 'type' => 'C',
			     'values' => [ "G$d" ] });
		}
	}
&save_directives($conf, \@old, \@new);
&flush_file_lines();
&unlock_file($config{'sendmail_cf'});
&restart_sendmail();
&webmin_log("cgs");
&redirect("");

