#!/usr/local/bin/perl
# save_sec.cgi
# Save secuirty options for a share

require './samba-lib.pl';
$whatfailed = $text{'save_sec_0'};
&ReadParse();
&lock_file($config{'smb_conf'});
&get_share($in{old_name});

&delval("read only");
&setval("writable", $in{writable});
if ($in{guest} == 0) {
	&delval("public"); &delval("guest only");
	}
elsif ($in{guest} == 1) {
	&setval("public", "yes"); &delval("guest only");
	}
else {
	&setval("public", "yes"); &setval("guest only", "yes");
	}
&setval("valid users",
	join(',', split(/\s+/, $in{'valid_users_u'}),
		  map { '@'.$_ } split(/\s+/, $in{'valid_users_g'})));
&setval("invalid users",
	join(',', split(/\s+/, $in{'invalid_users_u'}),
		  map { '@'.$_ } split(/\s+/, $in{'invalid_users_g'})));
&setval("user",
	join(',', split(/\s+/, $in{'user_u'}),
		  map { '@'.$_ } split(/\s+/, $in{'user_g'})));
&setval("read list",
	join(',', split(/\s+/, $in{'read_list_u'}),
		  map { '@'.$_ } split(/\s+/, $in{'read_list_g'})));
&setval("write list",
	join(',', split(/\s+/, $in{'write_list_u'}),
		  map { '@'.$_ } split(/\s+/, $in{'write_list_g'})));
if (!$in{allow_hosts_all} && $in{allow_hosts} =~ /\S/) {
	&setval("allow hosts", $in{allow_hosts});
	}
else { &delval("allow hosts"); }
if (!$in{deny_hosts_all} && $in{deny_hosts} =~ /\S/) {
	&setval("deny hosts", $in{deny_hosts});
	}
else { &delval("deny hosts"); }
&setval("guest account", $in{guest_account});
&setval("only user", $in{only_user});
&setval("revalidate", $in{revalidate});

&modify_share($in{old_name}, $in{old_name});
&unlock_file($config{'smb_conf'});
&webmin_log("save", "sec", $in{old_name}, \%in);
if (&istrue("printable"))
	{ &redirect("edit_pshare.cgi?share=".&urlize($in{old_name})); }
else
	{ &redirect("edit_fshare.cgi?share=".&urlize($in{old_name})); }

