#!/usr/local/bin/perl
# save_pshare.cgi
# Save a new or edited printer share

require './samba-lib.pl';
$whatfailed = $text{'save_pshare_0'};
&ReadParse();
&lock_file($config{'smb_conf'});
if ($in{old_name}) {
	&get_share($in{old_name});
	}

if ($in{old_name} eq "global") {
	$name = "global";
	}
else {
	# store share options
	$name = $in{printers} ? "printers" : $in{"share"};
	}
#if ($in{"path"} !~ /\S/ && !$in{"printers"}) {
#	&error("No spool directory given");
#	}
&setval("printer", $in{"printer"});
&setval("path", $in{"path"});
&setval("available", $in{"available"});
&setval("browseable", $in{"browseable"});
if ($name ne "global") { &setval("printable", "yes"); }
&setval("comment", $in{"comment"});

# Check for clash
if ($name ne "global") {
	foreach (&list_shares()) {
	        $exists{$_}++;
	        }
	if (!$in{old_name} && $exists{$name}) {
	        &error(&text('save_pshare_1', $name));
	        }
	elsif ($in{old_name} ne $name && $exists{$name}) {
	        &error(&text('save_pshare_2', $name));
	        }
	elsif ($name !~ /^[A-z0-9_\$ ]+$/) {
		&error(&text('save_pshare_3', $name));
		}
	elsif ($name eq "global") {
		&error($text{'save_pshare_4'});
		}
	}

# Update config file
if ($in{old_name}) {
        # Changing an existing share
        &modify_share($in{old_name}, $name);
        }
else {
        # Creating a new share
        &create_share($name);
        }
&unlock_file($config{'smb_conf'});
&webmin_log($in{old_name} ? "save" : "create", "pshare", $name, \%in);
&redirect("");

