#!/usr/local/bin/perl
# save_fshare.cgi
# Save a new or edited file share

require './samba-lib.pl';
$whatfailed = $text{'savefshare_0'};
&ReadParse();
&lock_file($config{'smb_conf'});
if ($in{old_name}) {
	&get_share($in{old_name});
	}

# store share options
if ($in{old_name} eq "global") {
	$name = "global";
	}
else {
	$name = $in{"homes"} ? "homes" : $in{"share"};
	if ($in{"path"} !~ /\S/ && !$in{"homes"}) {
		&error($text{'savefshare_1'});
		}
	}
&setval("path", $in{"path"});
&setval("available", $in{"available"});
&setval("browseable", $in{"browseable"});
&setval("comment", $in{"comment"});

# Check for clash
if ($name ne "global") {
	foreach (&list_shares()) {
		$exists{$_}++;
		}
	if (!$in{old_name} && $exists{$name}) {
		&error(&text('savefshare_2', $name));
		}
	elsif ($in{old_name} ne $name && $exists{$name}) {
		&error(&text('savefshare_3', $name));
		}
	elsif ($name !~ /^[A-z0-9_\$ ]+$/) {
		&error(&text('savefshare_4', $name));
		}
	elsif ($name eq "global") {
		&error($text{'savefshare_5'});
		}
	}

# Update config file
if ($in{old_name}) {
	# Changing an existing share
	&modify_share($in{old_name}, $name);
	}
else {
	# Creating a new share
	&create_share($name);
	}
&unlock_file($config{'smb_conf'});
&webmin_log($in{old_name} ? "save" : "create", "fshare", $name, \%in);
&redirect("");

