#!/usr/local/bin/perl
# restart.cgi
# Kill all smbd and nmdb processes and re-start them

require './samba-lib.pl';

if ($config{'stop_cmd'}) {
	&system_logged("$config{'stop_cmd'} >/dev/null 2>&1 </dev/null");
	}
else {
	@smbpids = &find_byname("smbd");
	@nmbpids = &find_byname("nmbd");
	&kill_logged('TERM', @smbpids, @nmbpids);
	}

if ($config{'start_cmd'}) {
	$rv = &system_logged("$config{'start_cmd'} >/dev/null 2>&1 </dev/null");
	if ($rv) { &error(&text('start_1', $config{'start_cmd'})); }
	}
else {
	$rv = &system_logged("$config{samba_server} </dev/null");
	if ($rv) { &error(&text('restart_failed', $config{samba_server})); }
	$rv = &system_logged("$config{name_server} </dev/null");
	if ($rv) { &error(&text('restart_failed', $config{samba_server})); }
	}
&webmin_log("apply");
&redirect("");

