#!/usr/local/bin/perl
# index.cgi
# Display a list of available samba shares. Special shares (like [homes] and
# [printers]) are included as well.

require './samba-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";

if (!-x $config{'samba_server'}) {
	print &text('error_nosamba', $config{'samba_server'}, "/config.cgi?$module_name");
	print "<p>\n<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Check the samba version
if (`$config{'samba_server'} -v 2>&1` =~ /(Version|Samba)\s+(\d+)\.(\S+)/i ||
    `$config{'samba_server'} -V 2>&1` =~ /(Version|Samba)\s+(\d+)\.(\S+)/i) {
	# Save version number
	$v1 = $2; $v2 = $3;
	$v2 =~ s/[^0-9]//g;
	$samba_version = "$v1.$v2";
	open(VERSION, ">$module_config_directory/version");
	print VERSION $samba_version,"\n";
	close(VERSION);
	}
else {
	print &text('error_version', $config{'samba_server'}, "/config.cgi?$module_name");
	print "<p>\n<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

@empty = &list_shares();
if (!@empty && (-r $config{alt_smb_conf})) {
	# Copy the sample smb.conf file to the real location
	# This is a hack for slackware
	`cp $config{alt_smb_conf} $config{smb_conf} 2>&1`;
	}
if (!(-r $config{smb_conf})) {
	print &text('error_config', $config{'samba_conf'}, "/config.cgi?$module_name");
	print "<p>\n<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

&get_share("global");
if (&getval("config") || &getval("include")) {
	print "$text{'error_include'}<p>\n<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

foreach $s (&list_shares()) {
	$us = "share=".&urlize($s);
	if ($s eq "global") { next; }
	if (!$donefirst) {
		print "<table width=100% border>\n";
		print "<tr $tb> <td><b>$text{'index_sharename'}</b></td> <td><b>$text{'index_path'}</b></td>\n";
		print "         <td><b>$text{'index_security'}</b></td> </tr>\n";
		$donefirst = 1;
		}
	&get_share($s);
	print "<tr $cb>\n";
	if ($cp = &getval("copy")) { $cp = "(copy of <i>$cp</i>)"; }
	if (&istrue("printable")) {
		print "<td><a href=\"edit_pshare.cgi?$us\">$s</a> $cp</td>\n";
		}
	else {
		print "<td><a href=\"edit_fshare.cgi?$us\">$s</a> $cp</td>\n";
		}

	# Output location / path info
	if ($s eq "homes") {
		$p = "<i>$text{'index_homedir'}</i>";
		}
	elsif ($s eq "printers") {
		$p = "<i>$text{'index_allprinter'}</i>";
		}
	elsif (&istrue("printable")) {
		$p = &getval("printer") ? $text{'index_printer'}." ".&getval("printer")
					: $text{'index_defaultprn'};
		}
	else {
		$p = &getval("path");
		}
	print "<td>$p</td>\n";

	# Output security information
	if (&istrue("printable")) {
		if (&getval("valid users")) {
			# Only accessible to some users..
			$sc = $text{'index_printableto'}." ".
				&user_list(&getval("valid users"));
			}
		elsif (&istrue("public")) {
			# Accessible to everyone
			$sc = $text{'index_prneveryone'};
			}
		else {
			$sc = $text{'index_prnalluser'};
			}
		}
	elsif (&istrue("writable")) {
		# Default is read/write access
		if (&istrue("public")) {
			# No password needed..
			$sc = $text{'index_rwpublic'};
			}
		else {
			# Password needed..
			if (&getval("read list")) {
				$sc = &text('index_readonly', &user_list(&getval("read list")));
				}
			else {
				$sc = $text{'index_rwalluser'};
				}
			}
		}
	else {
		# Default is read-only access
		if (&istrue("public")) {
			# No password needed..
			$sc = $text{'index_roeveryone'};
			}
		else {
			# Password needed..
			if (&getval("write list")) {
				$sc = &text('index_readwrite', &user_list(&getval("read list")));
				}
			else {
				$sc = $text{'index_roalluser'};
				}
			}
		}
	print "<td>$sc</td>\n";
	print "</tr>\n";
	}
if ($donefirst) { print "</table>\n"; }
else { print "<b>$text{'index_noshares'}</b>. <p>\n"; }
print "<a href=\"edit_fshare.cgi\">$text{'index_createfileshare'}</a>\n";
print "&nbsp;&nbsp;&nbsp;&nbsp;\n";
print "<a href=\"edit_pshare.cgi\">$text{'index_createprnshare'}</a>\n";
print "&nbsp;&nbsp;&nbsp;&nbsp;\n";
print "<a href=\"create_copy.cgi\">$text{'index_createcopy'}</a>\n";
print "&nbsp;&nbsp;&nbsp;&nbsp;\n";
print "<a href=\"view_users.cgi\">$text{'index_view'}</a><p>\n";

print "<hr>\n";
print "<h3>$text{'global_title'}</h3>\n";

@gc_progs = ("conf_net.cgi", "conf_smb.cgi", "conf_pass.cgi",
	     "conf_print.cgi", "conf_misc.cgi", "edit_fshare.cgi?share=global",
	     "edit_pshare.cgi?share=global");
@gc_names = ($text{'global_unixnetwork'}, $text{'global_winnetwork'},
	     $text{'global_auth'}, $text{'global_printing'},
	     $text{'global_misc'}, $text{'global_filedefault'},
	     $text{'global_prndefault'});
@gc_icons = ("images/icon_0.gif", "images/icon_1.gif", "images/icon_2.gif",
	     "images/icon_3.gif", "images/icon_4.gif", "images/icon_5.gif",
	     "images/icon_6.gif");
if (&has_command($config{'swat_path'})) {
	push(@gc_progs, "swat.cgi");
	push(@gc_names, "SWAT");
	push(@gc_icons, "images/icon_9.gif");
	}
&icons_table(\@gc_progs, \@gc_names, \@gc_icons);

&get_share("global");
if (&istrue("encrypt passwords") && $config{smb_passwd}) {
	# Encrypted passwords are on.. output links
	print "<hr>\n";
	print "<h3>$text{'global_prsswork'}</h3>\n";
	print "<ul>\n";
	print "<li> <a href=edit_epass.cgi>$text{'global_edit'}</a>. <p>\n";
	print "<li> <a href=ask_epass.cgi>$text{'global_convert'}</a>. <p>\n";
	print "<li> <a href=edit_sync.cgi>$text{'global_sync'}</a>. <p>\n";
	print "</ul>\n";
	}

&foreign_require("inetd", "inetd-lib.pl");
foreach $inet (&foreign_call("inetd", "list_inets")) {
	$found_inet++ if (($inet->[8] =~ /smbd/ || $inet->[9] =~ /smbd/) &&
			  $inet->[1]);
	}
@smbpids = &find_byname("smbd");
@nmbpids = &find_byname("nmbd");
if (!$found_inet && !@smbpids && !@nmbpids) {
	print "<hr>\n";
	print "<form action=start.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value=\"$text{'index_start'}\"></td>\n";
	print "<td>$text{'index_startmsg'}</td>\n";
	print "</tr></table></form>\n";
	}
elsif (!$found_inet) {
	print "<hr>\n";
	print "<form action=restart.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value=\"$text{'index_restart'}\"></td>\n";
	print "<td>$text{'index_restartmsg'}</td>\n";
	print "</tr></table></form>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

