#!/usr/local/bin/perl
# index.cgi
# Display all RAID devices

require './raid-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";

# Check if raid is installed
if (!-r $config{'mdstat'}) {
	print "<p><b>",&text('index_emdstat',
			     "<tt>$config{'mdstat'}</tt>"),"</b><p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
if (!&has_command('mkraid') || !&has_command('raidstart')) {
	print "<p><b>$text{'index_emkraid'}</b><p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Display configured raid devices
$conf = &get_raidtab();
if (@$conf) {
	foreach $c (@$conf) {
		$lvl = &find_value('raid-level', $c->{'members'});
		push(@titles, $c->{'value'});
		push(@images, $c->{'active'} ? "images/$lvl.gif"
					     : "images/$lvl.ia.gif");
		push(@links, "view_raid.cgi?idx=$c->{'index'}");
		}
	&icons_table(\@links, \@titles, \@images);
	}
else {
	print "<p><b>$text{'index_none'}</b><p>\n";
	}
print "<form action=raid_form.cgi>\n";
print "<input type=submit value='$text{'index_add'}'>\n";
print "<select name=level>\n";
print "<option value=linear>$text{'linear'}\n";
print "<option value=0>$text{'raid0'}\n";
print "<option value=1>$text{'raid1'}\n";
print "<option value=4>$text{'raid4'}\n";
print "<option value=5>$text{'raid5'}\n";
print "</select></form>\n";

print "<hr>\n";
&footer("/", $text{'index'});

