#!/usr/local/bin/perl
# save_dns.cgi
# Save DNS client configuration

require './net-lib.pl';
$whatfailed = "Failed to save DNS configuration";
&ReadParse();

$in{'hostname'} =~ /^[A-z0-9\.\-]*$/ ||
	&error("'$in{'hostname'}' is not a valid hostname");
$dns = { };
for($i=0; $i<$max_dns_servers; $i++) {
	$ns = $in{"nameserver_$i"};
	if ($ns) {
		&check_ipaddress($ns) ||
			&error("'$ns' is not a valid nameserver IP address");
		push(@{$dns->{'nameserver'}}, $ns);
		}
	}
if (!$in{'domain_def'}) {
	@dlist = split(/\s+/, $in{'domain'});
	foreach $d (@dlist) {
		$d =~ /^[A-z0-9\.\-]+$/ ||
			&error("'$d' is not a valid domain name");
		push(@{$dns->{'domain'}}, $d);
		}
	@dlist>0 || &error("No domains to search given");
	}
&parse_order($dns);
&save_dns_config($dns);
&save_hostname($in{'hostname'});
&webmin_log("dns", undef, undef, \%in);
&redirect("");

