#!/usr/local/bin/perl
# save_aifc.cgi
# Save, create or delete an active interface

require './net-lib.pl';
&ReadParse();
@acts = &active_interfaces();
if ($in{'delete'}) {
	# delete an interface
	&error_setup($text{'aifc_err1'});
	$a = $acts[$in{'idx'}];
	&deactivate_interface($a);
	&webmin_log("delete", "aifc", $a->{'fullname'}, $a);
	}
else {
	# Validate and save inputs
	&error_setup($text{'aifc_err2'});
	if (!$in{'new'}) {
		$olda = $acts[$in{'idx'}];
		$a->{'name'} = $olda->{'name'};
		$a->{'virtual'} = $olda->{'virtual'}
			if (defined($olda->{'virtual'}));
		}
	elsif (defined($in{'virtual'})) {
		# creating a virtual interface
		$in{'virtual'} =~ /^\d+$/ ||
			&error($text{'aifc_evirt'});
		foreach $ea (@acts) {
			if ($ea->{'name'} eq $in{'name'} &&
			    $ea->{'virtual'} eq $in{'virtual'}) {
				&error(&text('aifc_evirtdup',
				       "$in{'name'}:$in{'virtual'}"));
				}
			}
		$a->{'name'} = $in{'name'};
		$a->{'virtual'} = $in{'virtual'};
		}
	elsif ($in{'name'} =~ /^([a-z0-9]+):(\d+)$/) {
		# also creating a virtual interface
		foreach $ea (@acts) {
			if ($ea->{'name'} eq $1 &&
			    $ea->{'virtual'} eq $2) {
				&error(&text('aifc_evirtdup', $in{'name'}));
				}
			}
		$a->{'name'} = $1;
		$a->{'virtual'} = $2;
		}
	elsif ($in{'name'} =~ /^[a-z0-9]+$/) {
		# creating a real interface
		foreach $ea (@acts) {
			if ($ea->{'name'} eq $in{'name'}) {
				&error(&text('aifc_edup', $in{'name'}));
				}
			}
		$a->{'name'} = $in{'name'};
		}
	else {
		&error($text{'aifc_ename'});
		}
	&check_ipaddress($in{'address'}) ||
		&error(&text('aifc_eip', $in{'address'}));
	$a->{'address'} = $in{'address'};
	if (!$in{'netmask_def'}) {
		&check_ipaddress($in{'netmask'}) ||
			&error(&text('aifc_emask', $in{'netmask'}));
		$a->{'netmask'} = $in{'netmask'};
		}
	if (!$in{'broadcast_def'}) {
		&check_ipaddress($in{'broadcast'}) ||
			&error(&text('aifc_ebroad', $in{'broadcast'}));
		$a->{'broadcast'} = $in{'broadcast'};
		}
	if (!$in{'mtu_def'}) {
		$in{'mtu'} =~ /^\d+$/ ||
			&error(&text('aifc_emtu', $in{'mtu'}));
		$a->{'mtu'} = $in{'mtu'} if ($olda->{'mtu'} ne $in{'mtu'});
		}
	if ($in{'up'}) { $a->{'up'}++; }
	if (!$in{'ether_def'} && $a->{'virtual'} eq "" &&
	    &iface_hardware($a->{'name'})) {
		$in{'ether'} =~ /^[A-Fa-f0-9:]+$/ ||
			&error(&text('aifc_ehard', $in{'ether'}));
		$a->{'ether'} = $in{'ether'}
			if ($olda->{'ether'} ne $in{'ether'});
		}
	$a->{'fullname'} = $a->{'name'}.
			   ($a->{'virtual'} eq '' ? '' : ':'.$a->{'virtual'});
	&activate_interface($a);
	&webmin_log($in{'new'} ? 'create' : 'modify',
		    "aifc", $a->{'fullname'}, $a);
	}
&redirect("list_ifcs.cgi");

