#!/usr/local/bin/perl
# view_data.cgi
# Display all data in some table

require './mysql-lib.pl';
&ReadParse();
&can_edit_db($in{'db'}) || &error($text{'dbase_ecannot'});
@str = &table_structure($in{'db'}, $in{'table'});
foreach $s (@str) {
	$keyed++ if ($s->{'key'} eq 'PRI');
	}

if ($in{'delete'}) {
	# Deleting selected rows
	$d = &execute_sql($in{'db'}, "select * from $in{'table'} limit ".
				     $in{'start'}.",".$config{'perpage'});
	@t = @{$d->{'titles'}};
	$count = 0;
	foreach $r (split(/\0/, $in{'row'})) {
		local @where;
		local @r = @{$d->{'data'}->[$r]};
		for($i=0; $i<@t; $i++) {
			if ($r[$i] eq 'NULL') {
				push(@where, "$t[$i] is null");
				}
			elsif ($r[$i] !~ /^(\d+)\.(\d+)/) {
				$r[$i] =~ s/'/''/g;
				push(@where, "$t[$i] = '$r[$i]'");
				}
			}
		&execute_sql_logged($in{'db'},
				    "delete from $in{'table'} where ".
				    join(" and ", @where));
		$count++;
		}
	&webmin_log("delete", "data", $count, \%in);
	&redirect("view_table.cgi?db=$in{'db'}&".
		  "table=$in{'table'}&start=$in{'start'}");
	}
elsif ($in{'save'}) {
	# Update edited rows
	$d = &execute_sql($in{'db'}, "select * from $in{'table'} limit ".
				     $in{'start'}.",".$config{'perpage'});
	@t = @{$d->{'titles'}};
	$count = 0;
	for($j=0; $j<$config{'perpage'}; $j++) {
		next if (!defined($in{"${j}_$t[0]"}));
		local (@where, @set);
		local @r = @{$d->{'data'}->[$j]};
		for($i=0; $i<@t; $i++) {
			$r[$i] =~ s/'/''/g;
			if ($r[$i] eq 'NULL') {
				push(@where, "$t[$i] is null");
				}
			elsif ($r[$i] !~ /^(\d+)\.(\d+)/) {
				push(@where, "$t[$i] = '$r[$i]'");
				}
			local $ij = $in{"${j}_$t[$i]"};
			$ij =~ s/'/''/g;
			if ($ij eq '') {
				push(@set, "$t[$i] = NULL");
				}
			else {
				push(@set, "$t[$i] = '$ij'");
				}
			}
		&execute_sql_logged($in{'db'}, "update $in{'table'} set ".
				    join(" , ", @set)." where ".
				    join(" and ", @where));
		$count++;
		}
	&webmin_log("modify", "data", $count, \%in);
	&redirect("view_table.cgi?db=$in{'db'}&".
		  "table=$in{'table'}&start=$in{'start'}");
	}
elsif ($in{'savenew'}) {
	# Adding a new row
	for($j=0; defined($in{$j}); $j++) {
		$in{$j} =~ s/'/''/g;
		push(@set, $in{$j} eq '' ? 'NULL' : "'$in{$j}'");
		}
	&execute_sql_logged($in{'db'}, "insert into $in{'table'} values (".
			    join(" , ", @set).")");
	&redirect("view_table.cgi?db=$in{'db'}&".
		  "table=$in{'table'}&start=$in{'start'}");
	&webmin_log("create", "data", undef, \%in);
	}
elsif ($in{'cancel'} || $in{'new'}) {
	undef($in{'row'});
	}

&header($text{'view_title'}, "");
print "<center><font size=+2>",&text('table_header', "<tt>$in{'table'}</tt>",
				     "<tt>$in{'db'}</tt>"),"</font></center>\n";
print "<hr><p>\n";

$d = &execute_sql($in{'db'}, "select count(*) from $in{'table'}");
$total = $d->{'data'}->[0]->[0];
$in{'start'} = int($in{'start'});
if ($in{'new'} && $total > $config{'perpage'}) {
	# go to the last screen for adding a row
	$in{'start'} = $total - $config{'perpage'};
	$in{'start'} = int(($in{'start'} / $config{'perpage'}) + 1) *
		       $config{'perpage'};
	}
if ($in{'start'} || $total > $config{'perpage'}) {
	print "<center>\n";
	if ($in{'start'}) {
		printf "<a href='view_table.cgi?db=%s&table=%s&start=%s'>".
		       "<img src=/images/left.gif border=0 align=middle></a>\n",
			$in{'db'}, $in{'table'},
			$in{'start'} - $config{'perpage'};
		}
	print "<font size=+1>",&text('view_pos', $in{'start'}+1,
	      $in{'start'}+$config{'perpage'} > $total ? $total :
	      $in{'start'}+$config{'perpage'}, $total),"</font>\n";
	if ($in{'start'}+$config{'perpage'} < $total) {
		printf "<a href='view_table.cgi?db=%s&table=%s&start=%s'>".
		      "<img src=/images/right.gif border=0 align=middle></a>\n",
			$in{'db'}, $in{'table'},
			$in{'start'} + $config{'perpage'};
		}
	print "</center>\n";
	}

print "<form action=view_table.cgi>\n";
print "<input type=hidden name=db value='$in{'db'}'>\n";
print "<input type=hidden name=table value='$in{'table'}'>\n";
print "<input type=hidden name=start value='$in{'start'}'>\n";
$check = !defined($in{'row'}) && !$in{'new'} && $keyed;
if ($total || $in{'new'}) {
	$d = &execute_sql($in{'db'}, "select * from $in{'table'} limit ".
				     $in{'start'}.",".$config{'perpage'});
	@data = @{$d->{'data'}};
	print "<table border width=100%>\n";
	print "<tr $tb>\n";
	print "<td>&nbsp;</td>\n" if ($check);
	foreach $t (@str) {
		print "<td><b>$t->{'field'}</b></td>\n";
		}
	print "</tr>\n";

	map { $row{$_}++ } split(/\0/, $in{'row'});
	$w = int(100 / scalar(@str));
	$w = 10 if ($w < 10);
	for($i=0; $i<@data; $i++) {
		local @d = map { $_ eq "NULL" ? undef : $_ } @{$data[$i]};
		print "<tr $cb>\n";
		if ($row{$i}) {
			for($j=0; $j<@d; $j++) {
				$qw = $d[$j] =~ /'/ ? '"' : "'";
				printf "<td width=$w%%><input name=${i}_$d->{'titles'}->[$j] size=$w value=$qw$d[$j]$qw></td>\n";
				}
			}
		else {
			print "<td><input type=checkbox name=row ",
			      "value=$i></td>\n" if ($check);
			foreach $c (@{$data[$i]}) {
				printf "<td width=$w%%>%s</td>\n",
					$c ne '' ? $c : "<br>";
				}
			}
		print "</tr>\n";
		}
	if ($in{'new'}) {
		print "<tr $cb>\n";
		for($j=0; $j<@str; $j++) {
			print "<td width=$w%><input name=$j size=$w></td>\n";
			}
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<b>$text{'view_none'}</b> <p>\n";
	}

print "<table width=100%><tr>\n";
if (!$keyed) {
	print "<tr> <td><b>$text{'view_nokey'}</b></td> </tr>\n";
	}
elsif (!$check) {
	if ($in{'new'}) {
		print "<td><input type=submit name=savenew ",
		      "value='$text{'save'}'></td>\n";
		}
	else {
		print "<td><input type=submit name=save ",
		      "value='$text{'save'}'></td>\n";
		}
	print "<td align=right><input type=submit name=cancel ",
	      "value='$text{'cancel'}'></td>\n";
	}
else {
	print "<td><input type=submit name=edit ",
	      "value='$text{'view_edit'}'></td>\n";
	print "<td align=middle><input type=submit name=new ",
	      "value='$text{'view_new'}'></td>\n";
	print "<td align=right><input type=submit name=delete ",
	      "value='$text{'view_delete'}'></td>\n";
	}
print "</tr></table></form>\n";

print "<hr>\n";
&footer("edit_table.cgi?db=$in{'db'}&table=$in{'table'}",$text{'table_return'});

