#!/usr/local/bin/perl
# save_shared.cgi
# Update, create or delete a shared network

require './dhcpd-lib.pl';
require './params-lib.pl';
&ReadParse();
&lock_file($config{'dhcpd_conf'});
$parent = &get_parent_config();
$conf = $parent->{'members'};
if ($in{'delete'}) {
	# Delete this net
	$whatfailed = $text{'sshared_faildel'};
	$sha = $conf->[$in{'idx'}];
	&save_directive($parent, [ $sha ], [ ], 0);
	}
elsif ($in{'options'}) {
	# Redirect to client options
	&redirect("edit_options.cgi?idx=$in{'idx'}");
	exit;
	}
else {
	$whatfailed = $text{'sshared_failsave'};
	if (!$in{'new'}) {
		# Get the old shared net structure
		$sha = $conf->[$in{'idx'}];
		}
	else {
		# Create a new net
		$sha->{'name'} = "shared-network";
		$sha->{'type'} = 1;
		$sha->{'members'} = [ ];
		}
	$in{'name'} =~ /^\S+$/ ||
		&error($text{'sshared_invalidsname'});
	$sha->{'values'} = [ $in{'name'} ];
	&parse_params($sha);

	if ($in{'new'}) {
		# Add this shared net
		&save_directive($parent, [ ], [ $sha ], 0);
		}
	else {
		# Update shared net
		&save_directive($parent, [ $sha ], [ $sha ], 0);
		}
	}
&flush_file_lines();
&unlock_file($config{'dhcpd_conf'});
&webmin_log($in{'delete'} ? 'delete' : $in{'new'} ? 'create' : 'modify',
	    'shared', $sha->{'values'}->[0], \%in);
&redirect("");

