#!/usr/local/bin/perl
# save_group.cgi
# Update, create or delete a group

require './dhcpd-lib.pl';
require './params-lib.pl';
&ReadParse();
&lock_file($config{'dhcpd_conf'});
$parent = &get_parent_config();
$conf = $parent->{'members'};
if ($in{'delete'}) {
	# Delete this group
	$whatfailed = $text{'sgroup_faildel'};
	$group = $conf->[$in{'idx'}];
	&save_directive($parent, [ $group ], [ ], 0);
	}
elsif ($in{'options'}) {
	# Redirect to client options
	&redirect("edit_options.cgi?idx=$in{'idx'}");
	exit;
	}
else {
	$whatfailed = $text{'sgroup_failsave'};
	if (!$in{'new'}) {
		# Get the old group structure
		$group = $conf->[$in{'idx'}];
		}
	else {
		# Create a new group
		$group->{'name'} = 'group';
		$group->{'type'} = 1;
		$group->{'members'} = [ ];
		}

	# Move hosts into or out of this group
	@wasin = &find("host", $group->{'members'});
	foreach $hn (split(/\0/, $in{'hosts'})) {
		if ($hn =~ /(\d+),(\d+)/) {
			push(@nowin, $conf->[$2]->{'members'}->[$1]);
			$nowpr{$conf->[$2]->{'members'}->[$1]} = $conf->[$2];
			}
		elsif ($hn =~ /(\d+),/) {
			push(@nowin, $conf->[$1]);
			$nowpr{$conf->[$1]} = $parent;
			}
		}
	foreach $h (&unique(@wasin, @nowin)) {
		$was = &indexof($h, @wasin) != -1;
		$now = &indexof($h, @nowin) != -1;
		if ($was && !$now) {
			# Move out of the group
			&save_directive($group, [ $h ], [ ], 0);
			&save_directive($parent, [ ], [ $h ], 0);
			}
		elsif ($now && !$was) {
			# Move into the group (maybe from another group)
			&save_directive($nowpr{$h}, [ $h ], [ ], 0);
			&save_directive($group, [ ], [ $h ], 1);
			}
		}

	# Validate and save inputs
	&save_choice("use-host-decl-names", $group, 1);
	&parse_params($group, 1);

	if ($in{'new'}) {
		# create this new group
		&save_directive($parent, [ ], [ $group ], 0);
		}
	}
&flush_file_lines();
&unlock_file($config{'dhcpd_conf'});
@count = &find("host", $group->{'members'});
&webmin_log($in{'delete'} ? 'delete' : $in{'new'} ? 'create' : 'modify',
	    'group', join(",", map { $_->{'values'}->[0] } @count), \%in);
&redirect("");

