# cron-lib.pl
# Common cront table functions

do '../web-lib.pl';
&init_config();
$cron_temp_file = "/tmp/cronadmin_temp";

# list_cron_jobs()
# Returns a lists of structures of all cron jobs
sub list_cron_jobs
{
local (@rv, $lnum, $f);

# read the master crontab file
if ($config{'vixie_cron'}) {
	$lnum = 0;
	open(TAB, $config{'system_crontab'});
	while(<TAB>) {
		if (/^(#+)?\s*(-)?\s*([0-9\-\*\/,]+)\s+([0-9\-\*\/,]+)\s+([0-9\-\*\/,]+)\s+([0-9\-\*\/,]+)\s+([0-9\-\*\/,]+)\s+(\S+)\s+(.*)/) {
			push(@rv, { 'file' => $config{'system_crontab'},
				    'line' => $lnum,
				    'type' => 1,
				    'nolog' => $2,
				    'active' => !$1,
				    'mins' => $3, 'hours' => $4,
				    'days' => $5, 'months' => $6,
				    'weekdays' => $7, 'user' => $8,
				    'command' => $9,
				    'index' => scalar(@rv) });
			}
		$lnum++;
		}
	close(TAB);
	}

# read package-specific cron files
opendir(DIR, $config{'cronfiles_dir'});
while($f = readdir(DIR)) {
	next if ($f =~ /^\./);
	$lnum = 0;
	open(TAB, "$config{'cronfiles_dir'}/$f");
	while(<TAB>) {
		if (/^(#+)?\s*(-)?\s*([0-9\-\*\/,]+)\s+([0-9\-\*\/,]+)\s+([0-9\-\*\/,]+)\s+([0-9\-\*\/,]+)\s+([0-9\-\*\/,]+)\s+(\S+)\s+(.*)/) {
			push(@rv, { 'file' => "$config{'cronfiles_dir'}/$f",
				    'line' => $lnum,
				    'type' => 2,
				    'active' => !$1,
				    'nolog' => $2,
				    'mins' => $3, 'hours' => $4,
				    'days' => $5, 'months' => $6,
				    'weekdays' => $7, 'user' => $8,
				    'command' => $9,
				    'index' => scalar(@rv) });
			}
		$lnum++;
		}
	close(TAB);
	}
closedir(DIR);

# read per-user cron files
opendir(DIR, $config{'cron_dir'});
while($f = readdir(DIR)) {
	next if ($f =~ /^\./ || !(@uinfo = getpwnam($f)));
	$lnum = 0;
	open(TAB, "$config{'cron_dir'}/$f");
	while(<TAB>) {
		if (/^(#+)?\s*(-)?\s*([0-9\-\*\/,]+)\s+([0-9\-\*\/,]+)\s+([0-9\-\*\/,]+)\s+([0-9\-\*\/,]+)\s+([0-9\-\*\/,]+)\s+(.*)/) {
			push(@rv, { 'file' => "$config{'cron_dir'}/$f",
				    'line' => $lnum,
				    'type' => 0,
				    'active' => !$1, 'nolog' => $2,
				    'mins' => $3, 'hours' => $4,
				    'days' => $5, 'months' => $6,
				    'weekdays' => $7, 'user' => $f,
				    'command' => $8,
				    'index' => scalar(@rv) });
			}
		$lnum++;
		}
	close(TAB);
	}
closedir(DIR);
return @rv;
}

sub cron_job_line
{
local @c;
push(@c, "#") if (!$_[0]->{'active'});
push(@c, ($_[0]->{'nolog'} ? '-' : '').$_[0]->{'mins'},
         $_[0]->{'hours'}, $_[0]->{'days'},
	 $_[0]->{'months'}, $_[0]->{'weekdays'});
push(@c, $_[0]->{'user'}) if ($_[0]->{'type'});
push(@c, $_[0]->{'command'});
return join(" ", @c);
}

# create_cron_job(&job)
sub create_cron_job
{
system("cp $config{'cron_dir'}/$_[0]->{'user'} $cron_temp_file");
open(TAB, ">>$cron_temp_file");
print TAB &cron_job_line($_[0]),"\n";
close(TAB);
&copy_crontab($_[0]->{'user'});
}

# change_cron_job(&job)
sub change_cron_job
{
if ($_[0]->{'type'} == 0) {
	system("cp $config{'cron_dir'}/$_[0]->{'user'} $cron_temp_file");
	&replace_file_line($cron_temp_file, $_[0]->{'line'},
			   &cron_job_line($_[0])."\n");
	&copy_crontab($_[0]->{'user'});
	}
else {
	&replace_file_line($_[0]->{'file'}, $_[0]->{'line'},
			   &cron_job_line($_[0])."\n");
	}
}

# delete_cron_job(&job)
sub delete_cron_job
{
if ($_[0]->{'type'} == 0) {
	system("cp $config{'cron_dir'}/$_[0]->{'user'} $cron_temp_file");
	&replace_file_line($cron_temp_file, $_[0]->{'line'});
	&copy_crontab($_[0]->{'user'});
	}
else {
	&replace_file_line($_[0]->{'file'}, $_[0]->{'line'});
	}
}

# read_crontab(user)
# Return an array containing the lines of the cron table for some user
sub read_crontab
{
local(@tab);
open(TAB, "$config{cron_dir}/$_[0]");
@tab = <TAB>;
close(TAB);
if ($config{vixie_cron} && $tab[0] =~ /DO NOT EDIT/ &&
    $tab[1] =~ /^\s*#/ && $tab[2] =~ /^\s*#/) {
	@tab = @tab[3..$#tab];
	}
return @tab;
}


# copy_crontab(user)
sub copy_crontab
{
local($pwd);
if (`cat $cron_temp_file` =~ /\S/) {
	if ($config{'cron_edit_command'}) {
		# fake being an editor
		chop($pwd = `pwd`);
		$ENV{"VISUAL"} = $ENV{"EDITOR"} = "$pwd/cron_editor.pl";
		$ENV{"CRON_EDITOR_COPY"} = $cron_temp_file;
		system(&user_sub($config{cron_edit_command},$_[0]).
		       " >/dev/null 2>/dev/null");
		}
	else {
		# use the cron copy command
		system(&user_sub($config{cron_copy_command},$_[0]).
		       " <$cron_temp_file >/dev/null 2>/dev/null");
		}
	}
else {
	system(&user_sub($config{cron_delete_command},$_[0]).
	       " >/dev/null 2>/dev/null");
	}
unlink($cron_temp_file);
}


# parse_job(job)
# Parse a crontab line into an array containing:
#  active, mins, hrs, days, mons, weekdays, command
sub parse_job
{
local($job, $active) = ($_[0], 1);
if ($job =~ /^#+\s*(.*)$/) {
	$active = 0;
	$job = $1;
	}
$job =~ /^\s*(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(.*)$/;
return ($active, $1, $2, $3, $4, $5, $6);
}

# user_sub(command, user)
# Replace the string 'USER' in the command with the user name
sub user_sub
{
local($tmp);
$tmp = $_[0];
$tmp =~ s/USER/$_[1]/g;
return $tmp;
}


# list_allowed()
# Returns a list of all users in the cron allow file
sub list_allowed
{
local(@rv, $_);
open(ALLOW, $config{cron_allow_file});
while(<ALLOW>) {
	chop; push(@rv, $_);
	}
close(ALLOW);
return @rv;
}


# list_denied()
# Return a list of users from the cron deny file
sub list_denied
{
local(@rv, $_);
open(DENY, $config{cron_deny_file});
while(<DENY>) {
	chop; push(@rv, $_);
	}
close(DENY);
return @rv;
}


# save_allowed(user, user, ...)
# Save the list of allowed users
sub save_allowed
{
local($_);
open(ALLOW, ">$config{cron_allow_file}");
foreach (@_) { print ALLOW $_,"\n"; }
close(ALLOW);
chmod(0444, $config{cron_allow_file});
}


# save_denied(user, user, ...)
# Save the list of denied users
sub save_denied
{
local($_);
open(DENY, "> $config{cron_deny_file}");
foreach (@_) { print DENY $_,"\n"; }
close(DENY);
chmod(0444, $config{cron_deny_file});
}

# read_envs(user)
# Returns an array of name,value pairs containing the environment settings
# from the crontab for some user
sub read_envs
{
local(@tab, @rv, $_);
@tab = &read_crontab($_[0]);
foreach (@tab) {
	chop; s/#.*$//g;
	if (/^\s*(\S+)\s*=\s*(.*)$/) { push(@rv, "$1 $2"); }
	}
return @rv;
}

# save_envs(user, [name, value]*)
# Updates the cron file for some user with the given list of environment
# variables. All others in the file are removed
sub save_envs
{
local($i, @tab, $line);
@tab = &read_crontab($_[0]);
open(TAB, "> $cron_temp_file");
for($i=1; $i<@_; $i+=2) {
	print TAB "$_[$i]=$_[$i+1]\n";
	}
foreach (@tab) {
	chop($line = $_); $line =~ s/#.*$//g;
	if ($line !~ /^\s*(\S+)\s*=\s*(.*)$/) { print TAB $_; }
	}
close(TAB);
&copy_crontab($_[0]);
}

# expand_run_parts(directory)
sub expand_run_parts
{
local $dir = $_[0];
$dir = "$config{'run_parts_dir'}/$dir"
	if ($config{'run_parts_dir'} && $dir !~ /^\//);
opendir(DIR, $dir);
local @rv = readdir(DIR);
closedir(DIR);
@rv = grep { !/^\./ } @rv;
@rv = map { $dir."/".$_ } @rv;
return @rv;
}

# is_run_parts(command)
sub is_run_parts
{
local $rp = $config{'run_parts'};
return $rp && $_[0] =~ /$rp(.*)\s+(\S+)$/ ? $2 : undef;
}

# can_edit_user(&access, user)
sub can_edit_user
{
local %umap;
map { $umap{$_}++; } split(/\s+/, $_[0]->{'users'});
if ($_[0]->{'mode'} == 1 && !$umap{$_[1]} ||
    $_[0]->{'mode'} == 2 && $umap{$_[1]}) { return 0; }
else { return 1; }
}

1;

