#!/usr/local/bin/perl
# save_soa.cgi
# Save changes to an SOA record

require './bind8-lib.pl';
&ReadParse();
&error_setup($text{'master_err2'});
%access = &get_module_acl();
&can_edit_zone(\%access, $in{'origin'}) ||
	&error($text{'master_ecannot'});
$access{'ro'} && &error($text{'master_ero'});
$access{'params'} || &error($text{'master_esoacannot'});

# check inputs
$in{'master'} =~ /^[A-z0-9\-\.]+$/ ||
	&error(&text('master_emaster', $in{'master'}));
$in{'email'} =~ /^\S+$/ ||
	&error(&text('master_eemail', $in{'email'}));
$in{'refresh'} =~ /^\S+$/ ||
	&error(&text('master_erefresh', $in{'refresh'}));
$in{'retry'} =~ /^\S+$/ ||
	&error(&text('master_eretry', $in{'retry'}));
$in{'expiry'} =~ /^\S+$/ ||
	&error(&text('master_eexpiry', $in{'expiry'}));
$in{'minimum'} =~ /^\S+$/ ||
	&error(&text('master_eminimum', $in{'minimum'}));
if ($in{'email'} =~ s/\@/\./) { $in{'email'} .= "."; }

&lock_file($config{'chroot'}.$in{'file'});
@recs = &read_zone_file($in{'file'}, $in{'origin'});
$old = $recs[$in{'num'}];
if ($config{'soa_style'} == 1 && $old->{'values'}->[2] =~ /^(\d{8})(\d\d)$/) {
        if ($1 eq &date_serial()) { $serial = sprintf "%d%2.2d", $1, $2+1; }
        else { $serial = &date_serial()."00"; }
        }
else {
        $serial = $old->{'values'}->[2]+1;
        }
$vals = "$in{'master'} $in{'email'} (\n".
	"\t\t\t$serial\n".
	"\t\t\t$in{'refresh'}\n".
	"\t\t\t$in{'retry'}\n".
	"\t\t\t$in{'expiry'}\n".
	"\t\t\t$in{'minimum'} )";
&modify_record($in{'file'}, $old, $old->{'name'}, $old->{'ttl'},
	       $old->{'class'}, "SOA", $vals);
&unlock_file($config{'chroot'}.$in{'file'});
&webmin_log("soa", undef, $in{'origin'}, \%in);
&redirect("edit_master.cgi?index=$in{'index'}");

