# mod_imap.pl
# Defines editors for imagemap directives

sub mod_imap_directives
{
$rv = [ [ 'ImapMenu', 0, 5, 'virtual directory htaccess' ],
        [ 'ImapDefault', 0, 5, 'virtual directory htaccess' ],
        [ 'ImapBase', 0, 5, 'virtual directory htaccess' ] ];
return &make_directives($rv, $_[0], "mod_imap");
}

sub mod_imap_handlers
{
return ("imap-file");
}

sub edit_ImapMenu
{
return (2, "$text{'mod_imap_0'}",
        &select_input($_[0]->{'value'}, "ImapMenu", "", "$text{'mod_imap_1'},",
         "$text{'mod_imap_2'},none", "$text{'mod_imap_3'},formatted",
         "$text{'mod_imap_4'},semiformatted",
         "$text{'mod_imap_5'},unformatted"));
}
sub save_ImapMenu
{
return &parse_select("ImapMenu", "");
}

sub edit_ImapDefault
{
local($rv, $v);
if ($_[0]->{'value'} =~ /^\S+:/) { $v = "url"; }
else { $v = $_[0]->{'value'}; }
$rv = &select_input($v, "ImapDefault", "", "$text{'mod_imap_6'},",
       "$text{'mod_imap_7'},error",  "$text{'mod_imap_8'},nocontent",
       "$text{'mod_imap_9'},map", "$text{'mod_imap_10'},referer",
       "$text{'mod_imap_11'},url");
$rv .= sprintf "&nbsp;<input name=ImapDefault_url size=30 value=\"%s\">\n",
        $v eq "url" ? $_[0]->{'value'} : "";
return (2, "$text{'mod_imap_12'}", $rv);
}
sub save_ImapDefault
{
if ($in{'ImapDefault'} eq "") { return ( [ ] ); }
elsif ($in{'ImapDefault'} ne "url") { return ( [ $in{'ImapDefault'} ] ); }
elsif ($in{'ImapDefault_url'} !~ /^\S+$/) {
	&error(&text('mod_imap_19', $in{'ImapDefault_url'}));
	}
else { return ( [ $in{'ImapDefault_url'} ] ); }
}

sub edit_ImapBase
{
local($rv, $v);
if ($_[0]->{'value'} =~ /^\S+:/) { $v = "url"; }
else { $v = $_[0]->{'value'}; }
$rv = &select_input($v, "ImapBase", "", "$text{'mod_imap_13'},",
       "$text{'mod_imap_14'},root", "$text{'mod_imap_15'},map",
       "$text{'mod_imap_16'},referer", "$text{'mod_imap_17'},url");
$rv .= sprintf "&nbsp;<input name=ImapBase_url size=30 value=\"%s\">\n",
        $v eq "url" ? $_[0]->{'value'} : "";
return (2, "$text{'mod_imap_18'}", $rv);
}
sub save_ImapBase
{
if ($in{'ImapBase'} eq "") { return ( [ ] ); }
elsif ($in{'ImapBase'} ne "url") { return ( [ $in{'ImapBase'} ] ); }
elsif ($in{'ImapBase_url'} !~ /^\S+$/) {
	&error(&text('mod_imap_20', $in{'ImapBase_url'}));
	}
else { return ( [ $in{'ImapBase_url'} ] ); }
}

1;

