/*
 * Decompiled with CFR 0.152.
 */
package de.mud.telnet;

import java.awt.Dimension;
import java.io.IOException;

public abstract class TelnetProtocolHandler {
    public static final String ID = "$Id: TelnetProtocolHandler.java,v 2.7 2000/03/19 14:56:20 marcus Exp $";
    private static final int debug = 0;
    private static byte[] one = new byte[1];
    private byte neg_state = 0;
    private static final byte STATE_DATA = 0;
    private static final byte STATE_IAC = 1;
    private static final byte STATE_IACSB = 2;
    private static final byte STATE_IACWILL = 3;
    private static final byte STATE_IACDO = 4;
    private static final byte STATE_IACWONT = 5;
    private static final byte STATE_IACDONT = 6;
    private static final byte STATE_IACSBIAC = 7;
    private static final byte STATE_IACSBDATA = 8;
    private static final byte STATE_IACSBDATAIAC = 9;
    private byte current_sb;
    private static final byte IAC = -1;
    private static final byte EOR = -17;
    private static final byte WILL = -5;
    private static final byte WONT = -4;
    private static final byte DO = -3;
    private static final byte DONT = -2;
    private static final byte SB = -6;
    private static final byte SE = -16;
    private static final byte TELOPT_ECHO = 1;
    private static final byte TELOPT_SGA = 3;
    private static final byte TELOPT_EOR = 25;
    private static final byte TELOPT_NAWS = 31;
    private static final byte TELOPT_TTYPE = 24;
    private static final byte[] IACWILL = new byte[]{-1, -5};
    private static final byte[] IACWONT = new byte[]{-1, -4};
    private static final byte[] IACDO = new byte[]{-1, -3};
    private static final byte[] IACDONT = new byte[]{-1, -2};
    private static final byte[] IACSB = new byte[]{-1, -6};
    private static final byte[] IACSE = new byte[]{-1, -16};
    private static final byte TELQUAL_IS = 0;
    private static final byte TELQUAL_SEND = 1;
    private byte[] receivedDX;
    private byte[] receivedWX;
    private byte[] sentDX;
    private byte[] sentWX;

    public TelnetProtocolHandler() {
        this.reset();
    }

    protected abstract String getTerminalType();

    protected abstract Dimension getWindowSize();

    protected abstract void setLocalEcho(boolean var1);

    protected abstract void notifyEndOfRecord();

    protected abstract void write(byte[] var1) throws IOException;

    private void write(byte by) throws IOException {
        TelnetProtocolHandler.one[0] = by;
        this.write(one);
    }

    public void reset() {
        this.neg_state = 0;
        this.receivedDX = new byte[256];
        this.sentDX = new byte[256];
        this.receivedWX = new byte[256];
        this.sentWX = new byte[256];
    }

    private void handle_sb(byte by, byte[] byArray, int n) throws IOException {
        switch (by) {
            case 24: {
                if (n <= 0 || byArray[0] != 1) break;
                this.write(IACSB);
                this.write((byte)24);
                this.write((byte)0);
                String string = this.getTerminalType();
                if (string == null) {
                    string = "dumb";
                }
                this.write(string.getBytes());
                this.write(IACSE);
            }
        }
    }

    public void startup() throws IOException {
        byte[] byArray = new byte[]{-1, -3, 3};
        this.write(byArray);
        this.sentDX[3] = -3;
    }

    public void transpose(byte[] byArray) throws IOException {
        int n = 0;
        byte[] byArray2 = new byte[byArray.length * 2];
        int n2 = 0;
        while (n2 < byArray.length) {
            switch (byArray[n2]) {
                case -1: {
                    byArray2[n++] = -1;
                    byArray2[n++] = -1;
                    break;
                }
                case 10: {
                    byArray2[n++] = 13;
                    byArray2[n++] = 10;
                    break;
                }
                case 13: {
                    byArray2[n++] = 13;
                    byArray2[n++] = 0;
                    break;
                }
                default: {
                    byArray2[n++] = byArray[n2];
                }
            }
            ++n2;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        this.write(byArray3);
    }

    public int negotiate(byte[] byArray, int n) throws IOException {
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[3];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            byte by;
            if ((by = byArray[n3++]) >= 128) {
                by = (byte)(by - 256);
            }
            block0 : switch (this.neg_state) {
                case 0: {
                    if (by == -1) {
                        this.neg_state = 1;
                        break;
                    }
                    byArray2[n4++] = by;
                    break;
                }
                case 1: {
                    switch (by) {
                        case -1: {
                            this.neg_state = 0;
                            byArray2[n4++] = -1;
                            break block0;
                        }
                        case -5: {
                            this.neg_state = (byte)3;
                            break block0;
                        }
                        case -4: {
                            this.neg_state = (byte)5;
                            break block0;
                        }
                        case -2: {
                            this.neg_state = (byte)6;
                            break block0;
                        }
                        case -3: {
                            this.neg_state = (byte)4;
                            break block0;
                        }
                        case -17: {
                            this.notifyEndOfRecord();
                            this.neg_state = 0;
                            break block0;
                        }
                        case -6: {
                            this.neg_state = (byte)2;
                            n2 = 0;
                            break block0;
                        }
                    }
                    this.neg_state = 0;
                    break;
                }
                case 3: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            by2 = -3;
                            this.setLocalEcho(false);
                            break;
                        }
                        case 3: {
                            by2 = -3;
                            break;
                        }
                        case 25: {
                            by2 = -3;
                            break;
                        }
                        default: {
                            by2 = -2;
                        }
                    }
                    if (by2 != this.sentDX[by + 128] || -5 != this.receivedWX[by + 128]) {
                        byArray4[0] = -1;
                        byArray4[1] = by2;
                        byArray4[2] = by;
                        this.write(byArray4);
                        this.sentDX[by + 128] = by2;
                        this.receivedWX[by + 128] = -5;
                    }
                    this.neg_state = 0;
                    break;
                }
                case 5: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            this.setLocalEcho(true);
                            by2 = -2;
                            break;
                        }
                        case 3: {
                            by2 = -2;
                            break;
                        }
                        case 25: {
                            by2 = -2;
                            break;
                        }
                        default: {
                            by2 = -2;
                        }
                    }
                    if (by2 != this.sentDX[by + 128] || -4 != this.receivedWX[by + 128]) {
                        byArray4[0] = -1;
                        byArray4[1] = by2;
                        byArray4[2] = by;
                        this.write(byArray4);
                        this.sentDX[by + 128] = by2;
                        this.receivedWX[by + 128] = -5;
                    }
                    this.neg_state = 0;
                    break;
                }
                case 4: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            by2 = -5;
                            this.setLocalEcho(true);
                            break;
                        }
                        case 3: {
                            by2 = -5;
                            break;
                        }
                        case 24: {
                            by2 = -5;
                            break;
                        }
                        case 31: {
                            Dimension dimension = this.getWindowSize();
                            this.receivedDX[by] = -3;
                            if (dimension == null) {
                                this.write((byte)-1);
                                this.write((byte)-4);
                                this.write((byte)31);
                                by2 = -4;
                                this.sentWX[by] = -4;
                                break;
                            }
                            by2 = -5;
                            this.sentWX[by] = -5;
                            byArray4[0] = -1;
                            byArray4[1] = -5;
                            byArray4[2] = 31;
                            this.write(byArray4);
                            this.write((byte)-1);
                            this.write((byte)-6);
                            this.write((byte)31);
                            this.write((byte)(dimension.width >> 8));
                            this.write((byte)(dimension.width & 0xFF));
                            this.write((byte)(dimension.height >> 8));
                            this.write((byte)(dimension.height & 0xFF));
                            this.write((byte)-1);
                            this.write((byte)-16);
                            break;
                        }
                        default: {
                            by2 = -4;
                        }
                    }
                    if (by2 != this.sentWX[128 + by] || -3 != this.receivedDX[128 + by]) {
                        byArray4[0] = -1;
                        byArray4[1] = by2;
                        byArray4[2] = by;
                        this.write(byArray4);
                        this.sentWX[by + 128] = by2;
                        this.receivedDX[by + 128] = -3;
                    }
                    this.neg_state = 0;
                    break;
                }
                case 6: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            by2 = -4;
                            this.setLocalEcho(false);
                            break;
                        }
                        case 3: {
                            by2 = -4;
                            break;
                        }
                        case 31: {
                            by2 = -4;
                            break;
                        }
                        default: {
                            by2 = -4;
                        }
                    }
                    if (by2 != this.sentWX[by + 128] || -2 != this.receivedDX[by + 128]) {
                        this.write((byte)-1);
                        this.write(by2);
                        this.write(by);
                        this.sentWX[by + 128] = by2;
                        this.receivedDX[by + 128] = -2;
                    }
                    this.neg_state = 0;
                    break;
                }
                case 7: {
                    if (by == -1) {
                        n2 = 0;
                        this.current_sb = by;
                        this.neg_state = (byte)8;
                        break;
                    }
                    System.err.println("(bad) " + by + " ");
                    this.neg_state = 0;
                    break;
                }
                case 2: {
                    switch (by) {
                        case -1: {
                            this.neg_state = (byte)7;
                            break block0;
                        }
                    }
                    this.current_sb = by;
                    n2 = 0;
                    this.neg_state = (byte)8;
                    break;
                }
                case 8: {
                    switch (by) {
                        case -1: {
                            this.neg_state = (byte)9;
                            break block0;
                        }
                    }
                    byArray3[n2++] = by;
                    break;
                }
                case 9: {
                    switch (by) {
                        case -1: {
                            this.neg_state = (byte)8;
                            byArray3[n2++] = -1;
                            break block0;
                        }
                        case -16: {
                            this.handle_sb(this.current_sb, byArray3, n2);
                            this.current_sb = 0;
                            this.neg_state = 0;
                            break block0;
                        }
                        case -6: {
                            this.handle_sb(this.current_sb, byArray3, n2);
                            this.neg_state = (byte)2;
                            break block0;
                        }
                    }
                    this.neg_state = 0;
                    break;
                }
                default: {
                    this.neg_state = 0;
                }
            }
        }
        System.arraycopy(byArray2, 0, byArray, 0, n4);
        return n4;
    }
}

