/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import cryptix.crypt.MD5;
import de.mud.ssh.SshCrypto;
import de.mud.ssh.SshMisc;
import de.mud.ssh.SshPacket;
import java.io.IOException;
import java.util.Date;

public abstract class SshIO {
    private String identification_string = "";
    private String identification_string_sent = "SSH-1.5-Java Ssh 1.1 (16/09/99) leo@mud.de, original by Cedric Gourio (javassh@france-mail.com)\r";
    private static int debug = 0;
    private boolean encryption = false;
    private SshCrypto crypto;
    SshPacket lastPacketReceived;
    private String login = "";
    private String password = "";
    public String dataToSend = null;
    public String hashHostKey = null;
    byte lastPacketSentType;
    private int phase = 0;
    private final int PHASE_INIT = 0;
    private final int PHASE_SSH_RECEIVE_PACKET = 1;
    private final int SSH_MSG_DISCONNECT = 1;
    private final int SSH_SMSG_PUBLIC_KEY = 2;
    private final int SSH_CMSG_SESSION_KEY = 3;
    private final int SSH_CMSG_USER = 4;
    private final int SSH_CMSG_AUTH_PASSWORD = 9;
    private final int SSH_CMSG_REQUEST_PTY = 10;
    private final int SSH_CMSG_EXEC_SHELL = 12;
    private final int SSH_SMSG_SUCCESS = 14;
    private final int SSH_SMSG_FAILURE = 15;
    private final int SSH_CMSG_STDIN_DATA = 16;
    private final int SSH_SMSG_STDOUT_DATA = 17;
    private final int SSH_SMSG_STDERR_DATA = 18;
    private final int SSH_SMSG_EXITSTATUS = 20;
    private final int SSH_CMSG_EXIT_CONFIRMATION = 33;
    private final int SSH_MSG_DEBUG = 36;
    private int position = 0;
    private int SSH_CIPHER_NONE = 0;
    private int SSH_CIPHER_IDEA = 1;
    private int SSH_CIPHER_DES = 2;
    private int SSH_CIPHER_3DES = 3;
    private int SSH_CIPHER_TSS = 4;
    private int SSH_CIPHER_RC4 = 5;
    private final int SSH_AUTH_RHOSTS = 1;
    private final int SSH_AUTH_RSA = 2;
    private final int SSH_AUTH_PASSWORD = 3;
    private final int SSH_AUTH_RHOSTS_RSA = 4;
    byte[] one = new byte[1];

    public void setLogin(String string) {
        if (string == null) {
            string = "";
        }
        this.login = string;
    }

    public void setPassword(String string) {
        if (string == null) {
            string = "";
        }
        this.password = string;
    }

    public synchronized byte[] handleSSH(byte[] byArray) throws IOException {
        byte[] byArray2 = this.packetDone(this.handleBytes(byArray, 0, byArray.length));
        while (this.lastPacketReceived != null && this.lastPacketReceived.toBeFinished) {
            byte[] byArray3;
            byte[] byArray4 = this.lastPacketReceived.unfinishedBuffer;
            int n = this.lastPacketReceived.positionInUnfinishedBuffer;
            if (byArray4 == null || (byArray3 = this.packetDone(this.handleBytes(byArray4, n, byArray4.length))) == null) continue;
            if (byArray2 != null) {
                byte[] byArray5 = new byte[byArray3.length + byArray2.length];
                System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
                System.arraycopy(byArray3, 0, byArray5, byArray2.length, byArray3.length);
                byArray2 = byArray5;
                continue;
            }
            byArray2 = byArray3;
        }
        return byArray2;
    }

    private byte[] packetDone(SshPacket sshPacket) throws IOException {
        if (sshPacket == null) {
            return null;
        }
        this.lastPacketReceived = sshPacket;
        byte[] byArray = this.handlePacket(this.lastPacketReceived.getType(), this.lastPacketReceived.getData());
        return byArray;
    }

    protected abstract void write(byte[] var1) throws IOException;

    private void write(byte by) throws IOException {
        this.one[0] = by;
        this.write(this.one);
    }

    public void disconnect() {
        this.login = "";
        this.password = "";
        this.phase = 0;
        this.encryption = false;
        this.lastPacketReceived = null;
    }

    public synchronized void sendData(String string) throws IOException {
        if (debug > 1) {
            System.out.println("SshIO.send(" + string + ")");
        }
        this.dataToSend = this.dataToSend == null ? string : this.dataToSend + string;
        this.Send_SSH_CMSG_STDIN_DATA(string);
        this.dataToSend = null;
    }

    private SshPacket handleBytes(byte[] byArray, int n, int n2) throws IOException {
        if (debug > 1) {
            System.out.println("SshIO.getPacket(" + byArray + "," + n2 + ")");
        }
        int n3 = n;
        while (n3 < n2) {
            byte by = byArray[n3++];
            switch (this.phase) {
                case 0: {
                    this.identification_string = this.identification_string + (char)by;
                    if (by != 10) break;
                    ++this.phase;
                    this.write(this.identification_string_sent.getBytes());
                    this.position = 0;
                    byte[] byArray2 = SshMisc.createString(this.identification_string_sent);
                    byte by2 = 17;
                    SshPacket sshPacket = this.createPacket(by2, byArray2);
                    return sshPacket;
                }
                case 1: {
                    SshPacket sshPacket = this.lastPacketReceived.getPacketfromBytes(byArray, n3 - 1, n2, this.encryption, this.crypto);
                    return sshPacket;
                }
            }
        }
        return null;
    }

    private SshPacket createPacket(byte by, byte[] byArray) throws IOException {
        return new SshPacket(by, byArray, this.encryption, this.crypto);
    }

    private byte[] handlePacket(byte by, byte[] byArray) throws IOException {
        int n = 0;
        if (debug > 0) {
            System.out.println("1 packet to handle, type " + by);
        }
        switch (by) {
            case 1: {
                String string = SshMisc.getString(n, byArray);
                this.disconnect();
                return string.getBytes();
            }
            case 2: {
                byte[] byArray2 = new byte[8];
                byte[] byArray3 = new byte[4];
                byte[] byArray4 = new byte[4];
                byte[] byArray5 = new byte[4];
                byte[] byArray6 = new byte[4];
                byte[] byArray7 = new byte[4];
                int n2 = 0;
                while (n2 <= 7) {
                    byArray2[n2] = byArray[n++];
                    ++n2;
                }
                int n3 = 0;
                while (n3 <= 3) {
                    byArray3[n3] = byArray[n++];
                    ++n3;
                }
                byte[] byArray8 = SshMisc.getMpInt(n, byArray);
                byte[] byArray9 = SshMisc.getMpInt(n += byArray8.length + 2, byArray);
                n += byArray9.length + 2;
                int n4 = 0;
                while (n4 <= 3) {
                    byArray4[n4] = byArray[n++];
                    ++n4;
                }
                byte[] byArray10 = SshMisc.getMpInt(n, byArray);
                byte[] byArray11 = SshMisc.getMpInt(n += byArray10.length + 2, byArray);
                n += byArray11.length + 2;
                int n5 = 0;
                while (n5 < 4) {
                    byArray5[n5] = byArray[n++];
                    ++n5;
                }
                int n6 = 0;
                while (n6 < 4) {
                    byArray6[n6] = byArray[n++];
                    ++n6;
                }
                int n7 = 0;
                while (n7 < 4) {
                    byArray7[n7] = byArray[n++];
                    ++n7;
                }
                this.Send_SSH_CMSG_SESSION_KEY(byArray2, byArray9, byArray11, byArray6, byArray8, byArray10);
                if (this.hashHostKey == null || this.hashHostKey.compareTo("") == 0) break;
                byte[] byArray12 = MD5.hash((byte[])byArray11);
                String string = "";
                int n8 = 0;
                while (n8 < byArray12.length) {
                    String string2 = "";
                    int[] nArray = new int[]{(byArray12[n8] & 0xF0) >> 4, byArray12[n8] & 0xF};
                    int n9 = 0;
                    while (n9 < 1) {
                        switch (nArray[n9]) {
                            case 10: {
                                string2 = string2 + "a";
                                break;
                            }
                            case 11: {
                                string2 = string2 + "b";
                                break;
                            }
                            case 12: {
                                string2 = string2 + "c";
                                break;
                            }
                            case 13: {
                                string2 = string2 + "d";
                                break;
                            }
                            case 14: {
                                string2 = string2 + "e";
                                break;
                            }
                            case 15: {
                                string2 = string2 + "f";
                                break;
                            }
                            default: {
                                string2 = string2 + String.valueOf(nArray[n9]);
                            }
                        }
                        ++n9;
                    }
                    string = string + string2;
                    ++n8;
                }
                if (string.compareTo(this.hashHostKey) == 0) break;
                this.password = "";
                this.login = "";
                return "\nHash value of the host key not correct \r\nlogin & password have been reset \r\n- erase the 'hashHostKey' parameter in the Html\r\n(it is used for auhentificating the server and prevent you from connecting \r\nto any other)\r\n".getBytes();
            }
            case 14: {
                if (this.lastPacketSentType == 3) {
                    this.Send_SSH_CMSG_USER();
                    break;
                }
                if (this.lastPacketSentType == 9) {
                    System.out.println("login succesful");
                    this.Send_SSH_CMSG_REQUEST_PTY();
                    return "\nLogin & password accepted\r\n".getBytes();
                }
                if (this.lastPacketSentType != 10) break;
                this.Send_SSH_CMSG_EXEC_SHELL();
                break;
            }
            case 15: {
                if (this.lastPacketSentType == 9) {
                    System.out.println("failed to log in");
                    this.disconnect();
                    return "\nLogin & password not accepted\r\n".getBytes();
                }
                if (this.lastPacketSentType == 4) {
                    this.Send_SSH_CMSG_AUTH_PASSWORD();
                    break;
                }
                if (this.lastPacketSentType != 10) break;
                break;
            }
            case 17: {
                String string = SshMisc.getString(0, byArray);
                return string.getBytes();
            }
            case 18: {
                String string = "Error : " + SshMisc.getString(0, byArray);
                System.out.println("SshIO.handlePacket : STDERR_DATA " + string);
                return string.getBytes();
            }
            case 20: {
                int n10 = (byArray[0] << 24) + (byArray[1] << 16) + (byArray[2] << 8) + byArray[3];
                this.Send_SSH_CMSG_EXIT_CONFIRMATION();
                System.out.println("SshIO : Exit status " + n10);
                this.disconnect();
                break;
            }
            case 36: {
                String string = SshMisc.getString(0, byArray);
                if (debug > 0) {
                    System.out.println("SshIO.handlePacket :  DEBUG " + string);
                    return string.getBytes();
                }
                return "".getBytes();
            }
            default: {
                System.err.print("SshIO.handlePacket : Packet Type unknown: " + by);
            }
        }
        return null;
    }

    private void sendPacket(SshPacket sshPacket) throws IOException {
        this.write(sshPacket.getBytes());
        this.lastPacketSentType = sshPacket.getType();
    }

    private byte[] Send_SSH_CMSG_SESSION_KEY(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) throws IOException {
        byte[] byArray7 = new byte[byArray3.length + byArray2.length + byArray.length];
        System.arraycopy(byArray3, 0, byArray7, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray7, byArray3.length, byArray2.length);
        System.arraycopy(byArray, 0, byArray7, byArray3.length + byArray2.length, byArray.length);
        byte[] byArray8 = MD5.hash((byte[])byArray7);
        byte by = (byte)this.SSH_CIPHER_IDEA;
        if ((1 << by & 0xFF & byArray4[3]) == 0) {
            System.err.println("SshIO: encryption method not supported\n");
            this.disconnect();
            return "\rencryption method not supported !!\r\n".getBytes();
        }
        byte[] byArray9 = new byte[16];
        byte[] byArray10 = new byte[16];
        byArray9 = MD5.hash((String)("" + Math.random() * (double)new Date().getTime()));
        byArray10 = byArray9;
        byArray9 = MD5.hash((byte[])SshMisc.addArrayOfBytes(MD5.hash((String)(this.password + this.login)), byArray9));
        byArray10 = MD5.hash((byte[])SshMisc.addArrayOfBytes(MD5.hash((String)(this.password + this.login)), byArray10));
        byte[] byArray11 = SshMisc.addArrayOfBytes(byArray9, byArray10);
        byte[] byArray12 = SshMisc.XORArrayOfBytes(byArray9, byArray8);
        byArray12 = SshMisc.addArrayOfBytes(byArray12, byArray12);
        byte[] byArray13 = SshCrypto.encrypteRSAPkcs1Twice(byArray12, byArray5, byArray2, byArray6, byArray3);
        byte[] byArray14 = new byte[4];
        byArray14[3] = 0;
        byArray14[2] = 0;
        byArray14[1] = 0;
        byArray14[0] = 0;
        int n = 1 + byArray.length + byArray13.length + byArray14.length;
        byte[] byArray15 = new byte[n];
        int n2 = 0;
        byArray15[n2++] = by;
        int n3 = 0;
        while (n3 < 8) {
            byArray15[n2++] = byArray[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < byArray13.length) {
            byArray15[n2++] = byArray13[n4];
            ++n4;
        }
        int n5 = 0;
        while (n5 < 4) {
            byArray15[n2++] = byArray14[n5];
            ++n5;
        }
        byte by2 = 3;
        SshPacket sshPacket = this.createPacket(by2, byArray15);
        this.sendPacket(sshPacket);
        if (by == (byte)this.SSH_CIPHER_IDEA) {
            byte[] byArray16 = new byte[16];
            int n6 = 0;
            while (n6 < 16) {
                byArray16[n6] = byArray11[n6];
                ++n6;
            }
            this.crypto = new SshCrypto(byArray16);
            this.encryption = true;
        }
        return null;
    }

    private byte[] Send_SSH_CMSG_USER() throws IOException {
        if (debug > 0) {
            System.err.println("Send_SSH_CMSG_USER(" + this.login + ")");
        }
        byte[] byArray = SshMisc.createString(this.login);
        byte by = 4;
        SshPacket sshPacket = this.createPacket(by, byArray);
        this.sendPacket(sshPacket);
        return null;
    }

    private byte[] Send_SSH_CMSG_AUTH_PASSWORD() throws IOException {
        byte[] byArray = SshMisc.createString(this.password);
        byte by = 9;
        SshPacket sshPacket = this.createPacket(by, byArray);
        this.sendPacket(sshPacket);
        return null;
    }

    private byte[] Send_SSH_CMSG_EXEC_SHELL() throws IOException {
        byte[] byArray = null;
        byte by = 12;
        SshPacket sshPacket = this.createPacket(by, byArray);
        this.sendPacket(sshPacket);
        this.lastPacketSentType = by;
        return null;
    }

    private byte[] Send_SSH_CMSG_STDIN_DATA(String string) throws IOException {
        byte[] byArray = SshMisc.createString(string);
        byte by = 16;
        SshPacket sshPacket = this.createPacket(by, byArray);
        this.sendPacket(sshPacket);
        return null;
    }

    private byte[] Send_SSH_CMSG_REQUEST_PTY() throws IOException {
        byte[] byArray = SshMisc.createString("vt320");
        byte[] byArray2 = new byte[4];
        byArray2[3] = 24;
        byte[] byArray3 = new byte[4];
        byArray3[3] = 80;
        byte[] byArray4 = new byte[4];
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = new byte[]{0};
        byte[] byArray7 = new byte[byArray.length + 16 + byArray6.length];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray7[n++] = byArray[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < 4) {
            byArray7[n++] = byArray2[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < 4) {
            byArray7[n++] = byArray3[n4];
            ++n4;
        }
        int n5 = 0;
        while (n5 < 4) {
            byArray7[n++] = byArray4[n5];
            ++n5;
        }
        int n6 = 0;
        while (n6 < 4) {
            byArray7[n++] = byArray5[n6];
            ++n6;
        }
        int n7 = 0;
        while (n7 < byArray6.length) {
            byArray7[n++] = byArray6[n7];
            ++n7;
        }
        byte by = 10;
        SshPacket sshPacket = this.createPacket(by, byArray7);
        this.sendPacket(sshPacket);
        return null;
    }

    private byte[] Send_SSH_CMSG_EXIT_CONFIRMATION() throws IOException {
        byte by = 33;
        SshPacket sshPacket = this.createPacket(by, null);
        this.sendPacket(sshPacket);
        return null;
    }
}

