/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.OnlineStatus;
import de.mud.jta.event.SocketListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Shell
extends Plugin
implements FilterPlugin {
    private static final int debug = 1;
    protected String shellCommand;
    protected InputStream in;
    protected InputStream err;
    protected OutputStream out;
    protected Process p;
    private byte[] buffer;
    private int pos;

    public Shell(PluginBus pluginBus, final String string) {
        super(pluginBus, string);
        pluginBus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig pluginConfig) {
                String string2 = pluginConfig.getProperty("Shell", string, "command");
                if (string2 != null) {
                    Shell.this.shellCommand = string2;
                }
            }
        });
        pluginBus.registerPluginListener(new SocketListener(){

            public void connect(String string, int n) {
                if (Shell.this.p == null) {
                    Shell.this.execute(string);
                }
            }

            public void disconnect() {
                if (Shell.this.p != null) {
                    Shell.this.p.destroy();
                    Shell.this.p = null;
                    Shell.this.in = null;
                    Shell.this.out = null;
                } else {
                    Shell.this.execute(null);
                }
            }
        });
    }

    private void execute(String string) {
        String string2 = this.shellCommand = string != null ? string : this.shellCommand;
        if (this.shellCommand == null) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            this.p = runtime.exec(this.shellCommand);
            this.in = this.p.getInputStream();
            this.out = this.p.getOutputStream();
            this.err = this.p.getErrorStream();
        }
        catch (Exception exception) {
            this.error("error: " + exception);
            exception.printStackTrace();
        }
        this.bus.broadcast(new OnlineStatus(true));
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
    }

    private byte[] transpose(byte[] byArray) {
        int n = 0;
        byte[] byArray2 = new byte[byArray.length * 2];
        int n2 = 0;
        while (n2 < byArray.length) {
            switch (byArray[n2]) {
                case 10: {
                    byArray2[n++] = 13;
                    byArray2[n++] = 10;
                    break;
                }
                default: {
                    byArray2[n++] = byArray[n2];
                }
            }
            ++n2;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    public int read(byte[] byArray) throws IOException {
        int n;
        if (this.buffer != null) {
            int n2 = this.buffer.length - this.pos <= byArray.length ? this.buffer.length - this.pos : byArray.length;
            System.arraycopy(this.buffer, this.pos, byArray, 0, n2);
            if (this.pos + n2 < this.buffer.length) {
                this.pos += n2;
            } else {
                this.buffer = null;
            }
            return n2;
        }
        int n3 = n = this.err.available() > 0 ? this.err.read(byArray) : this.in.read(byArray);
        if (n > 0) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            this.buffer = this.transpose(byArray2);
            if (this.buffer != null && this.buffer.length > 0) {
                int n4 = this.buffer.length <= byArray.length ? this.buffer.length : byArray.length;
                System.arraycopy(this.buffer, 0, byArray, 0, n4);
                this.pos = n = n4;
                if (n4 == this.buffer.length) {
                    this.buffer = null;
                    this.pos = 0;
                }
            } else {
                return 0;
            }
        }
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
        this.out.flush();
    }
}

