/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.LocalEchoRequest;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.TerminalTypeRequest;
import de.mud.jta.event.WindowSizeRequest;
import de.mud.ssh.SshIO;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

public class SSH
extends Plugin
implements FilterPlugin {
    protected FilterPlugin source;
    protected SshIO handler;
    protected String user;
    protected String pass;
    private static final int debug = 0;
    private boolean auth = false;
    private byte[] buffer;
    private int pos;

    public SSH(final PluginBus pluginBus, final String string) {
        super(pluginBus, string);
        this.handler = new SshIO(){

            public String getTerminalType() {
                return (String)pluginBus.broadcast(new TerminalTypeRequest());
            }

            public Dimension getWindowSize() {
                return (Dimension)pluginBus.broadcast(new WindowSizeRequest());
            }

            public void setLocalEcho(boolean bl) {
                pluginBus.broadcast(new LocalEchoRequest(bl));
            }

            public void write(byte[] byArray) throws IOException {
                SSH.this.source.write(byArray);
            }
        };
        pluginBus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig pluginConfig) {
                SSH.this.user = pluginConfig.getProperty("SSH", string, "user");
                SSH.this.pass = pluginConfig.getProperty("SSH", string, "password");
            }
        });
        pluginBus.registerPluginListener(new OnlineStatusListener(){

            public void online() {
                if (SSH.this.pass == null) {
                    Frame frame = new Frame("SSH User Authentication");
                    Panel panel = new Panel(new GridLayout(3, 1));
                    panel.add(new Label("SSH Authorization required"));
                    panel.add(new Label("SSH implementation 1998 by Cedric Gourio"));
                    panel.add(new Label("Adapted 1999 to the JTA by Matthias L. Jugel"));
                    frame.add("North", panel);
                    panel = new Panel(new GridLayout(2, 2));
                    TextField textField = new TextField(SSH.this.user, 10);
                    TextField textField2 = new TextField(10);
                    textField.addActionListener(new ActionListener(this, textField2){
                        private final /* synthetic */ TextField val$passw;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$passw = textField;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            this.val$passw.requestFocus();
                        }
                    });
                    textField2.setEchoChar('*');
                    panel.add(new Label("User name"));
                    panel.add(textField);
                    panel.add(new Label("Password"));
                    panel.add(textField2);
                    frame.add("Center", panel);
                    panel = new Panel();
                    Button button = new Button("Cancel");
                    Button button2 = new Button("Login");
                    ActionListener actionListener = new ActionListener(this, textField, textField2, frame){
                        private final /* synthetic */ TextField val$login;
                        private final /* synthetic */ TextField val$passw;
                        private final /* synthetic */ Frame val$frame;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$login = textField;
                            this.val$passw = textField2;
                            this.val$frame = frame;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            3.access$000(this.this$1).handler.setLogin(this.val$login.getText());
                            3.access$000(this.this$1).handler.setPassword(this.val$passw.getText());
                            this.val$frame.dispose();
                            SSH.access$102(3.access$000(this.this$1), true);
                        }
                    };
                    button2.addActionListener(actionListener);
                    textField2.addActionListener(actionListener);
                    button.addActionListener(new ActionListener(this, frame){
                        private final /* synthetic */ Frame val$frame;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$frame = frame;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            this.val$frame.dispose();
                        }
                    });
                    panel.add(button);
                    panel.add(button2);
                    frame.add("South", panel);
                    frame.pack();
                    frame.show();
                    ((Component)frame).setLocation(frame.getToolkit().getScreenSize().width / 2 - frame.getSize().width / 2, frame.getToolkit().getScreenSize().height / 2 - frame.getSize().height / 2);
                } else {
                    SSH.this.error(SSH.this.user + ":" + SSH.this.pass);
                    SSH.this.handler.setLogin(SSH.this.user);
                    SSH.this.handler.setPassword(SSH.this.pass);
                    SSH.this.auth = true;
                }
            }

            public void offline() {
                SSH.this.handler.disconnect();
                SSH.this.auth = false;
            }

            static /* synthetic */ SSH access$000(3 var0) {
                return var0.SSH.this;
            }
        });
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
        this.source = filterPlugin;
    }

    public int read(byte[] byArray) throws IOException {
        while (!this.auth) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.buffer != null) {
            int n = this.buffer.length - this.pos <= byArray.length ? this.buffer.length - this.pos : byArray.length;
            System.arraycopy(this.buffer, this.pos, byArray, 0, n);
            if (this.pos + n < this.buffer.length) {
                this.pos += n;
            } else {
                this.buffer = null;
            }
            return n;
        }
        int n = this.source.read(byArray);
        if (n > 0) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            this.buffer = this.handler.handleSSH(byArray2);
            if (this.buffer != null && this.buffer.length > 0) {
                int n2 = this.buffer.length <= byArray.length ? this.buffer.length : byArray.length;
                System.arraycopy(this.buffer, 0, byArray, 0, n2);
                this.pos = n = n2;
                if (n2 == this.buffer.length) {
                    this.buffer = null;
                    this.pos = 0;
                }
            } else {
                return 0;
            }
        }
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        if (!this.auth) {
            return;
        }
        int n = 0;
        while (n < byArray.length) {
            switch (byArray[n]) {
                case 10: {
                    byArray[n] = 13;
                }
            }
            ++n;
        }
        this.handler.sendData(new String(byArray));
    }
}

