/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.SocketListener;
import de.mud.jta.event.SocketRequest;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Hashtable;

public class MudConnector
extends Plugin
implements VisualPlugin,
Runnable,
ActionListener {
    private static final int debug = 0;
    protected URL listURL = null;
    protected int step;
    protected Hashtable mudList = null;
    protected List mudListSelector = new List();
    protected TextField mudName;
    protected TextField mudAddr;
    protected TextField mudPort;
    protected Button connect;
    protected Panel mudListPanel;
    protected CardLayout layouter;
    protected ProgressBar progress;
    protected Label errorLabel;
    protected Menu MCMenu;

    public MudConnector(PluginBus pluginBus, final String string) {
        super(pluginBus, string);
        pluginBus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig pluginConfig) {
                String string3 = pluginConfig.getProperty("MudConnector", string, "listURL");
                if (string3 != null) {
                    try {
                        MudConnector.this.listURL = new URL(string3);
                    }
                    catch (Exception exception) {
                        MudConnector.this.error("" + exception);
                        MudConnector.this.errorLabel.setText("Error: " + exception);
                    }
                } else {
                    MudConnector.this.error("no listURL specified");
                    MudConnector.this.errorLabel.setText("Missing list URL");
                    MudConnector.this.layouter.show(MudConnector.this.mudListPanel, "ERROR");
                }
                String string2 = pluginConfig.getProperty("MudConnector", string, "step");
                try {
                    MudConnector.this.step = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    if (string2 != null) {
                        MudConnector.this.error("warning: " + string2 + " is not a number");
                    }
                    MudConnector.this.step = 10;
                }
            }
        });
        pluginBus.registerPluginListener(new SocketListener(){

            public void connect(String string, int n) {
                MudConnector.this.setup();
            }

            public void disconnect() {
                MudConnector.this.setup();
            }
        });
        this.layouter = new CardLayout();
        this.mudListPanel = new Panel(this.layouter){

            public void update(Graphics graphics) {
                this.paint(graphics);
            }
        };
        this.errorLabel = new Label("Loading ...");
        this.mudListPanel.add("ERROR", this.errorLabel);
        Panel panel = new Panel(new BorderLayout());
        panel.add("North", new Label("Loading mud list ... please wait"));
        this.progress = new ProgressBar();
        panel.add("Center", this.progress);
        this.mudListPanel.add("PROGRESS", panel);
        panel = new Panel(new BorderLayout());
        panel.add("Center", this.mudListSelector);
        this.mudListPanel.add("MUDLIST", panel);
        Panel panel2 = panel;
        panel = new Panel(new GridLayout(3, 1));
        panel2.add("East", panel);
        this.mudName = new TextField(20);
        panel.add(this.mudName);
        this.mudName.setEditable(false);
        Panel panel3 = new Panel(new BorderLayout());
        this.mudAddr = new TextField(20);
        panel3.add("Center", this.mudAddr);
        this.mudAddr.setEditable(false);
        this.mudPort = new TextField(6);
        panel3.add("East", this.mudPort);
        this.mudPort.setEditable(false);
        panel.add(panel3);
        this.connect = new Button("Connect");
        panel.add(this.connect);
        this.connect.addActionListener(this);
        this.mudListSelector.addActionListener(this);
        this.mudListSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        String string = MudConnector.this.mudListSelector.getSelectedItem();
                        MudConnector.this.mudName.setText(string);
                        Object[] objectArray = (Object[])MudConnector.this.mudList.get(string);
                        MudConnector.this.mudAddr.setText((String)objectArray[0]);
                        MudConnector.this.mudPort.setText(((Integer)objectArray[1]).toString());
                        break;
                    }
                    case 2: {
                        MudConnector.this.mudName.setText("");
                        MudConnector.this.mudAddr.setText("");
                        MudConnector.this.mudPort.setText("");
                    }
                }
            }
        });
        this.layouter.show(this.mudListPanel, "PROGRESS");
        this.MCMenu = new Menu("MudConnector");
    }

    private void setup() {
        if (this.mudList == null && this.listURL != null) {
            new Thread(this).start();
        }
    }

    public void run() {
        try {
            int n;
            Hashtable<String, Menu> hashtable = new Hashtable<String, Menu>();
            this.mudList = new Hashtable();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.listURL.openStream()));
            String string = bufferedReader.readLine();
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.error("number of muds: " + numberFormatException);
            }
            System.out.println("MudConnector: expecting " + n2 + " mud entries");
            this.progress.setMax(n2);
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.resetSyntax();
            streamTokenizer.whitespaceChars(0, 9);
            streamTokenizer.ordinaryChars(32, 255);
            streamTokenizer.wordChars(32, 255);
            int n3 = 0;
            int n4 = 0;
            while ((n = streamTokenizer.nextToken()) != -1) {
                String string2 = streamTokenizer.sval;
                n = streamTokenizer.nextToken();
                if (n != -1) {
                    if (n == 10) {
                        this.error(string2 + ": unexpected end of line" + ", missing host and port");
                    }
                    String string3 = streamTokenizer.sval;
                    Integer n5 = new Integer(23);
                    n = streamTokenizer.nextToken();
                    if (n != -1) {
                        try {
                            if (n == 10) {
                                this.error(string2 + ": default port 23");
                            }
                            n5 = new Integer(streamTokenizer.sval);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.error("port for " + string2 + ": " + numberFormatException);
                        }
                    }
                    this.mudList.put(string2, new Object[]{string3, n5, new Integer(n4++)});
                    this.mudListSelector.add(string2);
                    this.progress.adjust(++n3, string2);
                    this.mudListPanel.repaint();
                    Menu menu = (Menu)hashtable.get(string2.charAt(0) + "");
                    if (menu == null) {
                        menu = new Menu(string2.charAt(0) + "");
                        this.MCMenu.add(menu);
                        hashtable.put(string2.charAt(0) + "", menu);
                    }
                    MenuItem menuItem = new MenuItem(string2);
                    menuItem.addActionListener(this);
                    menu.add(menuItem);
                }
                while (n != -1 && n != 10) {
                    n = streamTokenizer.nextToken();
                }
            }
            System.out.println("MudConnector: found " + this.mudList.size() + " entries");
        }
        catch (Exception exception) {
            this.error("error: " + exception);
            this.errorLabel.setText("Error: " + exception);
            this.layouter.show(this.mudListPanel, "ERROR");
        }
        this.layouter.show(this.mudListPanel, "MUDLIST");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getSource() instanceof MenuItem) {
            string = actionEvent.getActionCommand();
            int n = (Integer)((Object[])this.mudList.get(string))[2];
            this.mudListSelector.select(n);
            this.mudListSelector.makeVisible(n);
            this.mudName.setText(string);
            Object[] objectArray = (Object[])this.mudList.get(string);
            this.mudAddr.setText((String)objectArray[0]);
            this.mudPort.setText(((Integer)objectArray[1]).toString());
        }
        string = this.mudAddr.getText();
        String string2 = this.mudPort.getText();
        if (string != null) {
            this.bus.broadcast(new SocketRequest());
            if (string2 == null || string2.length() <= 0) {
                string2 = "23";
            }
            this.bus.broadcast(new SocketRequest(string, Integer.parseInt(string2)));
        }
    }

    public Component getPluginVisual() {
        return this.mudListPanel;
    }

    public Menu getPluginMenu() {
        return this.MCMenu;
    }

    class ProgressBar
    extends Component {
        int max;
        int current;
        String text;
        Dimension size = new Dimension(250, 20);
        Image backingStore;

        ProgressBar() {
        }

        public void setMax(int n) {
            this.max = n;
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            if (this.backingStore == null) {
                this.backingStore = this.createImage(this.getSize().width, this.getSize().height);
                this.redraw();
            }
            graphics.drawImage(this.backingStore, 0, 0, this);
        }

        private void redraw() {
            if (this.backingStore == null || this.text == null) {
                return;
            }
            Graphics graphics = this.backingStore.getGraphics();
            int n = (int)((float)this.current / (float)this.max * (float)this.getSize().width);
            graphics.fill3DRect(0, 0, this.getSize().width, this.getSize().height, false);
            graphics.setColor(this.getBackground());
            graphics.fill3DRect(0, 0, n, this.getSize().height, true);
            graphics.setColor(this.getForeground());
            graphics.setXORMode(this.getBackground());
            graphics.drawString("" + this.current * 100 / (this.max > 0 ? this.max : 1) + "%", this.getSize().width / 2 - 15, this.getSize().height / 2);
            graphics.drawString(this.text, this.getSize().width / 2 - this.getFontMetrics(this.getFont()).stringWidth(this.text) / 2, this.getSize().height / 2 + 12);
            this.paint(this.getGraphics());
        }

        public void adjust(int n, String string) {
            this.current = n;
            if (this.current > this.max) {
                this.current = this.max;
            }
            this.text = string;
            if ((float)this.current / (float)MudConnector.this.step == (float)(this.current / MudConnector.this.step)) {
                this.redraw();
            }
        }

        public void setSize(int n, int n2) {
            this.size = new Dimension(n, n2);
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        public Dimension getMinimumSize() {
            return this.size;
        }
    }
}

