
require './user-lib.pl';

# acl_security_form(&options)
# Output HTML for editing security options for the useradmin module
sub acl_security_form
{
local $o = $_[0];

print "<tr> <td valign=top><b>$text{'acl_uedit'}</b></td> <td colspan=3>\n";
printf "<input type=radio name=uedit_mode value=0 %s> $text{'acl_uedit_all'}&nbsp;&nbsp;\n",
	$o->{'uedit_mode'} == 0 ? "checked" : "";
printf "<input type=radio name=uedit_mode value=1 %s> $text{'acl_uedit_none'}<br>\n",
	$o->{'uedit_mode'} == 1 ? "checked" : "";
printf "<input type=radio name=uedit_mode value=2 %s> $text{'acl_uedit_only'}\n",
	$o->{'uedit_mode'} == 2 ? "checked" : "";
printf "<input name=uedit_can size=40 value='%s'> %s<br>\n",
	$o->{'uedit_mode'} == 2 ? $o->{'uedit'} : "",
	&user_chooser_button("uedit_can", 1);
printf "<input type=radio name=uedit_mode value=3 %s> $text{'acl_uedit_except'}\n",
	$o->{'uedit_mode'} == 3 ? "checked" : "";
printf "<input name=uedit_cannot size=40 value='%s'> %s<br>\n",
	$o->{'uedit_mode'} == 3 ? $o->{'uedit'} : "",
	&user_chooser_button("uedit_cannot", 1);
printf "<input type=radio name=uedit_mode value=4 %s> $text{'acl_uedit_uid'}\n",
	$o->{'uedit_mode'} == 4 ? "checked" : "";
printf "<input name=uedit_uid size=6 value='%s'> - \n",
	$o->{'uedit_mode'} == 4 ? $o->{'uedit'} : "";
printf "<input name=uedit_uid2 size=6 value='%s'><br>\n",
	$o->{'uedit_mode'} == 4 ? $o->{'uedit2'} : "";
printf "<input type=radio name=uedit_mode value=5 %s> $text{'acl_uedit_group'}\n",
	$o->{'uedit_mode'} == 5 ? "checked" : "";
printf "<input name=uedit_group size=8 value='%s'> %s</td> </tr>\n",
	$o->{'uedit_mode'} == 5 ? $dummy=getgrgid($o->{'uedit'}) : "",
	&group_chooser_button("uedit_group", 0);

print "<tr> <td><b>$text{'acl_ucreate'}</b></td> <td colspan=3>\n";
printf "<input type=radio name=ucreate value=1 %s> $text{'yes'}\n",
	$o->{'ucreate'} ? "checked" : "";
printf "<input type=radio name=ucreate value=0 %s> $text{'no'}</td> </tr>\n",
	$o->{'ucreate'} ? "" : "checked";

print "<tr> <td><b>$text{'acl_uid'}</b></td>\n";
print "<td colspan=3><input name=lowuid size=6 value='$o->{'lowuid'}'> -\n";
print "<input name=hiuid size=6 value='$o->{'hiuid'}'> &nbsp;\n";
printf "<input type=checkbox name=umultiple value=1 %s>\n",
	$o->{'umultiple'} ? "checked" : "";
print "$text{'acl_umultiple'}</td> </tr>\n";

print "<tr> <td><b>$text{'acl_ugroups'}</b></td> <td colspan=3>\n";
printf "<input type=radio name=ugroups_def value=1 %s> $text{'acl_all'}\n",
	$o->{'ugroups'} eq "*" ? "checked" : "";
printf "<input type=radio name=ugroups_def value=0 %s>\n",
	$o->{'ugroups'} eq "*" ? "" : "checked";
printf "<input name=ugroups size=40 value='%s'> %s</td> </tr>\n",
	$o->{'ugroups'} eq "*" ? "" : $o->{'ugroups'},
	&group_chooser_button("ugroups", 1);

print "<tr> <td valign=top><b>$text{'acl_shells'}</b></td> <td colspan=3>\n";
printf "<input type=radio name=shells_def value=1 %s> $text{'acl_any'}\n",
	$o->{'shells'} eq "*" ? "checked" : "";
printf "<input type=radio name=shells_def value=0 %s> $text{'acl_listed'}<br>\n",
	$o->{'shells'} eq "*" ? "" : "checked";
print "<textarea name=shells rows=3 cols=40>",
	$o->{'shells'} eq "*" ? "" : join("\n", split(/\s+/, $o->{'shells'})),
	"</textarea></td> </tr>\n";

print "<tr> <td><b>$text{'acl_epeopt'}</b></td> <td colspan=3>\n";
printf "<input type=radio name=peopt value=1 %s> $text{'yes'}\n",
	$o->{'peopt'} ? "checked" : "";
printf "<input type=radio name=peopt value=0 %s> $text{'no'}</td> </tr>\n",
	$o->{'peopt'} ? "" : "checked";

print "<tr> <td valign=top><b>$text{'acl_home'}</b></td>\n";
printf "<td colspan=3><input name=home size=40 value='%s'> %s<br>\n",
	$o->{'home'}, &file_chooser_button("home", 1);
printf "<input type=checkbox name=autohome value=1 %s> %s</td> </tr>\n",
	$o->{'autohome'} ? "checked" : "",
	$text{'acl_autohome'};

print "<tr> <td colspan=4><hr></td> </tr>\n";

print "<tr> <td valign=top><b>$text{'acl_gedit'}</b></td> <td colspan=3>\n";
printf "<input type=radio name=gedit_mode value=0 %s> $text{'acl_gedit_all'}&nbsp;&nbsp;\n",
	$o->{'gedit_mode'} == 0 ? "checked" : "";
printf "<input type=radio name=gedit_mode value=1 %s> $text{'acl_gedit_none'}<br>\n",
	$o->{'gedit_mode'} == 1 ? "checked" : "";
printf "<input type=radio name=gedit_mode value=2 %s> $text{'acl_gedit_only'}\n",
	$o->{'gedit_mode'} == 2 ? "checked" : "";
printf "<input name=gedit_can size=40 value='%s'> %s<br>\n",
	$o->{'gedit_mode'} == 2 ? $o->{'gedit'} : "",
	&group_chooser_button("gedit_can", 1);
printf "<input type=radio name=gedit_mode value=3 %s> $text{'acl_gedit_except'}\n",
	$o->{'gedit_mode'} == 3 ? "checked" : "";
printf "<input name=gedit_cannot size=40 value='%s'> %s<br>\n",
	$o->{'gedit_mode'} == 3 ? $o->{'gedit'} : "",
	&group_chooser_button("gedit_cannot", 1);
printf "<input type=radio name=gedit_mode value=4 %s> $text{'acl_gedit_gid'}\n",
	$o->{'gedit_mode'} == 4 ? "checked" : "";
printf "<input name=gedit_gid size=6 value='%s'> -\n",
	$o->{'gedit_mode'} == 4 ? $o->{'gedit'} : "";
printf "<input name=gedit_gid2 size=6 value='%s'></td> </tr>\n",
	$o->{'gedit_mode'} == 4 ? $o->{'gedit2'} : "";

print "<tr> <td><b>$text{'acl_gcreate'}</b></td> <td colspan=3>\n";
printf "<input type=radio name=gcreate value=1 %s> $text{'yes'}\n",
	$o->{'gcreate'}==1 ? "checked" : "";
printf "<input type=radio name=gcreate value=2 %s> $text{'acl_gnew'}\n",
	$o->{'gcreate'}==2 ? "checked" : "";
printf "<input type=radio name=gcreate value=0 %s> $text{'no'}</td> </tr>\n",
	$o->{'gcreate'}==0 ? "checked" : "";

print "<tr> <td><b>$text{'acl_gid'}</b></td>\n";
print "<td colspan=3><input name=lowgid size=6 value='$o->{'lowgid'}'> -\n";
print "<input name=higid size=6 value='$o->{'higid'}'> &nbsp;\n";
printf "<input type=checkbox name=gmultiple value=1 %s>\n",
	$o->{'gmultiple'} ? "checked" : "";
print "$text{'acl_gmultiple'}</td> </tr>\n";

print "<tr> <td colspan=4><hr></td> </tr>\n";

print "<tr><td valign=top><b>$text{'acl_logins'}</b></td> <td colspan=3>\n";
printf "<input type=radio name=logins_mode value=0 %s> $text{'acl_lnone'}<br>\n",
	$o->{'logins'} ? "" : "checked";
printf "<input type=radio name=logins_mode value=1 %s> $text{'acl_lall'}<br>\n",
	$o->{'logins'} eq "*" ? "checked" : "";
printf "<input type=radio name=logins_mode value=2 %s>\n",
	$o->{'logins'} =~ /[^\*]/ ? "checked" : "";
printf "<input name=logins size=40 value='%s'> %s</td> </tr>\n",
	$o->{'logins'} =~ /[^\*]/ ? $o->{'logins'} : "",
	&user_chooser_button("logins", 1);
}

# acl_security_save(&options)
# Parse the form for security options for the useradmin module
sub acl_security_save
{
$_[0]->{'lowuid'} = $in{'lowuid'};
$_[0]->{'hiuid'} = $in{'hiuid'};
$_[0]->{'lowgid'} = $in{'lowgid'};
$_[0]->{'higid'} = $in{'higid'};
$_[0]->{'uedit_mode'} = $in{'uedit_mode'};
$_[0]->{'uedit'} = $in{'uedit_mode'} == 2 ? $in{'uedit_can'} :
		   $in{'uedit_mode'} == 3 ? $in{'uedit_cannot'} :
		   $in{'uedit_mode'} == 4 ? $in{'uedit_uid'} :
		   $in{'uedit_mode'} == 5 ? getgrnam($in{'uedit_group'}) : "";
$_[0]->{'uedit2'} = $in{'uedit_mode'} == 4 ? $in{'uedit_uid2'} : undef;
$_[0]->{'gedit_mode'} = $in{'gedit_mode'};
$_[0]->{'gedit'} = $in{'gedit_mode'} == 2 ? $in{'gedit_can'} :
		   $in{'gedit_mode'} == 3 ? $in{'gedit_cannot'} :
		   $in{'gedit_mode'} == 4 ? $in{'gedit_gid'} : "";
$_[0]->{'gedit2'} = $in{'gedit_mode'} == 4 ? $in{'gedit_gid2'} : undef;
$_[0]->{'ucreate'} = $in{'ucreate'};
$_[0]->{'gcreate'} = $in{'gcreate'};
$_[0]->{'ugroups'} = $in{'ugroups_def'} ? "*" : $in{'ugroups'};
$_[0]->{'logins'} = $in{'logins_mode'} == 0 ? "" :
		    $in{'logins_mode'} == 1 ? "*" : $in{'logins'};
$_[0]->{'shells'} = $in{'shells_def'} ? "*"
				      : join(" ", split(/\s+/, $in{'shells'}));
$_[0]->{'peopt'} = $in{'peopt'};
$_[0]->{'home'} = $in{'home'};
$_[0]->{'autohome'} = $in{'autohome'};
$_[0]->{'umultiple'} = $in{'umultiple'};
$_[0]->{'gmultiple'} = $in{'gmultiple'};
}

