#!/usr/local/bin/perl
# edit_logs.cgi
# A form for editing logging options

require './squid-lib.pl';
&header($text{'elogs_header'}, "", "edit_logs", 0, 0, 0, &restart_button());
print "<hr>\n";
$conf = &get_config();

print "<form action=save_logs.cgi>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'elogs_lalo'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr>\n";
print &opt_input($text{'elogs_alf'}, "cache_access_log", $conf, $text{'default'}, 20);
print &opt_input($text{'elogs_dlf'}, "cache_log", $conf, $text{'default'}, 20);
print "</tr>\n";

print "<tr>\n";
print &opt_input($text{'elogs_slf'}, "cache_store_log", $conf, $text{'default'}, 20);
print &opt_input($text{'elogs_cmf'}, "cache_swap_log", $conf, $text{'default'}, 20);
print "</tr>\n";

print "<tr>\n";
print &choice_input($text{'elogs_uhlf'}, "emulate_httpd_log", $conf,
		    "off", $text{'yes'}, "on", $text{'no'}, "off");
print &choice_input($text{'elogs_lmh'}, "log_mime_hdrs", $conf,
		    "off", $text{'yes'}, "on", $text{'no'}, "off");
print "</tr>\n";

print "<tr>\n";
print &opt_input($text{'elogs_ualf'}, "useragent_log", $conf, $text{'none'}, 20);
print &opt_input($text{'elogs_pf'}, "pid_filename", $conf, $text{'default'}, 20);
print "</tr>\n";

if ($squid_version >= 2.2) {
	@ident = &find_config("ident_lookup_access", $conf);
	foreach $i (@ident) {
		local @v = @{$i->{'values'}};
		if ($v[0] eq "allow") { map { $ila{$_}++ } @v[1..$#v]; }
		elsif ($v[0] eq "deny" && $v[1] ne "all") { $bad_ident++; }
		}
	if (!$bad_ident) {
		print "<tr><td valign=top><b>$text{'elogs_prilfa'}</b></td> <td colspan=3>\n";
		@acls = &find_config("acl", $conf);
		foreach $acl (@acls) {
			$aclv = $acl->{'values'}->[0];
			printf "<input type=checkbox name=ident_lookup_access ".
			       "value=$aclv %s>$aclv\n",
				$ila{$aclv} ? "checked" : "";
			}
		print "</td> </tr>\n";
		}
	else { print "<input type=hidden name=complex_ident value=1>\n"; }
	print "<tr>\n";
	print &opt_time_input($text{'elogs_rit'}, "ident_timeout",
			      $conf, $text{'default'}, 6);
	}
else {
	print "<tr>\n";
	print &choice_input($text{'elogs_dril'}, "ident_lookup", $conf,
			    "off", $text{'yes'}, "on", $text{'no'}, "off");
	}
print &choice_input($text{'elogs_lfh'}, "log_fqdn", $conf,
		    "off", $text{'yes'}, "on", $text{'no'}, "off");
print "</tr>\n";

print "<tr>\n";
print &opt_input($text{'elogs_ln'}, "client_netmask", $conf, $text{'default'}, 15);
print &opt_input($text{'elogs_do'}, "debug_options", $conf, $text{'default'}, 15);
print "</tr>\n";

if ($squid_version >= 2) {
	print "<tr>\n";
	print &opt_input($text{'elogs_mht'}, "mime_table",
			 $conf, $text{'default'}, 20);
	print "</tr>\n";
	}

print "</table></td></tr></table><br>\n";
print "<input type=submit value=$text{'buttsave'}></form>\n";

print "<hr>\n";
&footer("", $text{'elogs_return'});

