#!/usr/local/bin/perl
# save_host.cgi
# Create, update or delete a host address

require './net-lib.pl';
&ReadParse();
@hosts = &list_hosts();
if ($in{'delete'}) {
	# deleting a host
	&delete_host($hosts[$in{'idx'}]);
	}
else {
	# saving or updating a host
	$whatfailed = "Failed to save host";
	&check_ipaddress($in{'address'}) ||
		&error("'$in{'address'}' is not a valid IP address");
	@h = split(/\s+/, $in{'hosts'});
	foreach $h (@h) {
		$h =~ /^[A-z0-9\-\.]+$/ ||
			&error("'$h' is not a valid hostname");
		}
	@h>0 || &error("You must enter at least one hostname");
	if ($in{'new'}) {
		# saving a host
		$host = { 'address' => $in{'address'},
			  'hosts' => \@h };
		&create_host($host);
		}
	else {
		# updating a host
		$host = $hosts[$in{'idx'}];
		$host->{'address'} = $in{'address'};
		$host->{'hosts'} = \@h;
		&modify_host($host);
		}
	}
&redirect("list_hosts.cgi");

