#!/usr/local/bin/perl
# save_global.cgi
# Save global majordomo options

require './majordomo-lib.pl';
&ReadParse();
%access = &get_module_acl();
$access{'global'} || &error("You are not allowed to edit global options");
$conf = &get_config();
$whatfailed = "Failed to save global options";

# Check inputs
$in{'whereami'} =~ /^[A-z0-9\-\.]+$/ ||
	&error("Missing or invalid mail server hostname");
$in{'whoami'} =~ /^\S+$/ ||
	&error("Missing or invalid Majordomo address");
$in{'whoami_owner'} =~ /^\S+$/ ||
	&error("Missing or invalid owner's address");
-x $in{'sendmail_command'} ||
	&error("Sendmail command '$in{'sendmail_command'}' does not exist");

# Save inputs
&save_directive($conf, "whereami", $in{'whereami'});
&save_directive($conf, "whoami", $in{'whoami'});
&save_directive($conf, "whoami_owner", $in{'whoami_owner'});
&save_directive($conf, "sendmail_command", $in{'sendmail_command'});
&flush_file_lines();
&redirect("");

