
require './majordomo-lib.pl';

# acl_security_form(&options)
# Output HTML for editing security options for the majordomo module
sub acl_security_form
{
local $conf = &get_config();
local @lists = &list_lists($conf);
print "<tr> <td valign=top rowspan=3><b>Mailing lists ",
      "this user can manage</b></td>\n";
print "<td rowspan=3 valign=top><select name=lists multiple size=5>\n";
local (%lcan, $l);
map { $lcan{$_}++ } split(/\s+/, $_[0]->{'lists'});
foreach $l (@lists) {
	printf "<option %s>%s\n",
		$lcan{$l} || $lcan{"*"} ? "selected" : "", $l;
	}
print "</select></td>\n";

print "<td><b>Can edit global options?</b></td> <td>\n";
printf "<input type=radio name=global value=1 %s> Yes\n",
	$_[0]->{'global'} ? "checked" : "";
printf "<input type=radio name=global value=0 %s> No</td> </tr>\n",
	$_[0]->{'global'} ? "" : "checked";

print "<tr> <td><b>Can create new mailing lists?</b></td> <td>\n";
printf "<input type=radio name=create value=1 %s> Yes\n",
	$_[0]->{'create'} ? "checked" : "";
printf "<input type=radio name=create value=0 %s> No</td> </tr>\n",
	$_[0]->{'create'} ? "" : "checked";

print "<tr> <td><b>Can edit list membership?</b></td> <td>\n";
printf "<input type=radio name=edit value=1 %s> Yes\n",
	$_[0]->{'edit'} ? "checked" : "";
printf "<input type=radio name=edit value=0 %s> No</td> </tr>\n",
	$_[0]->{'edit'} ? "" : "checked";
}

# acl_security_save(&options)
# Parse the form for security options for the majordomo module
sub acl_security_save
{
local $conf = &get_config();
local @lists = &list_lists($conf);
local @sel = split(/\0/, $in{'lists'});
if (scalar(@sel) == scalar(@lists)) {
	$_[0]->{'lists'} = "*";
	}
else {
	$_[0]->{'lists'} = join(" ", @sel);
	}
$_[0]->{'global'} = $in{'global'};
$_[0]->{'create'} = $in{'create'};
$_[0]->{'edit'} = $in{'edit'};
}

