#!/usr/local/bin/perl
# help.cgi
# Displays help HTML for some module, with substitutions

require './web-lib.pl';
&error_setup($text{'help_err'});
$ENV{'PATH_INFO'} =~ /^\/(\S+)\/(\S+)$/ || &error($text{'help_epath'});
$module = $1; $file = $2;
&init_config();

# read the help file
$path = &help_file($module, $file);
@st = stat($path);
open(HELP, $path) || &helperror(&text('help_efile', $path));
read(HELP, $help, $st[7]);
close(HELP);

# find and replace the <header> section
if ($help =~ s/<header>([^<]+)<\/header>/<center><h1>$1<\/h1><\/center><hr>/) {
	&header($1);
	}
else {
	&helperror($text{'help_eheader'});
	}

# find and replace <include> directives
$help =~ s/<include\s+(\S+)>/inchelp($1)/ge;

# find and replace <if><else> directives
$help =~ s/<if\s+([^>]*)>([\000-\177]*?)<else>([\000-\177]*?)<\/if>/ifhelp($1, $2, $3)/ge;

# find and replace <if> directives
$help =~ s/<if\s+([^>]*)>([\000-\177]*?)<\/if>/ifhelp($1, $2)/ge;

# find and replace <exec> directives
$help =~ s/<exec\s+([^>]*)>/exechelp($1)/ge;

# output the HTML
print $help;

# inchelp(path)
sub inchelp
{
if ($_[0] =~ /^\/(\S+)\/(\S+)$/) {
	# including something from another module..
	}
else {
	# including from this module
	local $ipath = &help_file($module, $_[0]);
	@st = stat($ipath);
	open(INC, $ipath) ||
		return "<i>".&text('help_einclude', $_[0])."</i><br>\n";
	read(INC, $inc, $st[7]);
	close(INC);
	return $inc;
	}
}

# ifhelp(perl, text, [elsetext])
sub ifhelp
{
local $rv = eval $_[0];
if ($@) { return "<i>".&text('help_eif', $_[0], $@)."</i><br>\n"; }
elsif ($rv) { return $_[1]; }
else { return $_[2]; }
}

# exechelp(perl)
sub exechelp
{
local $rv = eval $_[0];
if ($@) { return "<i>".&text('help_eexec', $_[0], $@)."</i><br>\n"; }
else { return $rv; }
}

# help_file(module, file)
sub help_file
{
local $lang = "$_[0]/help/$_[1].$current_lang.html";
local $def = "$_[0]/help/$_[1].html";
return -r $lang ? $lang : $def;
}

sub helperror
{
&header($text{'error'});
print "<center><h2>$text{'error'}</h2></center>\n";
print "<hr><p><b>",@_,"</b><p><hr>\n";
exit;
}

