#!/usr/local/bin/perl
# tunefs_form.cgi
# Display a form for entering filesystem tuning options

require './format-lib.pl';
&ReadParse();
&can_edit_disk($in{'dev'}) || &error("You are not allowed to tune this disk");
&header("Tune Filesystem", "");
print "<hr>\n";

@stat = &device_status($in{dev});
if (@stat) { $mnt = " for mounting on <tt><b>$stat[0]</b></tt>"; }
$fs = &filesystem_type($in{dev});
print "<form action=tunefs.cgi>\n";
print "<input type=hidden name=dev value=\"$in{dev}\">\n";
print "This form allows you to adjust various parameters of the\n";
print "<b>",&fstype_name($fs), "</b> on <b><tt>$in{dev}</tt></b>$mnt.\n";
print "Existing files on this filesystem will not be effected. <p>\n";

print "<table border width=100%>\n";
print "<tr $tb> <td><b>Tuning Parameters</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";
&opt_input("Max contiguous blocks", "ufs_a", "", 1);
&opt_input("Rotational delay", "ufs_d", "ms", 0);
&opt_input("Max file blocks per cylinder group", "ufs_e", "", 1);
&opt_input("Reserved space", "ufs_m", "%", 0);
print "<tr> <td align=right><b>Optimize for</b></td>\n";
print "<td><select name=ufs_o>\n";
print "<option value=\"\"> Default\n";
print "<option value=space> Space\n";
print "<option value=time> Time\n";
print "</select></td>\n";
print "</table></td></tr></table><br>\n";

print "<div align=right>\n";
print "<input type=submit value=\"Tune Filesystem\"></form>\n";
print "</div>\n";

print "<hr>\n";
&footer("", "disk list");

