#!/usr/local/bin/perl
# save_part.cgi
# Save an existing partition

require './format-lib.pl';
&ReadParse();

# check start and end
@dlist = &list_disks();
$dinfo = $dlist[$in{'disk'}];
&can_edit_disk($dinfo->{'device'}) ||
	&error("You are not allowed to edit this disk");
if ($in{delete}) {
	# unassigning a partition
	$whatfailed = "Failed to delete partition";
	&modify_partition($in{'disk'}, $in{'part'}, "unassigned", "wu", "", "");
	&redirect("");
	}
else {
	# changing an existing partition
	$whatfailed = "Failed to save partition";
	$in{start} =~ /^\d+$/ ||
		&error("'$in{start}' is not a valid starting cylinder");
	$in{end} =~ /^\d+$/ ||
		&error("'$in{end}' is not a valid ending cylinder");
	$in{start} >= 0 ||
		&error("The starting cylinder must be >0 1");
	$in{end} < $dinfo->{'cyl'} ||
		&error("The ending cylinder must be < $dinfo->{'cyl'}");
	$in{start} < $in{end} ||
		&error("The starting cylinder must be less than the ending");

	# make the change
	$flag = ($in{writable} ? "w" : "r").($in{mountable} ? "m" : "u");
	&modify_partition($in{disk}, $in{part}, $in{tag}, $flag,
			  $in{start}, $in{end});
	&redirect("");
	}

