#!/usr/local/bin/perl
# copy.cgi
# Copy some file or directory

require './file-lib.pl';
&ReadParse();
&switch_acl_uid();
print "Content-type: text/plain\n\n";
if (!&can_access($in{'from'})) {
	print &text('copy_efrom', $in{'from'}),"\n";
	exit;
	}
if (!&can_access($in{'to'})) {
	print &text('copy_eto', $in{'to'}),"\n";
	exit;
	}
if (-l $in{'from'}) {
	# Remake the link
	if (!symlink(readlink($in{'from'}), $in{'to'})) {
		print &text('copy_elink', $!),"\n";
		exit;
		}
	}
elsif (-d $in{'from'}) {
	# Recursively copy with tar
	unlink($in{'to'});
	mkdir($in{'to'}, 0755);
	$out = `(cd $in{'from'} ; tar cf - . | (cd "$in{'to'}" ; tar xf -)) 2>&1`;
	}
else {
	# Simple copy using cp
	unlink($in{'to'});
	$out = `cp -p "$in{'from'}" "$in{'to'}" 2>&1`;
	}
if ($?) { print $out,"\n"; }
else {
	print "\n";
	print &file_info_line($in{'to'}),"\n";
	}

sub split_dir
{
$_[0] =~ /^(.*\/)([^\/]+)$/;
return ($1, $2);
}

